/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DnsTopNInfo;
import com.hs.atic.rmi.DnsTopNRmiService;
import com.hs.atic.rmi.ServerSocketFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZoneDnsTopNServiceRmiImpl
extends UnicastRemoteObject
implements DnsTopNRmiService {
    protected static final Logger LOGGER = LogManager.getInstance().getDBLog();
    private static final long serialVersionUID = -361993334199459136L;

    public ZoneDnsTopNServiceRmiImpl() throws RemoteException {
    }

    public ZoneDnsTopNServiceRmiImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt, ResultSet result) {
        if (null != result) {
            try {
                result.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)"result.close() is error SQLException");
            }
        }
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    protected static void freeDbResource(Connection con, PreparedStatement stmt) {
        try {
            if (null != stmt) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close statement error");
        }
        try {
            if (null != con) {
                con.setAutoCommit(true);
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"when close connection error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DnsTopNInfo> getDnsTopN(Map<String, String> queryMap) throws RemoteException {
        if (null == queryMap || queryMap.size() > 10000) {
            LOGGER.error((Object)"input param is not valid.");
            return new ArrayList<DnsTopNInfo>();
        }
        LOGGER.debug(queryMap);
        Connection con = null;
        PreparedStatement query = null;
        ResultSet result = null;
        long topn = Long.parseLong(queryMap.get("topn"));
        long zoneId = 0L;
        try {
            zoneId = Long.parseLong(queryMap.get("zoneId"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"getDnsTopN zoneId error");
        }
        long endTime = System.currentTimeMillis() / 1000L;
        long startTime = (System.currentTimeMillis() - 86400000L) / 1000L;
        String deviceIpStr = queryMap.get("deviceIp");
        Long deviceIp = 0L;
        if (null != deviceIpStr) {
            deviceIp = IpTransformer.string2LongFormat(deviceIpStr);
        }
        String sql = "SELECT SRC_IP,PPS FROM  ( select SRC_IP,MAX(PPS) AS PPS FROM (SELECT device_type,src_ip,AVG(request_pps) AS PPS FROM atic_src_dns_topn  WHERE ZONE_ID= ? AND LOG_TIME BETWEEN  ? AND  ?  AND  DEVICE_IP = ? GROUP BY device_type,src_ip) gg GROUP BY SRC_IP ) N   ORDER BY PPS DESC LIMIT 0,?";
        ArrayList<DnsTopNInfo> data = new ArrayList<DnsTopNInfo>();
        try {
            con = DBConnPool.getConnection();
            query = con.prepareStatement(sql);
            query.setLong(1, zoneId);
            query.setLong(2, startTime);
            query.setLong(3, endTime);
            query.setLong(4, deviceIp);
            query.setLong(5, topn);
            result = query.executeQuery();
            while (result.next()) {
                String dnsName = "DNS";
                String ip = result.getString("SRC_IP");
                Long pps = result.getLong("PPS");
                DnsTopNInfo info = new DnsTopNInfo();
                info.setDnsName(dnsName);
                info.setIp(ip);
                info.setPps(pps);
                data.add(info);
            }
            ZoneDnsTopNServiceRmiImpl.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query dns src topn error");
        }
        finally {
            ZoneDnsTopNServiceRmiImpl.freeDbResource(con, query, result);
        }
        return data;
    }
}

