/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.atic.collector.util.LogManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class PropertiesLoader {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();

    private PropertiesLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileFullPath, boolean fromClassPath) throws IOException {
        InputStream in = null;
        Properties prop = null;
        try {
            if (fromClassPath) {
                ClassLoader classLoad = PropertiesLoader.class.getClassLoader();
                if (null != classLoad) {
                    in = classLoad.getResourceAsStream(fileFullPath);
                }
            } else {
                in = new FileInputStream(fileFullPath);
            }
            if (in != null) {
                prop = new Properties();
                if ((fileFullPath = Normalizer.normalize(fileFullPath, Normalizer.Form.NFKC)).endsWith("xml")) {
                    prop.loadFromXML(in);
                } else {
                    prop.load(in);
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close file stream failed");
                }
            }
        }
        return prop;
    }
}

