/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.rmi.registry;

import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HaConfiger {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private String configFile = "";
    private Properties properties = new Properties();
    private FileInputStream input = null;
    private FileOutputStream output = null;

    public HaConfiger() {
        String installPath = AticInstallUtil.getInstance().getCollectorInstallPath();
        if (installPath.endsWith("antiddos_collector")) {
            installPath = installPath.replace("antiddos_collector", "");
        }
        this.configFile = installPath + "vsm_ha_server" + File.separator + "config" + File.separator + "config.txt";
        this.load();
    }

    private void load() {
        try {
            this.input = new FileInputStream(this.configFile);
            this.properties.load(this.input);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)("the configFile not found" + this.configFile));
        }
        catch (IOException e) {
            LOGGER.error((Object)"load file failed");
        }
        finally {
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"load close file failed");
            }
        }
    }

    public String getParamenter(String key) {
        String value = this.properties.getProperty(key);
        try {
            if (value != null) {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                value = value.trim();
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("getParamenter UnsupportedEncodingException : " + e.getMessage()));
        }
        return value;
    }

    public List<String> getLocalIps() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumeration.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumeration.nextElement();
                Enumeration<InetAddress> inetAddressEnumeration = networkInterface.getInetAddresses();
                while (inetAddressEnumeration.hasMoreElements()) {
                    InetAddress inetAddress = inetAddressEnumeration.nextElement();
                    if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                    ipList.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error((Object)("getLocalIps SocketException : " + e.getMessage()));
        }
        return ipList;
    }
}

