/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.rmi.registry;

import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import com.huawei.atic.rmi.registry.HaConfiger;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import sun.misc.ObjectInputFilter;
import sun.rmi.registry.RegistryImpl;

public class RegistryProxy
extends RegistryImpl {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private transient HaConfiger haConfiger = new HaConfiger();

    public RegistryProxy(int port, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory) throws RemoteException {
        super(port, rmiClientSocketFactory, rmiServerSocketFactory);
    }

    public RegistryProxy(int port, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory, ObjectInputFilter objectInputFilter) throws RemoteException {
        super(port, rmiClientSocketFactory, rmiServerSocketFactory, objectInputFilter);
    }

    public RegistryProxy(int port) throws RemoteException {
        super(port);
    }

    @Override
    public Remote lookup(String serviceName) throws RemoteException, NotBoundException {
        try {
            String backupIp;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            if (1 == version) {
                return super.lookup(serviceName);
            }
            String clientIp = RegistryProxy.getClientHost();
            DBSysConf dbSysConf = new DBSysConf();
            String dbIps = dbSysConf.querySysValue("manager_ips");
            ArrayList<String> whiteList = new ArrayList<String>();
            String localIp = this.haConfiger.getParamenter("managerIp.local");
            if (!StringUtils.isBlank((String)localIp)) {
                whiteList.add(localIp);
            }
            if (!StringUtils.isBlank((String)(backupIp = this.haConfiger.getParamenter("managerIp.remote")))) {
                whiteList.add(backupIp);
            }
            if (!StringUtils.isBlank((String)dbIps)) {
                String[] ips;
                for (String ip : ips = dbIps.split(",")) {
                    if (StringUtils.isBlank((String)ip)) continue;
                    whiteList.add(ip);
                }
            }
            whiteList.addAll(this.haConfiger.getLocalIps());
            if (!whiteList.contains(clientIp)) {
                LOGGER.error((Object)("the ip " + clientIp + " has no privilege to call the service"));
                throw new NotBoundException(serviceName);
            }
        }
        catch (ServerNotActiveException e) {
            LOGGER.error((Object)("the getClientHost happen exception " + e.getMessage()));
        }
        Remote remote = super.lookup(serviceName);
        return remote;
    }
}

