/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.ha.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigUtil {
    private static final Logger LOGGER = LogManager.getInstance().getHaLog();
    private String configFile = "";
    private Properties properties = new Properties();
    private FileInputStream input = null;
    private FileOutputStream output = null;

    public ConfigUtil(String configFile) {
        this.configFile = configFile;
        this.load();
    }

    private void load() {
        try {
            this.input = new FileInputStream(this.configFile);
            this.properties.load(this.input);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"configFile not found");
        }
        catch (IOException e) {
            LOGGER.error((Object)"load file failed");
        }
        finally {
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"load close file failed");
            }
        }
    }

    public void save() {
        File file = new File(this.configFile);
        try {
            if (!file.exists() && file.createNewFile()) {
                this.output = new FileOutputStream(file);
                this.properties.store(this.output, "haConfig");
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"save file error");
        }
        finally {
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"save output file close error");
            }
        }
    }

    public String getParamenter(String key) {
        String value = this.properties.getProperty(key);
        try {
            if (value != null) {
                value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
                value = value.trim();
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("UnsupportedEncodingException : " + e.getMessage()));
        }
        return value;
    }

    public void setParamenter(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getAllParamenter() {
        return this.properties.toString();
    }
}

