/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.ha.AticInstallUtil;
import com.hs.ha.CmdUtil;
import com.hs.ha.ConfigUtil;
import com.hs.ha.HaRmi;
import com.hs.ha.LogManager;
import com.hs.ha.Manager;
import com.hs.ha.monitor.DatabaseMonitor;
import com.hs.ha.monitor.DatabaseUtil;
import com.hs.ha.monitor.FileMonitor;
import com.hs.ha.monitor.FileUtil;
import com.hs.ha.monitor.HaSwitchMonitor;
import com.hs.ha.monitor.HeartbeatMonitor;
import com.hs.ha.monitor.MysqlSlaveMonitor;
import com.hs.ha.monitor.NetInterfaceMonitor;
import com.hs.ha.monitor.NetUtil;
import com.hs.ha.monitor.WinServiceMonitor;
import com.hs.ha.vo.ConfigInfo;
import com.hs.ha.vo.MonitorInfo;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class Configer {
    public static final int DATABASE_PORT = 13306;
    public static final int HEARTBEAT_PORT = 11089;
    public static final String PRIMARY = "primary";
    public static final String STANDBY = "standby";
    public static final String MONITOR_INFO_FILE_SEND = "up";
    public static final String MONITOR_INFO_FILE_RECEIVE = "up";
    public static final String MONITOR_INFO_OK = "up";
    public static final String MONITOR_INFO_ERROR = "down";
    public static final String MONITOR_INFO_PRIMARY = "primary";
    public static final String MONITOR_INFO_STANDBY = "standby";
    public static final String MONITOR_INFO_MIRROR = "up";
    public static final String MONITOR_INFO_IGNORE = "offline";
    public static final String MONITOR_INFO_BLANK = "--";
    private static final Logger LOGGER = LogManager.getInstance().getHaLog();
    private static String configFile = "config" + System.getProperty("file.separator") + "config.txt";
    private static final int DEFAULT_CYCLE = 60;
    private static final int MIN_CYCLE = 1;
    private static final int MAX_CYCLE = 3600;
    private static final int DEFAULT_FAILED_TIMES = 3;
    private static final int MIN_FAILED_TIMES = 1;
    private static final int MAX_FAILED_TIMES = 100;
    private static final int SECOND = 1000;
    private static Configer instance = new Configer();
    private static ConfigUtil configUtil = new ConfigUtil(configFile);
    private String globalConfigFile = "config" + System.getProperty("file.separator") + "global.properties";
    private String logConfigFile = "config" + System.getProperty("file.separator") + "log.properties";
    private String keystoreConfigFile = "config" + System.getProperty("file.separator") + "keystore.properties";
    private ConfigUtil logConfig = new ConfigUtil(this.logConfigFile);
    private ConfigUtil globalConfig = new ConfigUtil(this.globalConfigFile);
    private ConfigUtil keystoreConfig = new ConfigUtil(this.keystoreConfigFile);

    private Configer() {
    }

    public ConfigUtil getConfigUtil() {
        return configUtil;
    }

    public static Configer getInstance() {
        return instance;
    }

    public boolean isHaPair() {
        return Boolean.parseBoolean(configUtil.getParamenter("haPair"));
    }

    public String getManageLocalIp() {
        return configUtil.getParamenter("managerIp.local");
    }

    public String getManageRemoteIp() {
        return configUtil.getParamenter("managerIp.remote");
    }

    public boolean isHaPrimary() {
        return Boolean.parseBoolean(configUtil.getParamenter("haPrimary"));
    }

    public boolean isHaEnabled() {
        return Boolean.parseBoolean(configUtil.getParamenter("haEnabled"));
    }

    public boolean isAutoSwitch() {
        return Boolean.parseBoolean(configUtil.getParamenter("autoSwitch"));
    }

    public int getDatabaseNumber() {
        return Integer.parseInt(configUtil.getParamenter("database.number"));
    }

    public int getInterfaceNumber() {
        return Integer.parseInt(configUtil.getParamenter("interface.number"));
    }

    public String getLogMessage(int sn) {
        return this.logConfig.getParamenter("log.message." + sn);
    }

    public String getKeystoreInfo(String key) {
        return this.keystoreConfig.getParamenter(key);
    }

    public String getGlobalInfo(String key) {
        String param = "";
        if (this.globalConfig.getParamenter("lang").equalsIgnoreCase("cn")) {
            param = this.globalConfig.getParamenter(key).split(";")[0];
        }
        if (this.globalConfig.getParamenter("lang").equalsIgnoreCase("en")) {
            param = this.globalConfig.getParamenter(key).split(";")[1];
        }
        return param;
    }

    public int getSwitchModifyTimes() {
        return Integer.parseInt(configUtil.getParamenter("ha.switch.modify.times"));
    }

    public String getLocalHeartRmiIp() {
        String ip = configUtil.getParamenter("heartbeat.local");
        return ip;
    }

    public String getRemoteHeartRmiIp() {
        String ip = configUtil.getParamenter("heartbeat.remote");
        return ip;
    }

    public int getHeartRmiPort() {
        int rmiPort = 11089;
        String port = configUtil.getParamenter("heartbeat.port");
        try {
            rmiPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("error:" + e.getMessage()));
        }
        return rmiPort;
    }

    public boolean isFloatIP() {
        return Boolean.parseBoolean(configUtil.getParamenter("float"));
    }

    public String getFloatIP() {
        return configUtil.getParamenter("float.ip");
    }

    public String getFloatInterface() {
        return configUtil.getParamenter("float.interface");
    }

    public String getFloatSubmask() {
        return configUtil.getParamenter("float.submask");
    }

    public String getFloatGateway() {
        return configUtil.getParamenter("float.gateway");
    }

    public String getInstallPath() {
        String installPath = configUtil.getParamenter("install.path");
        if (null == installPath || "".equals(installPath)) {
            installPath = AticInstallUtil.getInstance().getInstallPath() + File.separator;
        }
        return installPath;
    }

    public List<MonitorInfo> buildGlobleMonitorInfo() {
        Vector<MonitorInfo> monitorInfoList = new Vector<MonitorInfo>();
        MonitorInfo haRoleInfo = new MonitorInfo();
        haRoleInfo.setName("haRole");
        if (this.isHaPrimary()) {
            haRoleInfo.setLocalConfig("primary");
            haRoleInfo.setLocalDetail("primary");
            haRoleInfo.setLocalStatus("primary");
            if (this.isHaPair()) {
                haRoleInfo.setRemoteConfig("standby");
                haRoleInfo.setRemoteDetail("standby");
                haRoleInfo.setRemoteStatus("standby");
            }
        } else {
            haRoleInfo.setLocalConfig("standby");
            haRoleInfo.setRemoteConfig("primary");
            haRoleInfo.setLocalDetail("standby");
            haRoleInfo.setRemoteDetail("primary");
            haRoleInfo.setLocalStatus("standby");
            haRoleInfo.setRemoteStatus("primary");
        }
        if (Manager.getInstance().isCurrHaPrimary()) {
            haRoleInfo.setLocalStatus("primary");
            if (this.isHaPair()) {
                haRoleInfo.setRemoteStatus("standby");
            }
        } else {
            haRoleInfo.setLocalStatus("standby");
            haRoleInfo.setRemoteStatus("primary");
        }
        monitorInfoList.add(haRoleInfo);
        return monitorInfoList;
    }

    public HaSwitchMonitor buildHaSwitchMonitor() {
        HaSwitchMonitor haSwitchMonitor = new HaSwitchMonitor();
        String cycle = "2";
        String maxFailedTimes = "1";
        haSwitchMonitor.setCycle(this.parseCycle(cycle));
        haSwitchMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        return haSwitchMonitor;
    }

    public HeartbeatMonitor buildHeartbeatMonitor() {
        HeartbeatMonitor heartbeatMonitor = new HeartbeatMonitor();
        String localIp = configUtil.getParamenter("heartbeat.local");
        String remoteIp = configUtil.getParamenter("heartbeat.remote");
        String port = configUtil.getParamenter("heartbeat.port");
        if (this.checkHeartbeat(localIp, remoteIp)) {
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("heartbeat");
            monitorInfo.setLocalConfig(localIp);
            monitorInfo.setLocalDetail(port);
            monitorInfo.setRemoteConfig(remoteIp);
            monitorInfo.setRemoteDetail(port);
            heartbeatMonitor.addMonitorInfo(monitorInfo);
        }
        if (heartbeatMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("heartbeat.cycle");
            String maxFailedTimes = configUtil.getParamenter("heartbeat.maxFailedTimes");
            heartbeatMonitor.setCycle(this.parseCycle(cycle));
            heartbeatMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        } else {
            HaRmi.getInstance().setMessageRmiConfig();
        }
        return heartbeatMonitor;
    }

    public DatabaseMonitor buildDatabaseMonitor() {
        DatabaseMonitor databaseMonitor = new DatabaseMonitor();
        String ip = "";
        String port = "";
        String type = "";
        String username = "";
        String password = "";
        String testSql = "";
        ArrayList<String> databaseNameList = new ArrayList<String>();
        databaseNameList.add("lego");
        databaseNameList.add("collector");
        type = "mysql";
        testSql = "select @@version";
        ip = configUtil.getParamenter("database.ip");
        port = configUtil.getParamenter("database.port");
        username = configUtil.getParamenter("database.username");
        password = configUtil.getParamenter("database.password");
        if (ip == null || ip.equals("")) {
            ip = "127.0.0.1";
        }
        if (port == null || port.equals("")) {
            port = String.valueOf(13306);
        }
        for (int i = 1; i <= databaseNameList.size(); ++i) {
            String name = (String)databaseNameList.get(i - 1);
            if (!this.checkDatabase(ip, port, type, name, username, password, testSql)) continue;
            DatabaseUtil db = new DatabaseUtil(ip, port, type, name, username, password, testSql);
            databaseMonitor.addDatabase(db);
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("database." + i);
            monitorInfo.setLocalConfig(db.getName());
            monitorInfo.setLocalDetail(db.toString());
            databaseMonitor.addMonitorInfo(monitorInfo);
        }
        if (databaseMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("database.cycle");
            String maxFailedTimes = configUtil.getParamenter("database.maxFailedTimes");
            databaseMonitor.setCycle(this.parseCycle(cycle));
            databaseMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        }
        return databaseMonitor;
    }

    public MysqlSlaveMonitor buildMysqlSlaveMonitor() {
        MysqlSlaveMonitor mysqlSlaveMonitor = new MysqlSlaveMonitor();
        String ip = "";
        String port = "";
        String type = "";
        String username = "";
        String password = "";
        String testSql = "";
        ArrayList<String> databaseNameList = new ArrayList<String>();
        databaseNameList.add("lego");
        type = "mysql";
        testSql = "select @@version";
        ip = configUtil.getParamenter("database.ip");
        port = configUtil.getParamenter("database.port");
        username = configUtil.getParamenter("database.username");
        password = configUtil.getParamenter("database.password");
        if (ip == null || ip.equals("")) {
            ip = "127.0.0.1";
        }
        if (port == null || port.equals("")) {
            port = String.valueOf(13306);
        }
        for (int i = 1; i <= databaseNameList.size(); ++i) {
            String name = (String)databaseNameList.get(i - 1);
            if (!this.checkDatabase(ip, port, type, name, username, password, testSql)) continue;
            DatabaseUtil db = new DatabaseUtil(ip, port, type, name, username, password, testSql);
            mysqlSlaveMonitor.addDatabase(db);
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("databaseHA");
            monitorInfo.setLocalConfig("lego.sys.ha.slavestatus");
            monitorInfo.setLocalDetail(db.toString());
            mysqlSlaveMonitor.addMonitorInfo(monitorInfo);
        }
        if (mysqlSlaveMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("database.cycle");
            String maxFailedTimes = configUtil.getParamenter("database.maxFailedTimes");
            mysqlSlaveMonitor.setCycle(this.parseCycle(cycle));
            mysqlSlaveMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        }
        return mysqlSlaveMonitor;
    }

    public NetInterfaceMonitor buildNetInterfaceMonitor() {
        NetInterfaceMonitor netInterfaceMonitor = new NetInterfaceMonitor();
        int maxNetInterface = 3;
        maxNetInterface = Integer.parseInt(configUtil.getParamenter("interface.maxNumber"));
        for (int i = 1; i <= maxNetInterface; ++i) {
            String ifIp = configUtil.getParamenter("interface." + i + ".ip");
            if (!NetUtil.checkIpv4(ifIp)) continue;
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("interface." + i);
            monitorInfo.setLocalConfig(ifIp);
            NetworkInterface nif = NetUtil.getNetworkInterface(ifIp);
            if (nif != null) {
                monitorInfo.setLocalDetail(nif.getDisplayName());
            }
            netInterfaceMonitor.addMonitorInfo(monitorInfo);
        }
        if (netInterfaceMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("interface.cycle");
            String maxFailedTimes = configUtil.getParamenter("interface.maxFailedTimes");
            netInterfaceMonitor.setCycle(this.parseCycle(cycle));
            netInterfaceMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        }
        return netInterfaceMonitor;
    }

    public WinServiceMonitor buildWinServiceMonitor() {
        WinServiceMonitor winServiceMonitor = new WinServiceMonitor();
        String serviceIgnore = "1";
        String serviceIsBat = "no";
        ArrayList<String> serviceList = new ArrayList<String>();
        serviceList.add("mysqlservice");
        serviceList.add("LEGOWebSrv");
        serviceList.add("LEGOMonitor");
        serviceList.add("Anti-DDoS Collector Service");
        serviceList.add("Anti-DDoS Collector Monitor Service");
        for (int i = 1; i <= serviceList.size(); ++i) {
            String serviceName = (String)serviceList.get(i - 1);
            if (!(serviceIsBat.equalsIgnoreCase("true") || serviceIsBat.equalsIgnoreCase("false") || serviceIsBat.equalsIgnoreCase("no"))) {
                serviceIsBat = "no";
            }
            if (serviceName == null || serviceName.equals("")) continue;
            serviceIgnore = serviceName.equals("mysqlservice") ? "0" : "1";
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("winService." + i);
            monitorInfo.setLocalConfig(serviceName);
            if (!serviceIgnore.equals("")) {
                monitorInfo.setLocalDetail(serviceIgnore);
            } else {
                monitorInfo.setLocalDetail("0");
            }
            winServiceMonitor.addMonitorInfo(monitorInfo);
            if (serviceIsBat.equalsIgnoreCase("no")) continue;
            winServiceMonitor.addStartServicesMap(serviceName, Boolean.valueOf(serviceIsBat));
        }
        if (winServiceMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("service.cycle");
            String maxFailedTimes = configUtil.getParamenter("service.maxFailedTimes");
            winServiceMonitor.setCycle(this.parseCycle(cycle));
            winServiceMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        }
        return winServiceMonitor;
    }

    public FileMonitor buildFileMonitor() {
        FileMonitor fileMonitor = new FileMonitor();
        String installPath = configUtil.getParamenter("install.path");
        if (installPath == null || installPath.equals("")) {
            installPath = AticInstallUtil.getInstance().getInstallPath() + File.separator;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
            fileList.add("components" + File.separator + "atic" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator);
            fileList.add("components" + File.separator + "atic" + File.separator + "LegoRuntime" + File.separator + "datastorage" + File.separator);
            fileList.add("components" + File.separator + "atic" + File.separator + "Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "iReport" + File.separator + "iReportBiz" + File.separator + "customReport" + File.separator);
            fileList.add("components" + File.separator + "atic" + File.separator + "Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator);
            fileList.add("components" + File.separator + "antiddos_collector" + File.separator + "conf" + File.separator);
            fileList.add("engineering" + File.separator + "bin" + File.separator + "etc" + File.separator + "config" + File.separator + "sdp" + File.separator);
            fileList.add("components" + File.separator + "common" + File.separator + "sdp" + File.separator);
            fileList.add("components" + File.separator + "atic" + File.separator + "vsm_conf" + File.separator);
            fileList.add("components" + File.separator + "atic" + File.separator + "LegoRuntime" + File.separator + "spconfig" + File.separator + "sgip" + File.separator);
        } else {
            fileList.add("Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator);
            fileList.add("Runtime" + File.separator + "LegoRuntime" + File.separator + "datastorage" + File.separator);
            fileList.add("Runtime" + File.separator + "Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "iReport" + File.separator + "iReportBiz" + File.separator + "customReport" + File.separator);
            fileList.add("Runtime" + File.separator + "Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator);
            fileList.add("antiddos_collector" + File.separator + "conf" + File.separator);
            fileList.add("Runtime" + File.separator + "bin" + File.separator + "etc" + File.separator + "config" + File.separator + "sdp" + File.separator);
            fileList.add("Runtime" + File.separator + "vsm_conf" + File.separator);
            fileList.add("Runtime" + File.separator + "LegoRuntime" + File.separator + "spconfig" + File.separator + "sgip" + File.separator);
        }
        for (int i = 1; i <= fileList.size(); ++i) {
            String rootpath = installPath + (String)fileList.get(i - 1);
            if (rootpath.equals("")) continue;
            MonitorInfo monitorInfo = new MonitorInfo();
            monitorInfo.setName("file." + i);
            monitorInfo.setLocalConfig(rootpath);
            monitorInfo.setLocalDetail("");
            fileMonitor.addMonitorInfo(monitorInfo);
            FileUtil fileUtil = new FileUtil(rootpath);
            fileMonitor.addFileUtil(fileUtil);
            fileMonitor.deleteHaTempFilesAtBeginning();
        }
        if (fileMonitor.getMonitorInfoList().size() > 0) {
            String cycle = configUtil.getParamenter("file.cycle");
            String maxFailedTimes = "100";
            fileMonitor.setCycle(this.parseCycle(cycle));
            fileMonitor.setMaxFaileTimes(this.parseMaxFailedTimes(maxFailedTimes));
        }
        return fileMonitor;
    }

    private boolean checkHeartbeat(String localIp, String remoteIp) {
        return NetUtil.checkIpv4(localIp) && NetUtil.checkIpv4(remoteIp);
    }

    private boolean checkDatabase(String ip, String port, String type, String name, String username, String password, String testSql) {
        boolean result = NetUtil.checkIpv4(ip) && NetUtil.checkPort(port) && DatabaseUtil.checkDbType(type) && name != null && !name.equals("");
        return result;
    }

    private int parseCycle(String cycle) {
        int c = 60;
        try {
            c = Integer.parseInt(cycle);
            if (c < 1 || c > 3600) {
                c = 60;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("error:" + e.getMessage()));
        }
        return c * 1000;
    }

    private int parseMaxFailedTimes(String failedTimes) {
        int max = 3;
        try {
            max = Integer.parseInt(failedTimes);
            if (max < 1 || max > 100) {
                max = 3;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("error:" + e.getMessage()));
        }
        return max;
    }

    public void saveConfig(ConfigInfo configInfo) {
        if ("true".equalsIgnoreCase(configInfo.getHaEnabled())) {
            configUtil.setParamenter("haEnabled", "true");
        } else {
            configUtil.setParamenter("haEnabled", "false");
        }
        if ("true".equalsIgnoreCase(configInfo.getHaPair())) {
            configUtil.setParamenter("haPair", "true");
        } else {
            configUtil.setParamenter("haPair", "false");
        }
        if ("true".equalsIgnoreCase(configInfo.getAutoSwitch())) {
            configUtil.setParamenter("autoSwitch", "true");
        } else {
            configUtil.setParamenter("autoSwitch", "false");
        }
        if ("primary".equalsIgnoreCase(configInfo.getInitRole())) {
            configUtil.setParamenter("initRole", "primary");
        } else {
            configUtil.setParamenter("initRole", "standby");
        }
        configUtil.setParamenter("manageIp.local", configInfo.getManageIpLocal());
        configUtil.setParamenter("heartbeat.cycle", configInfo.getHeartbeatCycle());
        configUtil.setParamenter("heartbeat.maxFailedTimes", configInfo.getHeartbeatMaxFailedTimes());
        configUtil.setParamenter("heartbeat.local", configInfo.getHeartbeatLocal());
        configUtil.setParamenter("heartbeat.remote", configInfo.getHeartbeatRemote());
        configUtil.setParamenter("netInterface.cycle", configInfo.getNetInterfaceCycle());
        configUtil.setParamenter("netInterface.maxFailedTimes", configInfo.getNetInterfaceMaxFailedTimes());
        configUtil.setParamenter("netInterface.1.local", configInfo.getNetInterface1Local());
        configUtil.setParamenter("winService.cycle", configInfo.getWinServiceCycle());
        configUtil.setParamenter("winService.maxFailedTimes", configInfo.getWinServiceMaxFailedTimes());
        configUtil.setParamenter("database.cycle", configInfo.getDatabaseCycle());
        configUtil.setParamenter("database.maxFailedTimes", configInfo.getDatabaseMaxFailedTimes());
        configUtil.setParamenter("database.username", configInfo.getDatabaseUsername());
        configUtil.setParamenter("database.password", configInfo.getDatabase1Password());
        configUtil.save();
    }

    public String getStartBatPath() {
        String path = "";
        try {
            path = configUtil.getParamenter("service.start.bat");
            String result = CmdUtil.execCmdResult("sc qc LEGOV1R1SVC|find \"" + this.getGlobalInfo("sc.qc.binary.path.name") + "\"").toString();
            if (!result.equalsIgnoreCase("") && result.indexOf("Runtime" + File.separator + "bin") >= 0 && (path == null || path.equalsIgnoreCase("") || path.indexOf(".bat") < 0)) {
                path = result.split("\"")[1].split("legosvc.exe")[0] + "startSystem.bat";
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"getStartBatPath get path error");
        }
        return path;
    }

    public String getStopBatPath() {
        String path = "";
        try {
            path = configUtil.getParamenter("service.end.bat");
            String result = CmdUtil.execCmdResult("sc qc LEGOV1R1SVC|find \"" + this.getGlobalInfo("sc.qc.binary.path.name") + "\"").toString();
            if (!result.equalsIgnoreCase("") && result.indexOf("Runtime" + File.separator + "bin") >= 0 && (path == null || path.equalsIgnoreCase("") || path.indexOf(".bat") < 0)) {
                path = result.split("\"")[1].split("legosvc.exe")[0] + "shutdownSystem.bat";
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"getStopBatPath execution command error");
        }
        return path;
    }
}

