/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.rmi.impl.ManageServiceImpl;
import com.hs.ha.rmi.impl.PairMessageServiceImpl;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class HaRmi {
    private static Logger logger = LogManager.getInstance().getHaLog();
    private static HaRmi harmi = new HaRmi();
    private List<RmiConfig> heartRmiList = new ArrayList<RmiConfig>();
    private int haRmiServicePort = 11090;
    private List<RmiConfig> heartUpRmiList = new ArrayList<RmiConfig>();
    private RmiConfig messageRmiConfig = new RmiConfig();
    private RmiConfig managerRmiConfig = new RmiConfig();

    public static HaRmi getInstance() {
        return harmi;
    }

    public boolean init() {
        boolean isSuccess = true;
        String rmiLocalIp = "";
        String rmiRemoteIp = "";
        rmiLocalIp = Configer.getInstance().getLocalHeartRmiIp();
        rmiRemoteIp = Configer.getInstance().getRemoteHeartRmiIp();
        int rmiPort = Configer.getInstance().getHeartRmiPort();
        if (rmiLocalIp == null || rmiLocalIp.equals("") || rmiRemoteIp == null || rmiRemoteIp.equals("")) {
            isSuccess = false;
            return isSuccess;
        }
        if (!this.registryRmi(rmiLocalIp, rmiPort)) {
            isSuccess = false;
            return isSuccess;
        }
        RmiConfig tempRmiConfig = new RmiConfig();
        tempRmiConfig.setLocalIp(rmiLocalIp);
        tempRmiConfig.setRemoteIp(rmiRemoteIp);
        tempRmiConfig.setPort(rmiPort);
        this.heartRmiList.add(tempRmiConfig);
        this.heartUpRmiList.add(tempRmiConfig);
        rmiPort = 11088;
        rmiLocalIp = Configer.getInstance().getManageLocalIp();
        if (rmiLocalIp == null || rmiLocalIp.equals("") || !this.registryRmi(rmiLocalIp, rmiPort)) {
            isSuccess = false;
            return isSuccess;
        }
        this.managerRmiConfig.setLocalIp(rmiLocalIp);
        this.managerRmiConfig.setPort(rmiPort);
        return isSuccess;
    }

    public void setHeartUpRmiList(List<RmiConfig> heartUpRmiList) {
        this.heartUpRmiList = heartUpRmiList;
    }

    public void setMessageRmiConfig() {
        if (this.heartUpRmiList.size() > 0) {
            this.messageRmiConfig = new RmiConfig();
            this.messageRmiConfig.setLocalIp(this.heartUpRmiList.get(0).getLocalIp());
            this.messageRmiConfig.setRemoteIp(this.heartUpRmiList.get(0).getRemoteIp());
            this.messageRmiConfig.setPort(this.heartUpRmiList.get(0).getPort());
        } else if (this.heartUpRmiList.size() == 0) {
            this.messageRmiConfig = null;
        }
    }

    private boolean registryRmi(String ip, int rmiPort) {
        boolean isSuccess = true;
        System.setProperty("java.rmi.server.hostname", ip);
        try {
            Registry registry = LocateRegistry.createRegistry(rmiPort);
            PairMessageServiceImpl messageService = new PairMessageServiceImpl(this.haRmiServicePort);
            registry.bind("messageService", messageService);
            ManageServiceImpl manageService = new ManageServiceImpl(this.haRmiServicePort);
            registry.bind("manageService", manageService);
            isSuccess = true;
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(0), "success", ip, String.valueOf(rmiPort)));
        }
        catch (RemoteException e) {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(0), "failure", ip, String.valueOf(rmiPort)));
            isSuccess = false;
        }
        catch (AlreadyBoundException e) {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(0), "failure", ip, String.valueOf(rmiPort)));
            isSuccess = false;
        }
        return isSuccess;
    }

    public RmiConfig getMessageRmiConfig() {
        return this.messageRmiConfig;
    }

    public RmiConfig getManagerRmiConfig() {
        return this.managerRmiConfig;
    }

    public void resetHeartUpRmiList(String localIp, String remoteIp, int port, String status) {
        boolean isHave = false;
        for (RmiConfig rmiConfig : this.heartUpRmiList) {
            if (!rmiConfig.getLocalIp().equals(localIp) || !rmiConfig.getRemoteIp().equals(remoteIp) || rmiConfig.getPort() != port) continue;
            if (status.equals("down")) {
                this.heartUpRmiList.remove(rmiConfig);
            }
            isHave = true;
            break;
        }
        if (!isHave && status.equals("up")) {
            RmiConfig tempRmiConfig = new RmiConfig();
            tempRmiConfig.setLocalIp(localIp);
            tempRmiConfig.setRemoteIp(remoteIp);
            tempRmiConfig.setPort(port);
            this.heartUpRmiList.add(tempRmiConfig);
        }
        this.setMessageRmiConfig();
    }

    public static class RmiConfig {
        private String localIp;
        private String remoteIp;
        private int port;

        public String getLocalIp() {
            return this.localIp;
        }

        public void setLocalIp(String localIp) {
            this.localIp = localIp;
        }

        public String getRemoteIp() {
            return this.remoteIp;
        }

        public void setRemoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String toString() {
            return "RmiConfig [localIp=" + this.localIp + ", port=" + this.port + ", remoteIp=" + this.remoteIp + "]";
        }
    }
}

