/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DualHostSwitchService;
import com.hs.ha.Configer;
import com.hs.ha.HaRmi;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.rmi.PairMessageService;
import com.hs.ha.vo.MonitorInfo;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RmiServiceUtil {
    private static Logger logger = LogManager.getInstance().getHaLog();
    private static int aticRmiServicePort = 11098;

    public static PairMessageService getPairMessageService() throws RemoteException, NotBoundException {
        if (HaRmi.getInstance().getMessageRmiConfig() == null) {
            return null;
        }
        String remoteIp = HaRmi.getInstance().getMessageRmiConfig().getRemoteIp();
        String remotePort = String.valueOf(HaRmi.getInstance().getMessageRmiConfig().getPort());
        return RmiServiceUtil.getPairMessageService(remoteIp, remotePort);
    }

    public static PairMessageService getPairMessageService(String remoteIp, String remotePort) throws RemoteException, NotBoundException {
        PairMessageService messageService = null;
        int port = Integer.parseInt(remotePort);
        Registry registry = LocateRegistry.getRegistry(remoteIp, port);
        try {
            messageService = (PairMessageService)registry.lookup("messageService");
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get Message Service." + e.getMessage()));
            return null;
        }
        return messageService;
    }

    public static String sendPairHeartbeat(String remoteIp, String port) throws RemoteException, NotBoundException {
        PairMessageService messageService = RmiServiceUtil.getPairMessageService(remoteIp, port);
        if (null != messageService) {
            return messageService.sendHeartbeat(remoteIp);
        }
        return "";
    }

    public static List<MonitorInfo> getPairMonitorInfoList() throws Exception {
        List<MonitorInfo> monifoInfoList = new Vector<MonitorInfo>();
        PairMessageService messageService = RmiServiceUtil.getPairMessageService();
        if (messageService != null) {
            monifoInfoList = messageService.getMonitorInfoList();
        }
        return monifoInfoList;
    }

    public static boolean notifyHaSwitch() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            result = messageService.notifyHaSwitch();
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(4), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(5), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return result;
    }

    public static boolean notifyHaStart() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            messageService.notifyHaStart();
            result = true;
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(4), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(5), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return result;
    }

    public static boolean notifyHaStop() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            messageService.notifyHaStop();
            result = true;
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(6), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(7), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return result;
    }

    public static DualHostSwitchService getVSMDualHostSwitchService() throws Exception {
        String vsmRmiIp = "";
        boolean isCurPrimary = Manager.getInstance().isCurrHaPrimary();
        if (isCurPrimary) {
            vsmRmiIp = Configer.getInstance().getManageLocalIp();
            logger.info((Object)("vsmRmiCollectorIp:localIp:" + vsmRmiIp));
        } else {
            vsmRmiIp = Configer.getInstance().getManageRemoteIp();
            logger.info((Object)("vsmRmiCollectorIp:remoteIp:" + vsmRmiIp));
        }
        Registry registry = RmiServiceUtil.getSSLRegistry(vsmRmiIp, aticRmiServicePort);
        if (null == registry) {
            logger.error((Object)"getVSMDualHostSwitchService error, registry is null");
            return null;
        }
        logger.debug((Object)"get the registry");
        DualHostSwitchService dualHostSwitchService = (DualHostSwitchService)registry.lookup("DualHostSwitchService");
        logger.info((Object)"get dualHostSwitchService");
        if (null == dualHostSwitchService) {
            logger.error((Object)"getVSMDualHostSwitchService error, dualHostSwitchService is null");
            return null;
        }
        return dualHostSwitchService;
    }

    public static boolean isHaStatusOk() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            if (messageService == null) {
                return false;
            }
            result = messageService.isHaStatusOk();
        }
        catch (AccessException e) {
            logger.error((Object)("isHaStatusOk access error" + e.getMessage()));
        }
        catch (RemoteException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        catch (NotBoundException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return result;
    }

    public static Registry getSSLRegistry(String vsmRmiIp, int port) {
        Registry registry = null;
        System.setProperty("javax.net.ssl.keyStore", "ha_keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "Admin@123");
        System.setProperty("javax.net.ssl.trustStore", "ha_truststore");
        System.setProperty("javax.net.ssl.trustStorePassword", "Admin@123");
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(vsmRmiIp, port, csf);
        }
        catch (Exception e) {
            logger.error((Object)("getSSLRegistry Regist failed !" + e.getMessage()));
            registry = null;
        }
        return registry;
    }
}

