/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.DatabaseUtil;
import com.hs.ha.vo.MonitorInfo;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DatabaseMonitor
extends BasicMonitor {
    private static final int DATABASE_THRESHOLD = 100;
    private static Logger logger = LogManager.getInstance().getHaLog();
    ArrayList<DatabaseUtil> databaseList = new ArrayList();

    public DatabaseMonitor() {
        this.setMonitorThreshold(100);
        this.setName("database");
    }

    public void addDatabase(DatabaseUtil db) {
        this.databaseList.add(db);
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public int monitorHaIndex() {
        return this.checkDatabase();
    }

    public int checkDatabase() {
        int index = 100;
        int sucessed = 0;
        try {
            for (int i = 0; i < this.databaseList.size(); ++i) {
                MonitorInfo monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                DatabaseUtil du = this.databaseList.get(i);
                if (!Manager.getInstance().isCurrHaPrimary() && du.getType().equals("sqlserver")) {
                    ++sucessed;
                    monitorInfo.setLocalStatus("up");
                    continue;
                }
                if (du.testConn()) {
                    ++sucessed;
                    monitorInfo.setLocalStatus("up");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "success", monitorInfo.getName(), du.getName()));
                } else {
                    monitorInfo.setLocalStatus("down");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "failure", monitorInfo.getName(), du.getName()));
                }
                monitorInfo.setTime(System.currentTimeMillis());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        if (this.databaseList.size() > 0) {
            index = 100 * sucessed / this.monitorInfoList.size();
        }
        return index;
    }

    private boolean needAction() {
        return this.getFailedTimes() >= this.getMaxFaileTimes() && Manager.getInstance().isAutoSwitch() && Manager.getInstance().isHaPair() && Manager.getInstance().isCurrHaPrimary();
    }

    @Override
    public int getActionType() {
        if (this.needAction()) {
            return 3;
        }
        return 0;
    }
}

