/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.LogManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DatabaseUtil {
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sqlserver";
    public static final String ORACLE = "oracle";
    private static final String URL_TIME_ZONE_UTC = "UTC";
    private static final String USE_SSL = "?useSSL=false&serverTimezone=${serverTimezone}";
    private static Logger logger = LogManager.getInstance().getHaLog();
    private String ip;
    private String port;
    private String type;
    private String name;
    private String username;
    private String password;
    private String testSql;

    public DatabaseUtil(String ip, String port, String type, String name, String username, String password, String testSql) {
        this.ip = ip;
        this.port = port;
        this.type = type;
        this.name = name;
        this.username = username;
        this.password = password;
        this.testSql = testSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConn() {
        boolean result = true;
        Connection conn = this.getConnection();
        PreparedStatement psmt = null;
        if (conn == null) {
            result = false;
        }
        try {
            if (conn != null) {
                psmt = conn.prepareStatement("select @@version");
                psmt.execute();
            }
        }
        catch (SQLException e) {
            result = false;
        }
        finally {
            try {
                if (psmt != null) {
                    psmt.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"testConn psmt closes error");
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"testConn connection closes error");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testSlaveStatus() {
        boolean result = true;
        Connection conn = this.getConnection();
        PreparedStatement psmt = null;
        if (conn == null) {
            logger.error((Object)"testSlaveStatus mysql conn fail");
            result = false;
        }
        ResultSet resset = null;
        try {
            if (conn != null) {
                psmt = conn.prepareStatement("show slave status;");
                resset = psmt.executeQuery();
                Boolean isNull = true;
                while (resset.next()) {
                    isNull = false;
                    Object ioRunning = resset.getObject("Slave_IO_Running");
                    Object sqlRunning = resset.getObject("Slave_SQL_Running");
                    Object ioError = resset.getObject("Last_IO_Error");
                    Object sqlError = resset.getObject("Last_SQL_Error");
                    if (ioError == null || ioError.toString().equals("")) {
                        ioError = "null";
                    }
                    if (sqlError == null || sqlError.toString().equals("")) {
                        sqlError = "null";
                    }
                    if (ioRunning.toString().equals("Yes") && sqlRunning.toString().equals("Yes") && ioError.toString().equals("null") && sqlError.toString().equals("null")) continue;
                    logger.error((Object)"testSlaveStatus slave status have error");
                    result = false;
                }
                if (isNull.booleanValue()) {
                    logger.error((Object)"testSlaveStatus slave status is null");
                    result = false;
                }
            }
            this.closeDB(conn, psmt, resset);
        }
        catch (SQLException e) {
            try {
                result = false;
                this.closeDB(conn, psmt, resset);
            }
            catch (Throwable throwable) {
                this.closeDB(conn, psmt, resset);
                throw throwable;
            }
        }
        return result;
    }

    private void closeDB(Connection conn, PreparedStatement psmt, ResultSet resset) {
        try {
            if (resset != null) {
                resset.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"closeDB resset close error ");
        }
        try {
            if (psmt != null) {
                psmt.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"closeDB psmt close error");
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"closeDB conn close error");
        }
    }

    private Connection getConnection() {
        Connection conn = null;
        try {
            if (this.type.equals(MYSQL)) {
                Class.forName("com.mysql.jdbc.Driver");
                String url = "jdbc:mysql://" + this.ip + ":" + this.port + "/" + this.name + DatabaseUtil.replaceWithObject(USE_SSL, "serverTimezone", DatabaseUtil.curTimeZone());
                conn = DriverManager.getConnection(url, this.username, this.password);
            } else if (this.type.equals(SQLSERVER)) {
                Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                String url = "jdbc:sqlserver://" + this.ip + ":" + this.port + ";DataBaseName=" + this.name;
                conn = DriverManager.getConnection(url, this.username, this.password);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"getConnection database driver error");
        }
        catch (SQLException e) {
            logger.error((Object)"getConnection failed");
        }
        return conn;
    }

    private static String replaceWithObject(String sourceString, String holderName, String value) {
        String targetString = sourceString;
        Matcher matcher = Pattern.compile("\\$\\{(.*?)\\}").matcher(sourceString);
        while (matcher.find()) {
            String key = matcher.group();
            String curholderName = key.substring(2, key.length() - 1).trim();
            if (!curholderName.trim().equals(holderName)) continue;
            targetString = targetString.replace(key, value);
        }
        return targetString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failoverSqlServerMirror() {
        boolean result = true;
        Connection conn = this.getConnection();
        PreparedStatement psmt = null;
        String sql = "use master;alter database " + this.getName() + " set partner failover;";
        if (conn == null) {
            result = false;
        }
        try {
            if (conn != null) {
                psmt = conn.prepareStatement(sql);
                psmt.execute();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"failoverSqlServerMirror execute sql error");
            result = false;
        }
        finally {
            try {
                if (psmt != null) {
                    psmt.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"failoverSqlServerMirror psmt close error");
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"failoverSqlServerMirror conn close error");
            }
        }
        return result;
    }

    public static String curTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        logger.info((Object)("curTimeZone : " + timeZone.getID()));
        logger.info((Object)timeZone.getDisplayName());
        try {
            return URLEncoder.encode(timeZone.getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URL_TIME_ZONE_UTC;
        }
    }

    public static boolean checkDbType(String type) {
        return MYSQL.equals(type) || SQLSERVER.equals(type) || ORACLE.equals(type);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTestSql() {
        return this.testSql;
    }

    public void setTestSql(String testSql) {
        this.testSql = testSql;
    }

    public String toString() {
        return "ip=" + this.ip + ", port=" + this.port + ", type=" + this.type + ", name=" + this.name + ", testSql=" + this.testSql;
    }
}

