/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.monitor.BasicMonitor;
import org.apache.log4j.Logger;

public class HaSwitchMonitor
extends BasicMonitor {
    private static final int HA_THRESHOLD = 100;
    private static final int MAX_MODIFY_VSM_SERVER_TIMES = Configer.getInstance().getSwitchModifyTimes();
    private static Logger logger = LogManager.getInstance().getHaLog();
    private boolean isSwitch = false;
    private boolean isVsmServerModify = false;
    private int currentAction = 0;
    private int modifyVsmServerTimes = 0;

    public HaSwitchMonitor() {
        this.setName("haswitch");
        this.initThreshold();
    }

    private void initThreshold() {
        this.setMonitorThreshold(100);
    }

    @Override
    protected int monitorHaIndex() {
        return this.checkHaSwitch();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public void setSwitch(boolean isSwitchT) {
        this.isSwitch = isSwitchT;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public void setModifyVsmServerTimes(int modifyVsmServerTimes) {
        this.modifyVsmServerTimes = modifyVsmServerTimes;
    }

    public void setVsmServerModify(boolean isVsmServerModifyT) {
        this.isVsmServerModify = isVsmServerModifyT;
    }

    public boolean isVsmServerModify() {
        return this.isVsmServerModify;
    }

    private int checkHaSwitch() {
        int index = 100;
        if (this.getActionType() != 0) {
            return index;
        }
        if (this.isSwitch) {
            index = 0;
            this.setCurrentAction(3);
            this.setSwitch(false);
        } else if (this.isVsmServerModify) {
            if (this.modifyVsmServerTimes < MAX_MODIFY_VSM_SERVER_TIMES) {
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(47), "ignore", this.modifyVsmServerTimes));
                index = 0;
                ++this.modifyVsmServerTimes;
                this.setCurrentAction(4);
                this.setVsmServerModify(false);
            } else {
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(47), "failure", this.modifyVsmServerTimes));
                this.modifyVsmServerTimes = 0;
                this.setCurrentAction(0);
                this.setVsmServerModify(false);
                Manager.getInstance().setModifyingVsmServer(false);
                this.setSwitch(true);
            }
        }
        return index;
    }

    public void setCurrentAction(int currentAction) {
        this.currentAction = currentAction;
    }

    private boolean needAction() {
        return this.getFailedTimes() >= this.getMaxFaileTimes();
    }

    @Override
    public int getActionType() {
        if (this.needAction()) {
            return this.currentAction;
        }
        return 0;
    }
}

