/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.Configer;
import com.hs.ha.HaRmi;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.NetUtil;
import com.hs.ha.vo.MonitorInfo;
import java.net.NetworkInterface;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;

public class HeartbeatMonitor
extends BasicMonitor {
    private static final int HEARTBEAT_THRESHOLD = 1;
    private static Logger logger = LogManager.getInstance().getHaLog();
    private String remoteHeartResult = "";

    public HeartbeatMonitor() {
        this.setMonitorThreshold(1);
        this.setName("heratbeat");
    }

    private int checkHeartbeat() {
        int index = 100;
        int sucessed = 0;
        for (int i = 0; i < this.monitorInfoList.size(); ++i) {
            MonitorInfo monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
            String localIp = monitorInfo.getLocalConfig();
            String remoteIp = monitorInfo.getRemoteConfig();
            String port = monitorInfo.getRemoteDetail();
            NetworkInterface localIf = NetUtil.getNetworkInterface(localIp);
            if (localIf == null) {
                monitorInfo.setLocalStatus("down");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(10), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), localIp));
                HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
            } else {
                monitorInfo.setLocalStatus("up");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(10), "success", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), localIp));
            }
            try {
                this.remoteHeartResult = RmiServiceUtil.sendPairHeartbeat(remoteIp, port);
                if (this.remoteHeartResult != null && !this.remoteHeartResult.equals("")) {
                    Manager.getInstance().setRemoteHaPrimaryToken(Integer.parseInt(this.remoteHeartResult.split(";")[1]));
                    Manager.getInstance().setRemoteHaRunDate(Long.parseLong(this.remoteHeartResult.split(";")[2]));
                    logger.debug((Object)("!!!!!!!!!!!!!!!!!!local=" + Manager.getInstance().isCurrHaPrimary() + ";remote=" + this.remoteHeartResult.split(";")[0]));
                    if (Manager.getInstance().isCurrHaPrimary() == Boolean.parseBoolean(this.remoteHeartResult.split(";")[0])) {
                        Manager.getInstance().setSameRole(true);
                    } else {
                        Manager.getInstance().setSameRole(false);
                    }
                    monitorInfo.setRemoteStatus("up");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "success", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                    ++sucessed;
                    HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "up");
                } else {
                    monitorInfo.setRemoteStatus("down");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                    HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
                }
            }
            catch (NumberFormatException e1) {
                monitorInfo.setRemoteStatus("down");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
            }
            catch (RemoteException e1) {
                monitorInfo.setRemoteStatus("down");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
            }
            catch (NotBoundException e1) {
                monitorInfo.setRemoteStatus("down");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
            }
            catch (RuntimeException e1) {
                monitorInfo.setRemoteStatus("down");
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(11), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), remoteIp));
                HaRmi.getInstance().resetHeartUpRmiList(localIp, remoteIp, Integer.parseInt(port), "down");
            }
            monitorInfo.setTime(System.currentTimeMillis());
            logger.debug((Object)monitorInfo.toString());
        }
        if (sucessed == 0) {
            this.setRemoteHaStatus("down");
        } else {
            this.setRemoteHaStatus("up");
        }
        if (this.monitorInfoList.size() > 0) {
            index = 100 * sucessed / this.monitorInfoList.size();
        }
        return index;
    }

    private void setRemoteHaStatus(String status) {
        for (MonitorInfo monitorInfo : Manager.getInstance().getMonitorInfoList()) {
            if (!monitorInfo.getName().equals("name")) continue;
            monitorInfo.setRemoteStatus(status);
            break;
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    protected int monitorHaIndex() {
        return this.checkHeartbeat();
    }

    private boolean needAction() {
        return this.getFailedTimes() >= this.getMaxFaileTimes() && Manager.getInstance().isAutoSwitch() && Manager.getInstance().isHaPair() && !Manager.getInstance().isCurrHaPrimary();
    }

    @Override
    public int getActionType() {
        if (this.needAction()) {
            return 3;
        }
        try {
            logger.debug((Object)("^^^^^^^^^^^^^^^^^^Manager.getInstance().isSameRole()=" + Manager.getInstance().isSameRole()));
            logger.debug((Object)("^^^^^^^^^^^^^^^^^^Manager.getInstance().canBeArranged()=" + Manager.getInstance().canBeArranged()));
            boolean remoteCanBeArranged = false;
            if (RmiServiceUtil.getPairMessageService() != null) {
                remoteCanBeArranged = RmiServiceUtil.getPairMessageService().canBeArranged();
            }
            if (Manager.getInstance().isSameRole() && Manager.getInstance().canBeArranged() && remoteCanBeArranged) {
                return 5;
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"getActionType RmiServiceUtil error :RemoteException");
        }
        catch (NotBoundException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return 0;
    }
}

