/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.atic.rmi.DualHostSwitchService;
import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.DatabaseUtil;
import com.hs.ha.vo.MonitorInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MysqlSlaveMonitor
extends BasicMonitor {
    private static final int DATABASE_THRESHOLD = 100;
    private static Logger logger = LogManager.getInstance().getHaLog();
    private boolean isHasAlarm = false;
    ArrayList<DatabaseUtil> checkList = new ArrayList();

    public MysqlSlaveMonitor() {
        this.setMonitorThreshold(100);
        this.setName("database");
    }

    public void addDatabase(DatabaseUtil db) {
        this.checkList.add(db);
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public int monitorHaIndex() {
        return this.checkDatabase();
    }

    public int checkDatabase() {
        int index = 100;
        int sucessed = 0;
        try {
            for (int i = 0; i < this.checkList.size(); ++i) {
                MonitorInfo monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                DatabaseUtil du = this.checkList.get(i);
                if (du.testSlaveStatus()) {
                    ++sucessed;
                    monitorInfo.setLocalStatus("up");
                    if (this.isHasAlarm) {
                        this.stopAlarm();
                    }
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "success", monitorInfo.getName(), du.getName()));
                } else {
                    ++sucessed;
                    monitorInfo.setLocalStatus("down");
                    if (!this.isHasAlarm) {
                        this.startAlarm();
                    }
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "failure", monitorInfo.getName(), du.getName()));
                }
                monitorInfo.setTime(System.currentTimeMillis());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"MysqlSlaveMonitor-checkDatabase error");
        }
        if (this.checkList.size() > 0) {
            index = 100 * sucessed / this.monitorInfoList.size();
        }
        return index;
    }

    @Override
    public int getActionType() {
        return 0;
    }

    public void startAlarm() {
        try {
            DualHostSwitchService dualHostSwitchService = RmiServiceUtil.getVSMDualHostSwitchService();
            if (null != dualHostSwitchService) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alarmId", "0x0000000803240879");
                map.put("isAlarm", "true");
                map.put("ip", Configer.getInstance().getLocalHeartRmiIp());
                dualHostSwitchService.sendAlarm(map);
                this.isHasAlarm = true;
            } else {
                logger.error((Object)"databaseHaAlarmService is null.");
                this.isHasAlarm = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"startAlarm with error.");
            this.isHasAlarm = false;
        }
    }

    public void stopAlarm() {
        this.isHasAlarm = false;
        try {
            DualHostSwitchService dualHostSwitchService = RmiServiceUtil.getVSMDualHostSwitchService();
            if (null != dualHostSwitchService) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alarmId", "0x0000000803240879");
                map.put("isAlarm", "false");
                map.put("ip", Configer.getInstance().getLocalHeartRmiIp());
                dualHostSwitchService.sendAlarm(map);
            } else {
                logger.error((Object)"databaseHaAlarmService is null.");
            }
        }
        catch (Exception e) {
            logger.error((Object)"stopAlarm with error.");
        }
    }
}

