/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.AticInstallUtil;
import com.hs.ha.CmdUtil;
import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.NetUtil;
import com.hs.ha.vo.MonitorInfo;
import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class NetInterfaceMonitor
extends BasicMonitor {
    private static final int NETINTERFACE_THRESHOLD = 100;
    private static Logger logger = LogManager.getInstance().getHaLog();

    public NetInterfaceMonitor() {
        this.setMonitorThreshold(100);
        this.setName("netinterface");
    }

    @Override
    public int monitorHaIndex() {
        return this.checkNetInterface();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    private int checkNetInterface() {
        int index = 100;
        int sucessed = 0;
        try {
            for (int i = 0; i < this.monitorInfoList.size(); ++i) {
                MonitorInfo monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                String ip = monitorInfo.getLocalConfig();
                NetworkInterface nif = NetUtil.getNetworkInterface(ip);
                if (nif != null && nif.isUp()) {
                    ++sucessed;
                    monitorInfo.setLocalStatus("up");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "success", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), ip));
                } else {
                    monitorInfo.setLocalStatus("down");
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "failure", ((MonitorInfo)this.monitorInfoList.get(i)).getName(), ip));
                }
                monitorInfo.setTime(System.currentTimeMillis());
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"NetInterfaceMonitor-checkNetInterface error");
        }
        catch (SocketException e) {
            logger.error((Object)"NetInterfaceMonitor-checkNetInterface socket error");
        }
        if (this.monitorInfoList.size() > 0) {
            index = 100 * sucessed / this.monitorInfoList.size();
        }
        return index;
    }

    private boolean needAction() {
        return this.getFailedTimes() >= this.getMaxFaileTimes() && Manager.getInstance().isAutoSwitch() && Manager.getInstance().isHaPair() && Manager.getInstance().isCurrHaPrimary();
    }

    public boolean changeFloatIp() {
        boolean is = false;
        String cmd = "";
        String ip = Configer.getInstance().getFloatIP();
        int messageId = 34;
        String addCmd = "";
        String deleteCmd = "";
        if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
            addCmd = "sudo ifconfig " + Configer.getInstance().getFloatInterface() + ":flo " + Configer.getInstance().getFloatIP() + " netmask " + Configer.getInstance().getFloatSubmask();
            deleteCmd = "sudo ifconfig " + Configer.getInstance().getFloatInterface() + ":flo " + Configer.getInstance().getFloatIP() + " down";
        } else {
            addCmd = "netsh interface ip add address name=\"" + Configer.getInstance().getFloatInterface() + "\" addr=" + ip + " mask=" + Configer.getInstance().getFloatSubmask();
            deleteCmd = "netsh interface ip delete address name=\"" + Configer.getInstance().getFloatInterface() + "\" addr=" + ip;
            cmd = "netsh interface ip add address name=\"" + Configer.getInstance().getFloatInterface() + "\" gateway=" + Configer.getInstance().getFloatGateway() + " gwmetric=0";
        }
        try {
            logger.info((Object)(cmd + " dfs0:" + Manager.getInstance().isCurrHaPrimary()));
            if (Manager.getInstance().isCurrHaPrimary()) {
                CmdUtil.execCmd(deleteCmd);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)("changeFloatIp sleep error!" + e.getMessage()));
                }
                CmdUtil.execCmdResult(addCmd);
                messageId = 34;
                CmdUtil.execCmd(cmd);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)("changeFloatIp sleep error!" + e.getMessage()));
                }
                is = NetInterfaceMonitor.isHaveFloatIP();
                this.refreshArp(ip);
            } else {
                messageId = 35;
                CmdUtil.execCmdResult(deleteCmd);
                boolean bl = is = !NetInterfaceMonitor.isHaveFloatIP();
            }
            if (is) {
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(messageId), "success", Configer.getInstance().getFloatInterface(), ip));
            } else {
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(messageId), "failure", Configer.getInstance().getFloatInterface(), ip));
            }
        }
        catch (IOException e) {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(34), "failure", Configer.getInstance().getFloatInterface(), ip));
        }
        return is;
    }

    private void refreshArp(String ip) throws IOException {
        String arpCmd = "";
        String userDir = AticInstallUtil.getInstance().getHAInstallPath();
        String exeFilePath = AticInstallUtil.getInstance().getAticInstallOS() == 1 ? "sudo " + userDir + File.separator + "ddos-arp " : userDir + File.separator + "ddos-arp.exe ";
        arpCmd = exeFilePath + ip;
        logger.info((Object)("refresh arp cmd and ip is: " + ip));
        StringBuffer sb = CmdUtil.execCmdResult(arpCmd);
        logger.info((Object)sb.toString());
        if (sb.toString().contains("success")) {
            logger.info((Object)"refresh arp success!");
        } else {
            logger.error((Object)"refresh arp failed!");
        }
    }

    public void checkFloatIp() {
        if (Manager.getInstance().isCurrHaPrimary()) {
            if (!NetInterfaceMonitor.isHaveFloatIP()) {
                this.changeFloatIp();
            }
        } else if (NetInterfaceMonitor.isHaveFloatIP()) {
            this.changeFloatIp();
        }
    }

    public static boolean isHaveFloatIP() {
        boolean is = false;
        String ip = Configer.getInstance().getFloatIP();
        String cmd = "ipconfig | findstr " + ip;
        if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
            cmd = "sudo ifconfig | grep " + ip;
        }
        String result = "";
        try {
            result = CmdUtil.execCmdResult(cmd).toString();
        }
        catch (IOException e) {
            logger.error((Object)"NetInterfaceMonitor isHaveFloatIP execCmd error");
        }
        if (!"".equals(ip) && result.contains(ip)) {
            is = true;
        }
        return is;
    }

    @Override
    public int getActionType() {
        if (this.needAction()) {
            return 3;
        }
        return 0;
    }
}

