/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.LogManager;
import java.net.Inet4Address;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class NetUtil {
    private static Logger logger = LogManager.getInstance().getHaLog();

    public static NetworkInterface getNetworkInterface(String ip) {
        NetworkInterface nif = null;
        try {
            nif = NetworkInterface.getByInetAddress(Inet4Address.getByName(ip));
        }
        catch (UnknownHostException e) {
            logger.error((Object)"getNetworkInterface  UnknownHostException error");
        }
        catch (SocketException e) {
            logger.error((Object)"getNetworkInterface SocketException error");
        }
        return nif;
    }

    public static boolean checkIpv4(String ip) {
        boolean result = true;
        if (ip == null || ip.equals("")) {
            result = false;
        }
        try {
            Inet4Address.getByName(ip);
        }
        catch (UnknownHostException e) {
            result = false;
        }
        return result;
    }

    public static boolean checkPort(String port) {
        boolean result = false;
        try {
            int iPort = Integer.parseInt(port);
            if (iPort > 0 && iPort <= 65535) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)("error:" + e.getMessage()));
        }
        return result;
    }
}

