/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.AticInstallUtil;
import com.hs.ha.CmdUtil;
import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.vo.MonitorInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WinServiceMonitor
extends BasicMonitor {
    private static final int PRIMARY_WINSERVICE_THRESHOLD = 100;
    private static final int STANDBY_WINSERVICE_THRESHOLD = 0;
    private static final String STANDBY_WINSERVICE_NOT_IGNORE = "0";
    private static final String STANDBY_WINSERVICE_IGNORE = "1";
    private static final String SERVICE_DDOS_LEGOSERVICE = "LEGOWebSrv";
    private static final String SERVICE_DDOS_LEGOMONITOR = "LEGOMonitor";
    private static final String SERVICE_DDOS_MYSQLSERVICE = "mysqlservice";
    private static final String SERVICE_DDOS_COLLECTOR = "Anti-DDoS Collector Service";
    private static final String SERVICE_DDOS_COLLECTOR_MONITOR = "Anti-DDoS Collector Monitor Service";
    private static final String SERVICE_DDOS_MYSQLSERVICE_LINUX = "ps -ef | grep mysqld | grep mysqld_safe | grep atic | grep -v grep | awk '{print $2}'";
    private static final String SERVICE_DDOS_COLLECTOR_LINUX = "ps -ef | grep java | grep antiddos_collector | grep -v grep | awk '{print $2}'";
    private static final String SERVICE_DDOS_LEGOSERVICE_LINUX = "ps -ef | grep java | grep Tomcat6 | grep atic | grep -v grep | awk '{print $2}'";
    private static final String INSTALL_PATH = Configer.getInstance().getInstallPath();
    private static int version = AticInstallUtil.getInstance().getAticInstallOS();
    private static Logger logger = LogManager.getInstance().getHaLog();
    private Map<String, Boolean> batServicesMap = new HashMap<String, Boolean>();
    private boolean isDoBat = false;

    public WinServiceMonitor() {
        this.setName("winservicebase");
        this.initThreshold();
    }

    private boolean isDoBat() {
        return this.isDoBat;
    }

    private void setDoBat(boolean isDoBatT) {
        this.isDoBat = isDoBatT;
    }

    public void resetStartServicesMap() {
        this.batServicesMap = new HashMap<String, Boolean>();
    }

    public void addStartServicesMap(String name, Boolean isBat) {
        this.batServicesMap.put(name, isBat);
    }

    private void initThreshold() {
        if (Manager.getInstance().isCurrHaPrimary()) {
            this.setMonitorThreshold(100);
        } else {
            this.setMonitorThreshold(0);
        }
    }

    public void resetThreshold() {
        if (Manager.getInstance().isCurrHaPrimary()) {
            this.setMonitorThreshold(100);
        } else {
            this.setMonitorThreshold(0);
        }
    }

    @Override
    public int monitorHaIndex() {
        return this.checkWinService();
    }

    @Override
    public void start() throws Exception {
        String serviceName;
        int i;
        String cmd = "";
        String cmdResult = "";
        for (i = 0; i < this.monitorInfoList.size(); ++i) {
            serviceName = ((MonitorInfo)this.monitorInfoList.get(i)).getLocalConfig();
            if (this.batServicesMap.containsKey(serviceName) || this.isHaveService(cmdResult = CmdUtil.execCmdResult(cmd = this.queryCheckCmdByInstallOS(serviceName)).toString(), serviceName)) continue;
            if (AticInstallUtil.getInstance().getAticInstallOS() == 1 && !this.isDoBat()) {
                logger.info((Object)("start011:" + serviceName));
                this.startVsmSystem();
                break;
            }
            cmd = "net start \"" + serviceName + "\"";
            logger.info((Object)("start01" + cmd));
            CmdUtil.execCmd(cmd);
        }
        for (i = 0; i < this.monitorInfoList.size(); ++i) {
            serviceName = ((MonitorInfo)this.monitorInfoList.get(i)).getLocalConfig();
            if (!this.batServicesMap.containsKey(serviceName) || !this.batServicesMap.get(serviceName).booleanValue() || this.isHaveService(cmdResult = CmdUtil.execCmdResult(cmd = this.queryCheckCmdByInstallOS(serviceName)).toString(), serviceName) || this.isDoBat()) continue;
            logger.info((Object)("start02:" + serviceName));
            this.startVsmSystem();
            break;
        }
    }

    @Override
    public void stop() throws Exception {
        String cmd = "";
        String cmdResult = "";
        for (int i = 0; i < this.monitorInfoList.size(); ++i) {
            String serviceName = ((MonitorInfo)this.monitorInfoList.get(i)).getLocalConfig();
            String serviceIgnore = ((MonitorInfo)this.monitorInfoList.get(i)).getLocalDetail();
            cmd = this.queryCheckCmdByInstallOS(serviceName);
            cmdResult = CmdUtil.execCmdResult(cmd).toString();
            if (this.isHaveService(cmdResult, serviceName)) {
                if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_IGNORE) && !this.batServicesMap.containsKey(serviceName)) {
                    cmd = this.queryStopCmdByOs(serviceName, cmdResult);
                    cmdResult = CmdUtil.execCmdResult(cmd).toString();
                    logger.info((Object)("stop011:" + cmdResult));
                    continue;
                }
                if (!serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_IGNORE) || !this.batServicesMap.containsKey(serviceName) || this.isDoBat()) continue;
                this.stopVsmSystem();
                continue;
            }
            if (this.batServicesMap.containsKey(serviceName) || !serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_NOT_IGNORE)) continue;
            cmd = this.queryStartCmdByOs(serviceName);
            logger.info((Object)("stop03:" + cmd));
            CmdUtil.execCmd(cmd);
        }
    }

    private int checkWinService() {
        int index = 100;
        int sucessed = 0;
        try {
            for (int i = 0; i < this.monitorInfoList.size(); ++i) {
                MonitorInfo monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                String serviceName = monitorInfo.getLocalConfig();
                String serviceIgnore = monitorInfo.getLocalDetail();
                String cmd = this.queryCheckCmdByInstallOS(serviceName);
                String cmdResult = CmdUtil.execCmdResult(cmd).toString();
                logger.debug((Object)(serviceName + " result=" + cmdResult));
                if (!this.isHaveService(cmdResult, serviceName)) {
                    if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_NOT_IGNORE) && !this.batServicesMap.containsKey(serviceName)) {
                        cmd = this.queryStartCmdByOs(serviceName);
                        CmdUtil.execCmd(cmd);
                    } else if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_NOT_IGNORE) && this.batServicesMap.containsKey(serviceName) && !this.isDoBat() && this.batServicesMap.get(serviceName).booleanValue()) {
                        this.startVsmSystem();
                    }
                    if (Manager.getInstance().isCurrHaPrimary()) {
                        if (this.batServicesMap.containsKey(serviceName) && (this.isDoBat() || Manager.getInstance().isModifyingVsmServer())) {
                            ++sucessed;
                            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "ignore", monitorInfo.getName(), serviceName));
                            monitorInfo.setLocalStatus("offline");
                        } else {
                            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "failure", monitorInfo.getName(), serviceName));
                            logger.info((Object)("check01:" + serviceName));
                            ((MonitorInfo)this.monitorInfoList.get(i)).setLocalStatus("down");
                        }
                    } else if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_IGNORE)) {
                        ++sucessed;
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "ignore", monitorInfo.getName(), serviceName));
                        monitorInfo.setLocalStatus("offline");
                    } else {
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "failure", monitorInfo.getName(), serviceName));
                        logger.info((Object)("check02:" + serviceName));
                        monitorInfo.setLocalStatus("down");
                    }
                } else {
                    if (!Manager.getInstance().isCurrHaPrimary()) {
                        if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_IGNORE) && !this.batServicesMap.containsKey(serviceName)) {
                            cmd = this.queryStopCmdByOs(serviceName, cmdResult);
                            CmdUtil.execCmd(cmd);
                        } else if (serviceIgnore.equalsIgnoreCase(STANDBY_WINSERVICE_IGNORE) && this.batServicesMap.containsKey(serviceName) && !this.isDoBat()) {
                            this.stopVsmSystem();
                        }
                    }
                    ++sucessed;
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(9), "success", monitorInfo.getName(), serviceName));
                    monitorInfo.setLocalStatus("up");
                }
                monitorInfo.setTime(System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            logger.error((Object)"checkWinService error");
        }
        if (this.monitorInfoList.size() > 0) {
            index = 100 * sucessed / this.monitorInfoList.size();
        }
        return index;
    }

    private String queryStopCmdByOs(String serviceName, String cmdResult) {
        String cmd = "";
        cmd = 1 == version ? (SERVICE_DDOS_COLLECTOR.equals(serviceName) || SERVICE_DDOS_LEGOSERVICE.equals(serviceName) ? INSTALL_PATH + "engineering" + File.separator + "tools" + File.separator + "shutdown.sh" : "kill -9 " + cmdResult) : "net stop \"" + serviceName + "\"";
        return cmd;
    }

    private String queryStartCmdByOs(String serviceName) {
        String cmd = "";
        if (1 == version) {
            if (SERVICE_DDOS_MYSQLSERVICE.equals(serviceName)) {
                cmd = "sudo service mysql start";
            } else if (SERVICE_DDOS_COLLECTOR.equals(serviceName)) {
                cmd = INSTALL_PATH + "components" + File.separator + "antiddos_collector" + File.separator + "startup.sh";
            } else if (SERVICE_DDOS_LEGOSERVICE.equals(serviceName)) {
                cmd = INSTALL_PATH + "components" + File.separator + "atic" + File.separator + "startup.sh";
            }
        } else {
            cmd = "net start \"" + serviceName + "\"";
        }
        return cmd;
    }

    private String queryCheckCmdByInstallOS(String serviceName) {
        String cmd = "";
        if (1 == version) {
            if (SERVICE_DDOS_MYSQLSERVICE.equals(serviceName)) {
                cmd = SERVICE_DDOS_MYSQLSERVICE_LINUX;
            } else if (SERVICE_DDOS_COLLECTOR.equals(serviceName) || SERVICE_DDOS_COLLECTOR_MONITOR.equals(serviceName)) {
                cmd = SERVICE_DDOS_COLLECTOR_LINUX;
            } else if (SERVICE_DDOS_LEGOSERVICE.equals(serviceName) || SERVICE_DDOS_LEGOMONITOR.equals(serviceName)) {
                cmd = SERVICE_DDOS_LEGOSERVICE_LINUX;
            }
        } else {
            cmd = "net start|find \"" + serviceName + "\"";
        }
        return cmd;
    }

    private boolean needAction() {
        return this.getFailedTimes() >= this.getMaxFaileTimes() && Manager.getInstance().isAutoSwitch() && Manager.getInstance().isHaPair() && Manager.getInstance().isCurrHaPrimary() && !Manager.getInstance().isModifyingVsmServer();
    }

    @Override
    public int getActionType() {
        if (this.needAction()) {
            return 3;
        }
        return 0;
    }

    private boolean isHaveService(String result, String serviceName) {
        boolean is = false;
        if (1 == version) {
            is = Pattern.matches("^[\\d]+$", result);
        } else {
            for (int i = 0; i < result.split("   ").length; ++i) {
                if (!result.split("   ")[i].trim().equalsIgnoreCase(serviceName)) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    private void startVsmSystem() {
        this.setDoBat(true);
        try {
            if (1 == version) {
                String path = INSTALL_PATH + "engineering" + File.separator + "tools" + File.separator + "startup.sh";
                CmdUtil.execCmd(path);
            } else {
                CmdUtil.execCmd("start " + Configer.getInstance().getStartBatPath());
            }
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(46), "success", new Object[0]));
        }
        catch (IOException e) {
            logger.error((Object)"startVsmSystem error");
        }
        finally {
            this.setDoBat(false);
        }
    }

    private void stopVsmSystem() {
        this.setDoBat(true);
        try {
            if (1 == version) {
                String path = INSTALL_PATH + "engineering" + File.separator + "tools" + File.separator + "shutdown.sh";
                CmdUtil.execCmd(path);
            } else {
                CmdUtil.execCmd("start " + Configer.getInstance().getStopBatPath());
            }
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(48), "success", new Object[0]));
        }
        catch (IOException e) {
            logger.error((Object)"stopVsmSystem error");
        }
        finally {
            this.setDoBat(false);
        }
    }
}

