/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.rmi.impl;

import com.hs.ha.Configer;
import com.hs.ha.HaRmi;
import com.hs.ha.LogManager;
import com.hs.ha.Manager;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.rmi.ManageService;
import com.hs.ha.vo.MonitorInfo;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ManageServiceImpl
extends UnicastRemoteObject
implements ManageService {
    private static final long serialVersionUID = 7243597064351630270L;
    private static Logger logger = LogManager.getInstance().getHaLog();

    public ManageServiceImpl(int port) throws RemoteException {
        super(port);
    }

    @Override
    public List<MonitorInfo> getMonitorInfoList() throws RemoteException {
        List<MonitorInfo> localList = Manager.getInstance().getMonitorInfoList();
        List<MonitorInfo> remoteList = null;
        if (Manager.getInstance().isHaPair()) {
            try {
                remoteList = RmiServiceUtil.getPairMonitorInfoList();
            }
            catch (Exception e) {
                logger.error((Object)"ManageServiceImpl-getMonitorInfoList error");
            }
        }
        return this.mergeMonitorInfoList(localList, remoteList);
    }

    private List<MonitorInfo> mergeMonitorInfoList(List<MonitorInfo> localList, List<MonitorInfo> remoteList) {
        Vector<MonitorInfo> list = new Vector<MonitorInfo>();
        if (localList != null && localList.size() > 0) {
            list.addAll(localList);
        }
        if (Manager.getInstance().isHaPair() && remoteList != null && remoteList.size() > 0) {
            block0: for (MonitorInfo local : list) {
                for (MonitorInfo remote : remoteList) {
                    if (!remote.getName().equalsIgnoreCase(local.getName())) continue;
                    if (local.getName().indexOf("heartbeat") >= 0) {
                        if (local.getLocalStatus().equals("down") || local.getRemoteStatus().equals("down") || remote.getLocalStatus().equals("down") || remote.getRemoteStatus().equals("down")) {
                            local.setLocalStatus("down");
                            local.setRemoteConfig(remote.getLocalConfig());
                            local.setRemoteDetail(remote.getLocalDetail());
                            local.setRemoteStatus("down");
                            continue block0;
                        }
                        local.setRemoteConfig(remote.getLocalConfig());
                        local.setRemoteDetail(remote.getLocalDetail());
                        local.setRemoteStatus("up");
                        continue block0;
                    }
                    local.setRemoteConfig(remote.getLocalConfig());
                    local.setRemoteDetail(remote.getLocalDetail());
                    local.setRemoteStatus(remote.getLocalStatus());
                    continue block0;
                }
            }
        } else {
            for (MonitorInfo local : list) {
                if (local.getName().indexOf("heartbeat") >= 0) {
                    local.setLocalStatus("down");
                    local.setRemoteStatus("down");
                    continue;
                }
                if ((local.getName().indexOf("name") >= 0 || local.getName().indexOf("haRole") >= 0) && Manager.getInstance().isHaPair()) continue;
                local.setRemoteConfig("--");
                local.setRemoteDetail("--");
                local.setRemoteStatus("--");
            }
        }
        return list;
    }

    @Override
    public String switchHa() throws RemoteException {
        String remoteIp;
        block5: {
            remoteIp = "";
            Manager.getInstance().setSwitch(true);
            remoteIp = Manager.getInstance().getAvailableRemoteIp();
            logger.error((Object)Configer.getInstance().getLogMessage(16));
            if (Manager.getInstance().isCurrHaPrimary() && Manager.getInstance().isHaPair() && Manager.getInstance().isHaEnabled()) {
                try {
                    logger.info((Object)Configer.getInstance().getLogMessage(17));
                    if (RmiServiceUtil.notifyHaSwitch()) {
                        Manager.getInstance().switchHa();
                        remoteIp = remoteIp + ";true";
                        logger.info((Object)Configer.getInstance().getLogMessage(18));
                        break block5;
                    }
                    remoteIp = remoteIp + ";false";
                    logger.info((Object)Configer.getInstance().getLogMessage(19));
                }
                catch (RuntimeException e) {
                    remoteIp = remoteIp + ";false";
                    logger.error((Object)("error:" + e.getMessage()));
                }
            } else {
                remoteIp = remoteIp + ";false";
                logger.info((Object)Configer.getInstance().getLogMessage(20));
            }
        }
        Manager.getInstance().setSwitch(false);
        return remoteIp;
    }

    @Override
    public String startHa() throws RemoteException {
        String result = "";
        if (!Manager.getInstance().isCurrHaPrimary()) {
            result = "remote HA is not primary!";
            return result;
        }
        if (Manager.getInstance().isHaEnabled()) {
            logger.info((Object)Configer.getInstance().getLogMessage(21));
            result = "remote HA is running!";
            return result;
        }
        boolean remoteOk = true;
        if (Manager.getInstance().isHaPair() && HaRmi.getInstance().getMessageRmiConfig() != null) {
            remoteOk = RmiServiceUtil.notifyHaStart();
        }
        if (remoteOk) {
            Manager.getInstance().start();
            result = "remote HA start success!";
            logger.info((Object)Configer.getInstance().getLogMessage(21));
        } else {
            result = "remote HA start error!";
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)("interrupted exception!" + e.getMessage()));
        }
        return result;
    }

    @Override
    public String stopHa() throws RemoteException {
        String result = "";
        if (!Manager.getInstance().isCurrHaPrimary()) {
            result = "remote HA is not primary!";
            return result;
        }
        if (!Manager.getInstance().isHaEnabled()) {
            logger.info((Object)Configer.getInstance().getLogMessage(22));
            result = "remote HA is stoped!";
            return result;
        }
        boolean remoteOk = true;
        if (Manager.getInstance().isHaPair() && HaRmi.getInstance().getMessageRmiConfig() != null) {
            remoteOk = RmiServiceUtil.notifyHaStop();
        }
        if (remoteOk) {
            Manager.getInstance().stop();
            result = "remote HA stop success!";
            logger.info((Object)Configer.getInstance().getLogMessage(22));
        } else {
            result = "remote HA stop error!";
        }
        return result;
    }

    @Override
    public boolean checkHaRunning() throws RemoteException {
        return Manager.getInstance().checkMonitorRunning();
    }

    @Override
    public boolean isAbleToSwitch() throws RemoteException {
        boolean is = false;
        if (!Manager.getInstance().isCurrHaPrimary()) {
            return is;
        }
        if (!Manager.getInstance().isHaPair() || HaRmi.getInstance().getMessageRmiConfig() == null) {
            return is;
        }
        if (!Manager.getInstance().isHaEnabled()) {
            return is;
        }
        try {
            is = RmiServiceUtil.getPairMessageService() != null && RmiServiceUtil.getPairMessageService().isHaStatusOk();
        }
        catch (NotBoundException e) {
            is = false;
        }
        return is;
    }
}

