/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.notify.restful.client;

import com.hs.atic.util.AticConstants;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.restful.util.HttpsConnection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpRestfulClient {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpResponse sendRequest(HttpPost post, String json, String url, Map<String, String> headers, String alias) throws UnsupportedEncodingException {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpRestfulClient.getHttpClient(alias, url);
        StringEntity entity = new StringEntity(json);
        entity.setContentEncoding("utf-8");
        entity.setContentType("application/json;charset=utf8");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            post.setHeader(entry.getKey(), entry.getValue());
        }
        post.setEntity((HttpEntity)entity);
        try {
            LOGGER.info((Object)"httpClient execute start.");
            response = httpClient.execute((HttpUriRequest)post);
            LOGGER.info((Object)"httpClient execute end.");
        }
        catch (SSLException e) {
            LOGGER.error((Object)("HttpRestfulClient sendRequest SSLException e" + e.getMessage()));
            long errorId = 0L;
            errorId = e.getMessage().contains("9600100") ? 9600100L : (e.getMessage().contains("9600200") ? 9600200L : (e.getMessage().contains("9600300") ? 9600300L : 9600400L));
            throw new LegoCheckedException(errorId);
        }
        catch (ClientProtocolException e) {
            LOGGER.error((Object)("httpClient execute error. " + e.getMessage()));
        }
        catch (IOException e) {
            LOGGER.error((Object)("httpClient execute error. " + e.getMessage()));
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"response close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"httpClient close in error");
                }
            }
        }
        return response;
    }

    private static SSLConnectionSocketFactory enableSSL(String alias, String url) {
        try {
            HttpsConnection.HttpsConnectionX509TrustManager ntm = new HttpsConnection.HttpsConnectionX509TrustManager(alias);
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(null, new TrustManager[]{ntm}, new SecureRandom());
            return new SSLConnectionSocketFactory(context, new String[]{"TLSv1.2"}, AticConstants.getHttpSslSupportCiphersuites(), (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("SSLContext is error," + e.getMessage()));
        }
        catch (KeyManagementException e) {
            LOGGER.error((Object)("SSLContext is error," + e.getMessage()));
        }
        return null;
    }

    private static CloseableHttpClient getHttpClient(String alias, String url) {
        RequestConfig defaultRequestConfig = null;
        PoolingHttpClientConnectionManager connectionManager = null;
        Registry socketFactoryRegistry = null;
        SSLConnectionSocketFactory socketFactory = null;
        Object response = null;
        socketFactory = HttpRestfulClient.enableSSL(alias, url);
        defaultRequestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).build();
        socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)socketFactory).build();
        connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig);
        return httpClientBuilder.build();
    }
}

