/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.notify.restful.service.impl;

import com.hs.atic.notify.restful.client.HttpRestfulClient;
import com.hs.atic.notify.restful.dao.RestfulConfigDao;
import com.hs.atic.notify.restful.model.RestfulConfigForm;
import com.hs.atic.notify.restful.service.RestfulService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;

public class RestfulServiceImpl
implements RestfulService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static final int DEFAULT_ERROR_CODE = 400;
    private RestfulConfigDao restfulConfigDao;
    private IDataProtectService dataProtectService;

    @Override
    public List<RestfulConfigForm> getRestfulConfig() {
        List<RestfulConfigForm> restfulConfig = this.restfulConfigDao.getRestfulConfig();
        if (null == restfulConfig || restfulConfig.isEmpty()) {
            return new ArrayList<RestfulConfigForm>();
        }
        for (RestfulConfigForm restfulConfigForm : restfulConfig) {
            String password = restfulConfigForm.getPassword();
            if (null == password) continue;
            String sdpDecrypt = this.dataProtectService.sdpDecrypt(0L, password);
            restfulConfigForm.setPassword(sdpDecrypt);
        }
        return restfulConfig;
    }

    @Override
    public void saveRestfulConfig(RestfulConfigForm form) {
        String password = form.getPassword();
        RestfulConfigForm restfulConfigByType = this.restfulConfigDao.getRestfulConfigByType(form.getType());
        if (null != restfulConfigByType) {
            form.setId(restfulConfigByType.getId());
            this.restfulConfigDao.evict(restfulConfigByType);
        }
        if (null != password && !"".equals(password)) {
            String sdpEncrypt = this.dataProtectService.sdpEncrypt(0L, password);
            form.setPassword(sdpEncrypt);
        } else if (null != restfulConfigByType) {
            form.setPassword(restfulConfigByType.getPassword());
        }
        LOGGER.info((Object)("save config : " + form.toString()));
        this.restfulConfigDao.saveRestfulConfig(form);
    }

    @Override
    public long testRestfulCloudServer(RestfulConfigForm restfulConfigForm) {
        try {
            long status = this.sendTestRequest(restfulConfigForm);
            return status;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage());
            return 400L;
        }
    }

    private long sendTestRequest(RestfulConfigForm restfulConfigForm) throws IOException {
        String json = this.assemblyLoginJson(restfulConfigForm);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=utf8");
        LOGGER.info((Object)"begin to connect loginUrl. ");
        HttpPost post = new HttpPost(restfulConfigForm.getLoginUrl());
        try {
            CloseableHttpResponse response = HttpRestfulClient.sendRequest(post, json, restfulConfigForm.getLoginUrl(), headers, restfulConfigForm.getCloudCertAlias());
            if (response != null) {
                int httpCode = response.getStatusLine().getStatusCode();
                LOGGER.info((Object)("get response httpCode : " + httpCode));
                long l = httpCode;
                return l;
            }
            LOGGER.error((Object)"get response error. response is null. please check.");
            long l = 400L;
            return l;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("LegoCheckedException get response error. response is null. please check." + e.getMessage()));
            throw e;
        }
        finally {
            post.releaseConnection();
        }
    }

    private String assemblyLoginJson(RestfulConfigForm restfulConfigForm) {
        String userName = restfulConfigForm.getUserName();
        String password = restfulConfigForm.getPassword();
        String domainName = restfulConfigForm.getDomainName();
        String projectName = restfulConfigForm.getProjectName();
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        if (this.hasDomain(domainName)) {
            buff.append("\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{");
        }
        buff.append("\"name\":");
        buff.append("\"");
        buff.append(userName);
        buff.append("\"");
        buff.append(",");
        buff.append("\"password\":");
        buff.append("\"");
        buff.append(password);
        buff.append("\"");
        if (this.hasDomain(domainName)) {
            buff.append(",");
            buff.append("\"domain\":{\"name\":");
            buff.append("\"");
            buff.append(domainName);
            buff.append("\"");
            buff.append("}}}},");
            buff.append("\"scope\":{");
            if (this.hasProject(projectName)) {
                buff.append("\"project\":{\"name\":\"");
                buff.append(projectName);
                buff.append("\"");
                buff.append(",");
            }
            buff.append("\"domain\":{\"name\":");
            buff.append("\"");
            buff.append(domainName);
            buff.append("\"");
            if (this.hasProject(projectName)) {
                buff.append("}");
            }
            buff.append("}}}}");
        } else {
            buff.append("}");
        }
        return buff.toString();
    }

    private boolean hasDomain(String domain) {
        return null != domain && !"".equals(domain) && !"domainName".equals(domain);
    }

    private boolean hasProject(String projName) {
        return null != projName && !"".equals(projName) && !"projectName".equals(projName);
    }

    public RestfulConfigDao getRestfulConfigDao() {
        return this.restfulConfigDao;
    }

    public void setRestfulConfigDao(RestfulConfigDao restfulConfigDao) {
        this.restfulConfigDao = restfulConfigDao;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

