/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.syslog.service;

import com.hs.atic.cbb.collector.parent.service.ICollectorParentService;
import com.hs.atic.rmi.CollectorSendSyslogService;
import com.hs.atic.rmi.FileTransService;
import com.hs.atic.rmi.ServerCollectorRMIProxy;
import com.hs.atic.sdk.syslog.service.ISyslogServerServiceInterface;
import com.hs.atic.syslog.dao.SyslogServerDao;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.send.SyslogSendThread;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.vsm.secservice.sdk.common.util.ServerVsmUtil;
import com.huawei.secsyslog.SysLogClient;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;

public class SyslogServerServiceImpl
implements ISyslogServerServiceInterface {
    protected final transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private SyslogServerDao syslogServerDaoServer;
    private ISyslogSendService syslogSendService;
    private ServerCollectorRMIProxy serverCollectorRMIProxy;

    public ISyslogSendService getSyslogSendService() {
        return this.syslogSendService;
    }

    public void setSyslogSendService(ISyslogSendService syslogSendService) {
        this.syslogSendService = syslogSendService;
    }

    public ServerCollectorRMIProxy getServerCollectorRMIProxy() {
        return this.serverCollectorRMIProxy;
    }

    public void setServerCollectorRMIProxy(ServerCollectorRMIProxy serverCollectorRMIProxy) {
        this.serverCollectorRMIProxy = serverCollectorRMIProxy;
    }

    @Override
    public boolean modifySyslogServer(SyslogServerEntity syslogServer) {
        boolean collectorResult = false;
        ICollectorParentService collectorService = (ICollectorParentService)ServiceContext.getInstance().getService("collectorService", ICollectorParentService.class);
        if (!collectorService.isAllCollectorOnline()) {
            this.logger.info((Object)"Failed to modify Syslog Server : there are some offline collector(s)");
            return collectorResult;
        }
        List collectors = collectorService.listCollector();
        ArrayList<CollectorSendSyslogService> collectorSendSyslogServices = new ArrayList<CollectorSendSyslogService>();
        ArrayList<FileTransService> fileTransServices = new ArrayList<FileTransService>();
        for (String collector : collectors) {
            CollectorSendSyslogService collectorSendSyslogService = this.serverCollectorRMIProxy.getCollectorSendSyslogService(collector);
            FileTransService fileTransService = this.serverCollectorRMIProxy.getFileTransService(collector);
            if (null == collectorSendSyslogService) {
                return false;
            }
            collectorSendSyslogServices.add(collectorSendSyslogService);
            if (null == fileTransService) {
                return false;
            }
            fileTransServices.add(fileTransService);
        }
        for (CollectorSendSyslogService collectorSendSyslogService : collectorSendSyslogServices) {
            try {
                collectorResult = collectorSendSyslogService.modifySyslogConfigs(syslogServer);
            }
            catch (Exception e) {
                this.logger.error((Object)("Collector synchronize syslog information error!" + e.getMessage()));
                return false;
            }
            if (collectorResult) continue;
            this.logger.error((Object)"Collector synchronize syslog information error ");
            return false;
        }
        for (FileTransService fileTransService : fileTransServices) {
            try {
                collectorResult = fileTransService.saveFile(ServerVsmUtil.getInstance().getFileBytes("third_truststore"));
            }
            catch (Exception e) {
                this.logger.error((Object)("Collector save  third_truststore error!" + e.getMessage()));
                return false;
            }
            if (collectorResult) continue;
            this.logger.error((Object)"Collector save  third_truststore error ");
            return false;
        }
        SyslogServerEntity oldSyslogServer = new SyslogServerEntity();
        SyslogServerEntity oldSyslogServerDb = this.syslogServerDaoServer.getSyslogServerById(syslogServer.getId());
        AticUtil.copyProperties((Object)oldSyslogServerDb, (Object)oldSyslogServer);
        boolean modifyResult = this.syslogServerDaoServer.modifySyslogServer(syslogServer);
        if (modifyResult) {
            if (0 != oldSyslogServer.getId()) {
                String ipPort = oldSyslogServer.getServerIp() + "," + oldSyslogServer.getServerPort();
                this.syslogSendService.removeSyslogServerMap(ipPort);
            }
            this.setSendSyslogDate(syslogServer);
        }
        this.logger.error((Object)("collectorSendSyslogService modifyResult=" + modifyResult));
        return modifyResult;
    }

    public SyslogServerDao getSyslogServerDaoServer() {
        return this.syslogServerDaoServer;
    }

    public void setSyslogServerDaoServer(SyslogServerDao syslogServerDaoServer) {
        this.syslogServerDaoServer = syslogServerDaoServer;
    }

    private void setSendSyslogDate(SyslogServerEntity syslogServer) {
        if (null != syslogServer.getServerIp()) {
            String ipPort = syslogServer.getServerIp() + "," + syslogServer.getServerPort();
            this.syslogSendService.putSyslogServerMap(ipPort, syslogServer);
            this.syslogSendService.setSyslogServer();
        }
    }

    @Override
    public List<SyslogServerEntity> getSyslogServer() {
        return this.syslogServerDaoServer.getSyslogServer();
    }

    @Override
    public SyslogServerEntity getSyslogServerById(int id) {
        return this.syslogServerDaoServer.getSyslogServerById(id);
    }

    @Override
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        return this.syslogServerDaoServer.queryByPage(conditionMap, start, pageSize);
    }

    @Override
    public SyslogServerEntity getSyslogServer(Map<String, String> conditionMap) {
        return this.syslogServerDaoServer.getSyslogServer(conditionMap);
    }

    @Override
    public boolean deleteSyslogServer(Map<String, String> conditionMap) {
        boolean deleteFlag = false;
        String idInCondition = conditionMap.get("idInCondition");
        String[] ids = idInCondition.split(",");
        if (0 < ids.length) {
            SyslogServerEntity server;
            int i;
            boolean collectorResult = false;
            ICollectorParentService collectorService = (ICollectorParentService)ServiceContext.getInstance().getService("collectorService", ICollectorParentService.class);
            List collectors = collectorService.listCollector();
            ArrayList<CollectorSendSyslogService> collectorSendSyslogServices = new ArrayList<CollectorSendSyslogService>();
            ArrayList<FileTransService> fileTransServices = new ArrayList<FileTransService>();
            for (String collector : collectors) {
                CollectorSendSyslogService collectorSendSyslogService = this.serverCollectorRMIProxy.getCollectorSendSyslogService(collector);
                FileTransService fileTransService = this.serverCollectorRMIProxy.getFileTransService(collector);
                if (null == collectorSendSyslogService) {
                    return false;
                }
                collectorSendSyslogServices.add(collectorSendSyslogService);
                if (null == fileTransService) {
                    return false;
                }
                fileTransServices.add(fileTransService);
            }
            for (CollectorSendSyslogService collectorSendSyslogService : collectorSendSyslogServices) {
                try {
                    collectorResult = collectorSendSyslogService.deleteSyslogConfigs(idInCondition);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Collector synchronize syslog information error! " + e.getMessage()));
                    return false;
                }
                if (collectorResult) continue;
                this.logger.error((Object)"Collector synchronize syslog information error ");
                return false;
            }
            for (FileTransService fileTransService : fileTransServices) {
                try {
                    collectorResult = fileTransService.saveFile(ServerVsmUtil.getInstance().getFileBytes("third_truststore"));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Collector save  third_truststore error! " + e.getMessage()));
                    return false;
                }
                if (collectorResult) continue;
                this.logger.error((Object)"Collector save  third_truststore error ");
                return false;
            }
            SysOptLog oOptLog = new SysOptLog();
            oOptLog.setLevel(3);
            oOptLog.setTarget("lego.lab.com.syslogserver");
            oOptLog.setTargetLocal(Boolean.valueOf(true));
            oOptLog.setModule("lego.dic.module.system");
            oOptLog.setOperation("lego.lab.com.syslog.server.delete.title");
            String usrName = conditionMap.get("userName");
            String userIp = conditionMap.get("userIp");
            oOptLog.setOperator(usrName);
            oOptLog.setTerminalIp(userIp);
            oOptLog.setResult(1);
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            ArrayList<SyslogServerEntity> serverList = new ArrayList<SyslogServerEntity>();
            for (i = 0; i < ids.length; ++i) {
                server = this.syslogServerDaoServer.getSyslogServerById(Integer.parseInt(ids[i]));
                serverList.add(server);
            }
            deleteFlag = this.syslogServerDaoServer.deleteSyslogServer(conditionMap);
            for (i = 0; i < serverList.size(); ++i) {
                server = (SyslogServerEntity)serverList.get(i);
                String ipPort = server.getServerIp() + "," + server.getServerPort();
                this.syslogSendService.removeSyslogServerMap(ipPort);
                SysLogClient client = SyslogSendThread.getInstance().getSysLogClient();
                if (null != client) {
                    SyslogClientAbstrat serverThread;
                    Map<String, Object> keysAndValues = client.getThreadListKeysAndValues();
                    List keys = (List)keysAndValues.get("keys");
                    List values = (List)keysAndValues.get("values");
                    HashMap serverMap = new HashMap();
                    if (null != keys && keys.size() != 0) {
                        for (int j = 0; j < keys.size(); ++j) {
                            serverMap.put(keys.get(j), values.get(j));
                        }
                    }
                    if (null != (serverThread = (SyslogClientAbstrat)serverMap.get(ipPort))) {
                        serverThread.stopClient();
                    }
                }
                Date date = new Date();
                oOptLog.setDate(date);
                oOptLog.setDetail(server.getServerIp() + "," + server.getServerPort());
                sysOpLog.writeOptLog(oOptLog);
            }
        }
        this.logger.error((Object)("InterruptedException deleteFlag=" + deleteFlag));
        return deleteFlag;
    }

    @Override
    public boolean isExist(String id, String certificateName) {
        if (!StringUtils.isEmpty((String)certificateName)) {
            return this.syslogServerDaoServer.isExist(id, certificateName);
        }
        return false;
    }
}

