/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.hs.atic.bis.util.RadioBean;
import com.hs.atic.bis.util.ServerBisUtil;
import com.hs.atic.sdk.syslog.service.ISyslogServerServiceInterface;
import com.hs.atic.syslog.entity.SyslogReceiveConfEntity;
import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.syslog.entity.SyslogServerEntityForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CertManagementUtil;
import com.hs.atic.util.SystemToolFactory;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.common.util.ServerVsmUtil;
import com.huawei.secsyslog.SyslogServerUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ServerSyslogServerAction
extends BaseAction {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static final long serialVersionUID = -8223252142376295903L;
    private static final int SYSLOG_SERVER_CHECKBOX_SUM = 16;
    private static final int BYTE_ARRAY_SIZE = 1024;
    private static final int SEVERITY_WARNING = 1;
    private static final int SEVERITY_MINOR = 2;
    private static final int SEVERITY_MAJOR = 3;
    private static final int SEVERITY_CRITICAL = 4;
    private String checkboxParams = "";
    private String alarmMinLevelData = null;
    private SyslogServerEntity syslogServerEntity = null;
    private String keystoreDetail = "";
    private SyslogReceiveConfEntity syslogReceiveConfEntity = null;
    private List<RadioBean> protocolList = null;
    private List<RadioBean> defaultZoneList = null;
    private File syslogServerKeystore;
    private List<SyslogServerEntityForm> syslogServerList;
    private int id;
    private String serverIds = null;
    private int maxNumber = 5;

    public String getCheckboxParams() {
        return this.checkboxParams;
    }

    public void setCheckboxParams(String checkboxParams) {
        this.checkboxParams = checkboxParams;
    }

    public String getAlarmMinLevelData() {
        return this.alarmMinLevelData;
    }

    public void setAlarmMinLevelData(String alarmMinLevelData) {
        this.alarmMinLevelData = alarmMinLevelData;
    }

    public SyslogServerEntity getSyslogServerEntity() {
        return this.syslogServerEntity;
    }

    public void setSyslogServerEntity(SyslogServerEntity syslogServerEntity) {
        this.syslogServerEntity = syslogServerEntity;
    }

    public List<RadioBean> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<RadioBean> protocolList) {
        this.protocolList = protocolList;
    }

    public List<RadioBean> getDefaultZoneList() {
        return this.defaultZoneList;
    }

    public void setDefaultZoneList(List<RadioBean> defaultZoneList) {
        this.defaultZoneList = defaultZoneList;
    }

    public File getSyslogServerKeystore() {
        return this.syslogServerKeystore;
    }

    public void setSyslogServerKeystore(File syslogServerKeystore) {
        this.syslogServerKeystore = syslogServerKeystore;
    }

    public String getKeystoreDetail() {
        return this.keystoreDetail;
    }

    public void setKeystoreDetail(String keystoreDetail) {
        this.keystoreDetail = keystoreDetail;
    }

    public SyslogReceiveConfEntity getSyslogReceiveConfEntity() {
        return this.syslogReceiveConfEntity;
    }

    public void setSyslogReceiveConfEntity(SyslogReceiveConfEntity syslogReceiveConfEntity) {
        this.syslogReceiveConfEntity = syslogReceiveConfEntity;
    }

    public List<SyslogServerEntityForm> getSyslogServerList() {
        return this.syslogServerList;
    }

    public void setSyslogServerList(List<SyslogServerEntityForm> syslogServerList) {
        this.syslogServerList = syslogServerList;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getServerIds() {
        return this.serverIds;
    }

    public void setServerIds(String serverIds) {
        this.serverIds = serverIds;
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    public void setMaxNumber(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    public String showSyslogServer() {
        ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
        this.syslogServerList = new ArrayList<SyslogServerEntityForm>();
        if (null != syslogServerService) {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            Paging paing = syslogServerService.queryByPage(conditionMap, this.start, this.pageSize);
            List servers = paing.getData();
            if (!servers.isEmpty()) {
                for (int i = 0; i < servers.size(); ++i) {
                    SyslogServerEntity server = (SyslogServerEntity)servers.get(i);
                    SyslogServerEntityForm form = new SyslogServerEntityForm();
                    AticUtil.copyProperties((Object)server, (Object)form);
                    form.setShowTransmitType(this.getShowTransmitString(server));
                    if (AticUtil.isNull((String)form.getCertificateName())) {
                        form.setCertificateName("--");
                    }
                    this.syslogServerList.add(form);
                }
                this.total = paing.getCount();
            }
            this.maxNumber = SyslogServerUtil.getInstance().getMaxNumber();
        }
        return "success";
    }

    private String getShowTransmitString(SyslogServerEntity syslogServer) {
        String transmitType;
        StringBuffer showTransmitType = new StringBuffer();
        if (1 == syslogServer.getAticOptlog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.aticsyslog") + ",");
        }
        if (1 == syslogServer.getDeviceSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.devicesyslog") + ",");
        }
        if (1 == syslogServer.getThirdSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.thirdsyslog") + ",");
        }
        if (1 == syslogServer.getFlowSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ddosflowsyslog") + ",");
        }
        if (1 == syslogServer.getFlowSyslogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ddosflowsyslog.outbound") + ",");
        }
        if (1 == syslogServer.getIpFlowSecondsSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.ipFlowSecondsSyslog") + ",");
        }
        if (1 == syslogServer.getAlarmSyslog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.fault") + ",");
        }
        if (1 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.warning") + ",");
        } else if (2 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.minor") + ",");
        } else if (3 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.major") + ",");
        } else if (4 == syslogServer.getAlarmMinLevel()) {
            showTransmitType.append(this.getText("lego.fault.severity.critical") + ",");
        }
        if (1 == syslogServer.getAlarmAbnormityLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.abnormitylog") + ",");
        }
        if (1 == syslogServer.getAlarmAttackLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.attacklog") + ",");
        }
        if (1 == syslogServer.getAlarmRefreshLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.refreshlog") + ",");
        }
        if (1 == syslogServer.getAlarmDetailLog()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.detaillog") + ",");
        }
        if (1 == syslogServer.getAlarmAbnormityLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.abnormitylog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmAttackLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.attacklog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmRefreshLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.refreshlog.outbound") + ",");
        }
        if (1 == syslogServer.getAlarmDetailLogOutbound()) {
            showTransmitType.append(this.getText("lego.lab.com.syslog.detaillog.outbound") + ",");
        }
        if (!(transmitType = showTransmitType.toString()).isEmpty()) {
            transmitType = transmitType.substring(0, transmitType.length() - 1);
        }
        return transmitType;
    }

    public String editSyslogServer() {
        this.alarmMinLevelData = this.getAlarmMinLevelCombData();
        this.initProtocolRadioGroup();
        this.initDefaultZoneTransmitRadioGroup();
        ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
        if (null != syslogServerService) {
            this.syslogServerEntity = 0 != this.id ? syslogServerService.getSyslogServerById(this.id) : new SyslogServerEntity();
            this.syslogServerEntity.setCerStorePwd("********");
        }
        return "success";
    }

    public void setSyslogServer() {
        boolean isAdd;
        String operation = "lego.lab.com.syslog.server.create.title";
        boolean bl = isAdd = 0 == this.syslogServerEntity.getId();
        if (!isAdd) {
            operation = "lego.lab.log.func.modifysyslogsrv";
        }
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.setSyslogServer)) {
            LegoCheckedException legoCheckedException = new LegoCheckedException(570516L);
            logger.error((Object)("syslogServerEntity LegoCheckedException error," + legoCheckedException.getMessage()));
            String errorKey = "lego.err." + legoCheckedException.getErrorCode();
            this.systemOpeLog(operation, "lego.dic.module.system", true, null, errorKey, "lego.lab.com.syslogserver", SysoplogLevel.normal.getValue(), false, (Exception)((Object)legoCheckedException));
            throw legoCheckedException;
        }
        try {
            boolean isSaveSyslogServer;
            ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
            if (null == syslogServerService) {
                logger.error((Object)"syslogServerService is null.");
                throw new LegoCheckedException(570507L);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("serverIp", this.syslogServerEntity.getServerIp());
            map.put("serverPort", this.syslogServerEntity.getServerPort() + "");
            SyslogServerEntity server = null;
            if (isAdd) {
                int max = SyslogServerUtil.getInstance().getMaxNumber();
                List<SyslogServerEntity> servers = syslogServerService.getSyslogServer();
                this.maxNumber = max;
                if (servers.size() >= max) {
                    this.responseResult("MAX");
                    this.systemOpeLog(operation, "lego.dic.module.system", true, new String[]{String.valueOf(max)}, "lego.lab.com.syslog.server.max.number", "lego.lab.com.syslogserver", SysoplogLevel.normal.getValue(), false, null);
                    return;
                }
                server = syslogServerService.getSyslogServer(map);
            } else {
                map.put("id", this.syslogServerEntity.getId() + "");
                server = syslogServerService.getSyslogServer(map);
            }
            if (null != server && 0 < server.getId()) {
                logger.error((Object)"syslogServerEntity has been existed a same serverip and port server.");
                this.responseResult("EXIST");
                this.systemOpeLog(operation, "lego.dic.module.system", true, null, "lego.lab.com.syslog.server.exist", "lego.lab.com.syslogserver", SysoplogLevel.normal.getValue(), false, null);
                return;
            }
            String[] checkboxCheckeds = this.checkboxParams.split(",");
            if (checkboxCheckeds.length != 16) {
                logger.error((Object)("checkboxCheckeds's length is wrong. checkboxCheckeds is :" + checkboxCheckeds.length));
                throw new LegoCheckedException(570505L);
            }
            this.syslogServerEntity.setAticOptlog(Integer.parseInt(checkboxCheckeds[0]));
            this.syslogServerEntity.setDeviceSyslog(Integer.parseInt(checkboxCheckeds[1]));
            this.syslogServerEntity.setThirdSyslog(Integer.parseInt(checkboxCheckeds[2]));
            this.syslogServerEntity.setFlowSyslog(Integer.parseInt(checkboxCheckeds[3]));
            this.syslogServerEntity.setFlowSyslogOutbound(Integer.parseInt(checkboxCheckeds[4]));
            this.syslogServerEntity.setIpFlowSecondsSyslog(Integer.parseInt(checkboxCheckeds[5]));
            this.syslogServerEntity.setAlarmSyslog(Integer.parseInt(checkboxCheckeds[6]));
            this.syslogServerEntity.setAlarmAbnormityLog(Integer.parseInt(checkboxCheckeds[7]));
            this.syslogServerEntity.setAlarmAttackLog(Integer.parseInt(checkboxCheckeds[8]));
            this.syslogServerEntity.setAlarmRefreshLog(Integer.parseInt(checkboxCheckeds[9]));
            this.syslogServerEntity.setAlarmDetailLog(Integer.parseInt(checkboxCheckeds[10]));
            this.syslogServerEntity.setAlarmAbnormityLogOutbound(Integer.parseInt(checkboxCheckeds[11]));
            this.syslogServerEntity.setAlarmAttackLogOutbound(Integer.parseInt(checkboxCheckeds[12]));
            this.syslogServerEntity.setAlarmRefreshLogOutbound(Integer.parseInt(checkboxCheckeds[13]));
            this.syslogServerEntity.setAlarmDetailLogOutbound(Integer.parseInt(checkboxCheckeds[14]));
            this.syslogServerEntity.setTransferProtocol(Integer.parseInt(checkboxCheckeds[15]));
            if (1 == this.syslogServerEntity.getTransferProtocol() && null != this.syslogServerKeystore) {
                this.checkFileSize();
                if (!this.checkFileIsCorrect()) {
                    throw new LegoCheckedException(573002L);
                }
                String alias = this.syslogServerEntity.getServerIp() + "," + this.syslogServerEntity.getServerPort();
                this.syslogServerEntity.setCertificateName(alias);
                boolean isServerCertReady = this.importCert(alias);
                if (!isServerCertReady) {
                    logger.error((Object)"syslogServerEntity saved syslogServerKeystore failed");
                    this.responseResult("SAVE_FEILED");
                    this.systemOpeLog(operation, "lego.dic.module.system", true, null, "lego.lab.log.func.modifysyslogsrv.save.failed", "lego.lab.com.syslogserver", SysoplogLevel.normal.getValue(), false, null);
                    return;
                }
            }
            if (!(isSaveSyslogServer = syslogServerService.modifySyslogServer(this.syslogServerEntity))) {
                logger.error((Object)"syslogServerEntity saved config failed");
                throw new LegoCheckedException(571815L);
            }
            logger.info((Object)"syslogServerEntity saved result is = success");
            this.responseResult("success");
            this.systemOpeLog(operation, "lego.dic.module.system", true, null, "lego.lab.com.syslog.success", "lego.lab.com.syslogserver", SysoplogLevel.info.getValue(), true, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("syslogServerEntity LegoCheckedException error," + e.getMessage()));
            String errorKey = "lego.err." + e.getErrorCode();
            this.systemOpeLog(operation, "lego.dic.module.system", true, null, errorKey, "lego.lab.com.syslogserver", SysoplogLevel.normal.getValue(), false, (Exception)((Object)e));
            throw e;
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.setSyslogServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean importCert(String alias) {
        boolean isSaveServer = false;
        FileInputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            inputStream = new FileInputStream(this.syslogServerKeystore);
            bufferedInputStream = new BufferedInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bufferedInputStream.read(buf)) != -1) {
                byteArrayOutputStream.write(buf, 0, len);
            }
            byte[] arr = byteArrayOutputStream.toByteArray();
            boolean isExist = CertManagementUtil.getInstance().isExistByAlias(alias);
            if (isExist) {
                boolean deleteSuccess = CertManagementUtil.getInstance().deleteCert(alias);
                logger.info((Object)(alias + ", deleteCert  result is " + deleteSuccess));
                if (deleteSuccess) {
                    isSaveServer = CertManagementUtil.getInstance().importCert(alias, arr);
                }
            } else {
                isSaveServer = CertManagementUtil.getInstance().importCert(alias, arr);
            }
            this.closeStream(inputStream, bufferedInputStream, byteArrayOutputStream);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("syslog FileNotFoundException error ," + e.getMessage()));
            this.closeStream(inputStream, bufferedInputStream, byteArrayOutputStream);
        }
        catch (IOException e2) {
            logger.error((Object)("syslog IOException error ," + e2.getMessage()));
            this.closeStream(inputStream, bufferedInputStream, byteArrayOutputStream);
            {
                catch (Throwable throwable) {
                    this.closeStream(inputStream, bufferedInputStream, byteArrayOutputStream);
                    throw throwable;
                }
            }
        }
        return isSaveServer;
    }

    private void closeStream(InputStream inputStream, BufferedInputStream bufferedInputStream, ByteArrayOutputStream byteArrayOutputStream) {
        try {
            if (null != byteArrayOutputStream) {
                byteArrayOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"byteArrayOutputStream.close() failed");
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"bufferedInputStream.close() failed");
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"inputStream.close() failed");
        }
    }

    public void deleteSyslogServer() {
        if (!StringUtils.isEmpty((CharSequence)this.serverIds)) {
            boolean isDeleteServer = false;
            boolean isDeleteCert = false;
            ISyslogServerServiceInterface syslogServerService = ServerBisUtil.getSyslogServerService();
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            String ids = this.serverIds.substring(0, this.serverIds.length() - 1);
            conditionMap.put("idInCondition", ids);
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            conditionMap.put("userName", currentUser.getUserName());
            conditionMap.put("userIp", currentUser.getIpAdr());
            if (null != syslogServerService) {
                try {
                    isDeleteCert = this.deleteKeystoreCert(syslogServerService, ids);
                    if (isDeleteCert) {
                        isDeleteServer = syslogServerService.deleteSyslogServer(conditionMap);
                    }
                }
                catch (LegoCheckedException ex) {
                    this.systemOpeLog("lego.lab.com.syslog.server.delete.title", "lego.dic.module.system", true, null, null, "lego.lab.com.syslogserver", 3, false, (Exception)((Object)ex));
                    this.responseResult("DELETE_FEILED");
                    return;
                }
                catch (RuntimeException ex) {
                    this.systemOpeLog("lego.lab.com.syslog.server.delete.title", "lego.dic.module.system", true, null, null, "lego.lab.com.syslogserver", 3, false, ex);
                    this.responseResult("DELETE_FEILED");
                    return;
                }
                catch (Exception ex) {
                    this.systemOpeLog("lego.lab.com.syslog.server.delete.title", "lego.dic.module.system", true, null, null, "lego.lab.com.syslogserver", 3, false, ex);
                    this.responseResult("DELETE_FEILED");
                    return;
                }
            }
            if (!isDeleteCert) {
                logger.error((Object)"syslogServerEntity delete cert failed");
                this.systemOpeLog("lego.lab.com.syslog.server.delete.title", "lego.dic.module.system", true, null, null, "lego.lab.com.syslogserver", 3, false, null);
                this.responseResult("deleteCertFail");
                return;
            }
            if (!isDeleteServer) {
                logger.error((Object)"syslogServerEntity delete failed");
                this.systemOpeLog("lego.lab.com.syslog.server.delete.title", "lego.dic.module.system", true, null, null, "lego.lab.com.syslogserver", 3, false, null);
                this.responseResult("DELETE_FEILED");
                return;
            }
        }
        this.responseResult("success");
    }

    private boolean deleteKeystoreCert(ISyslogServerServiceInterface syslogServerService, String idstr) {
        String[] ids = idstr.split(",");
        for (int i = 0; i < ids.length; ++i) {
            SyslogServerEntity server = syslogServerService.getSyslogServerById(Integer.parseInt(ids[i]));
            boolean isExist = CertManagementUtil.getInstance().isExistByAlias(server.getCertificateName());
            if (!isExist) continue;
            boolean deleteSuccess = CertManagementUtil.getInstance().deleteCert(server.getCertificateName());
            logger.info((Object)(", deleteCert  result is " + deleteSuccess));
            if (deleteSuccess) continue;
            logger.error((Object)("deleteKeystoreCert third_truststore , certificateName is " + server.getCertificateName()));
            return false;
        }
        return true;
    }

    public String showKeystoreDetail() {
        try {
            StringBuffer pwd = DataProtectServiceConst.sdpDecryptInitDataBuffer((String)ServerVsmUtil.getInstance().getThridCertPwdFromCfg());
            this.keystoreDetail = ServerVsmUtil.getInstance().printKeystoreInfo(this.getCertsPath() + "third_truststore", pwd.toString());
        }
        catch (RuntimeException e) {
            this.keystoreDetail = "Analysis failed.";
        }
        return "success";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadThirdTruststore() {
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.downloadThirdTruststore)) {
            throw new LegoCheckedException(570516L);
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream input = null;
        ServletOutputStream servletOutputStream = null;
        BufferedOutputStream output = null;
        try {
            HttpServletResponse response = this.getResponse();
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("third_truststore".getBytes("gb2312"), "ISO-8859-1"));
            fileInputStream = new FileInputStream(this.getCertsPath() + "third_truststore");
            input = new BufferedInputStream(fileInputStream);
            servletOutputStream = response.getOutputStream();
            output = new BufferedOutputStream((OutputStream)servletOutputStream);
            byte[] b = new byte[1024];
            int len = 0;
            while ((len = input.read(b)) != -1) {
                output.write(b, 0, len);
            }
            output.flush();
            String[] detailPara = new String[]{"third_truststore"};
            this.systemOpeLog("atic.lab.com.syslog.keystore.download", "lego.dic.module.system", false, detailPara, "atic.lab.com.syslog.keystore.download.detail", "third_truststore", 3, true, null);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"download error IOException");
                this.systemOpeLog("atic.lab.com.syslog.keystore.download", "lego.dic.module.system", false, null, null, "third_truststore", 3, false, e);
                throw new LegoUncheckedException((Throwable)e);
                catch (RuntimeException e2) {
                    logger.error((Object)("download error RuntimeException!" + e2.getMessage()));
                    this.systemOpeLog("atic.lab.com.syslog.keystore.download", "lego.dic.module.system", false, null, null, "third_truststore", 3, false, e2);
                    throw new LegoUncheckedException((Throwable)e2);
                }
                catch (Exception e3) {
                    logger.error((Object)("download error Exception!" + e3.getMessage()));
                    this.systemOpeLog("atic.lab.com.syslog.keystore.download", "lego.dic.module.system", false, null, null, "third_truststore", 3, false, e3);
                    throw new LegoUncheckedException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.closeInput(input);
                this.closeFileInputStream(fileInputStream);
                this.closeOutput(output);
                this.closeServletOutputStream(servletOutputStream);
                OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.downloadThirdTruststore);
                throw throwable;
            }
        }
        this.closeInput(input);
        this.closeFileInputStream(fileInputStream);
        this.closeOutput(output);
        this.closeServletOutputStream(servletOutputStream);
        OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.downloadThirdTruststore);
    }

    private void closeInput(BufferedInputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"input close IOException");
        }
    }

    private void closeFileInputStream(FileInputStream fileInputStream) {
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"fileInputStream close IOException");
        }
    }

    private void closeOutput(BufferedOutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"output close IOException");
        }
    }

    private void closeServletOutputStream(ServletOutputStream servletOutputStream) {
        try {
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"servletOutputStream close IOException");
        }
    }

    public boolean validateParams() {
        if (!this.checkParas()) {
            return false;
        }
        return this.checkboxParams != null && !"".equals(this.checkboxParams);
    }

    private boolean checkParas() {
        int transferProtocol = this.syslogServerEntity.getTransferProtocol();
        if (transferProtocol == 0) {
            return this.checkUdpParams();
        }
        if (transferProtocol == 1) {
            return this.checkTcpParams();
        }
        return false;
    }

    private boolean checkTcpParams() {
        if (null == this.syslogServerEntity) {
            return true;
        }
        if (!this.checkTcpParamsBefore()) {
            return false;
        }
        int port = this.syslogServerEntity.getServerPort();
        return 1 <= port && 65535 >= port;
    }

    private void checkFileSize() {
        if (null != this.syslogServerKeystore) {
            long min = SystemToolFactory.getMinsize();
            if (this.syslogServerKeystore.length() > 0x100000L || this.syslogServerKeystore.length() > min) {
                throw new LegoCheckedException(573000L);
            }
        }
    }

    private boolean checkFileIsCorrect() {
        return null != this.syslogServerEntity && this.syslogServerEntity.getCerStorePwd().equals(CertManagementUtil.getInstance().getThridCertPwdFromCfg());
    }

    private boolean checkTcpParamsBefore() {
        String ips;
        if (null != this.syslogServerKeystore) {
            String cerStorePwd = this.syslogServerEntity.getCerStorePwd();
            if (AticUtil.isNull((String)cerStorePwd) || cerStorePwd.length() > 64 || cerStorePwd.length() < 6) {
                return false;
            }
            Pattern p1 = Pattern.compile("[a-zA-Z]+");
            Pattern p2 = Pattern.compile("[0-9]+");
            Pattern p3 = Pattern.compile("[=\\-_!@#%/*^:,.+}{]");
            Matcher m1 = p1.matcher(cerStorePwd);
            Matcher m2 = p2.matcher(cerStorePwd);
            Matcher m3 = p3.matcher(cerStorePwd);
            if (!(m1.find() && m2.find() && m3.find())) {
                return false;
            }
            String pwdregex = "[a-zA-Z0-9=\\-_!@#%/*^:,.+}{]+$";
            if (!cerStorePwd.matches(pwdregex)) {
                return false;
            }
        }
        if (null == (ips = this.syslogServerEntity.getServerIp()) || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUdpParams() {
        if (!this.checkUdpParamsBefore()) {
            return false;
        }
        int port = this.syslogServerEntity.getServerPort();
        return 1 <= port && 65535 >= port;
    }

    private boolean checkUdpParamsBefore() {
        if (null == this.syslogServerEntity) {
            return true;
        }
        String ips = this.syslogServerEntity.getServerIp();
        if (null == ips || "".equals(ips.trim())) {
            return false;
        }
        if (ips.length() < 255) {
            String[] split;
            for (String ip : split = ips.split(",")) {
                if (IPUtil.isIpv4((String)ip) || IPUtil.isIpv6((String)ip)) continue;
                return false;
            }
        }
        return true;
    }

    private String getCertsPath() {
        String savePath = ServerVsmUtil.getInstallPath() + File.separator + "LegoRuntime" + File.separator + "cert" + File.separator;
        return savePath;
    }

    public String getAlarmMinLevelCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(4).append("','").append(this.getText("lego.fault.severity.critical")).append("'],");
        combData.append("['").append(3).append("','").append(this.getText("lego.fault.severity.major")).append("'],");
        combData.append("['").append(2).append("','").append(this.getText("lego.fault.severity.minor")).append("'],");
        combData.append("['").append(1).append("','").append(this.getText("lego.fault.severity.warning")).append("']]");
        return combData.toString();
    }

    private void initProtocolRadioGroup() {
        this.protocolList = new ArrayList<RadioBean>();
        RadioBean appointIpRadio = new RadioBean();
        appointIpRadio.setKey(0);
        appointIpRadio.setLabel(this.getText("lego.lab.com.syslog.protocol.udp"));
        this.protocolList.add(appointIpRadio);
        RadioBean zoneIpRadio = new RadioBean();
        zoneIpRadio.setKey(1);
        zoneIpRadio.setLabel(this.getText("lego.lab.com.syslog.protocol.tcp"));
        this.protocolList.add(zoneIpRadio);
    }

    private void initDefaultZoneTransmitRadioGroup() {
        this.defaultZoneList = new ArrayList<RadioBean>();
        RadioBean appointIpRadio = new RadioBean();
        appointIpRadio.setKey(1);
        appointIpRadio.setLabel(this.getText("lego.lab.com.syslog.server.transmit"));
        this.defaultZoneList.add(appointIpRadio);
        RadioBean zoneIpRadio = new RadioBean();
        zoneIpRadio.setKey(0);
        zoneIpRadio.setLabel(this.getText("lego.lab.com.syslog.server.no.transmit"));
        this.defaultZoneList.add(zoneIpRadio);
    }

    public boolean validatePort() {
        String[] checkboxCheckeds;
        if (null == this.syslogReceiveConfEntity) {
            return false;
        }
        int tcpPort = this.syslogReceiveConfEntity.getTcpReceivePort();
        int udpPort = this.syslogReceiveConfEntity.getUdpReceivePort();
        if (null != this.checkboxParams && (checkboxCheckeds = this.checkboxParams.split(",")).length == 2) {
            this.syslogReceiveConfEntity.setEnableTcpReceive("1".equals(checkboxCheckeds[0]));
            this.syslogReceiveConfEntity.setEnableUdpReceive("1".equals(checkboxCheckeds[1]));
        }
        if (this.syslogReceiveConfEntity.isEnableTcpReceive()) {
            if (tcpPort < 1 || tcpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setTcpReceivePort(6514);
        }
        if (this.syslogReceiveConfEntity.isEnableUdpReceive()) {
            if (udpPort < 1 || udpPort > 65535) {
                return false;
            }
        } else {
            this.syslogReceiveConfEntity.setUdpReceivePort(514);
        }
        return true;
    }

    public boolean validateServerIds() {
        String regex = "^[0-9,]+$";
        boolean res = this.serverIds.matches(regex);
        if (res) {
            String[] severids = this.serverIds.split(",");
            if (severids.length > 100) {
                return false;
            }
            for (String id : severids) {
                if (Long.parseLong(id) >= 0L) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

