/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.config.SpTypeConfig;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.sdk.service.IAticSmsService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AticSmsServiceContainer {
    private static List<IAticSmsService> aticSmsServiceList = new ArrayList<IAticSmsService>();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);

    public static IAticSmsService getAticSmsService() {
        for (IAticSmsService aticSmsService : aticSmsServiceList) {
            if (SpTypeConfig.getSpType() != aticSmsService.getSpType()) continue;
            return aticSmsService;
        }
        LOGGER.info((Object)("not found AticSmsService Implements,spType=" + SpTypeConfig.getSpType()));
        return null;
    }

    public void onBind(IAticSmsService service, Map<String, String> properties) {
        if (null == service) {
            LOGGER.info((Object)"onBind AticSmsService,service is null.");
            return;
        }
        try {
            aticSmsServiceList.add(service);
            LOGGER.info((Object)("onBind AticSmsService:" + service.getClass().getName()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("onBind AticSmsService exception." + e.getMessage()));
        }
    }

    public void onUnbind(IAticSmsService service, Map<String, String> properties) {
        if (null == service) {
            LOGGER.info((Object)"onUnBind AticSmsService,service is null.");
            return;
        }
        try {
            aticSmsServiceList.remove(service);
            LOGGER.info((Object)("onUnBind AticSmsService:" + service.getClass().getName()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("onUnBind AticSmsService exception." + e.getMessage()));
        }
    }

    public static List<IAticSmsService> getAticSmsServiceList() {
        return aticSmsServiceList;
    }

    public static void setAticSmsServiceList(List<IAticSmsService> aticSmsServiceList) {
        AticSmsServiceContainer.aticSmsServiceList = aticSmsServiceList;
    }
}

