/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.config;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.common.util.ServerVsmUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class SpTypeConfig {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static final Object LOCK = new Object();
    private static int spType;
    private static boolean readOver;
    private static Properties config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSpConfFile() {
        Object object = LOCK;
        synchronized (object) {
            SpTypeConfig.setReadOver(false);
            FileInputStream fin = null;
            try {
                File file = new File(ServerVsmUtil.getInstallPath() + File.separator + "LegoRuntime" + File.separator);
                String currentPath = file.getCanonicalPath();
                currentPath = currentPath + File.separator + "spconfig" + File.separator + "spTypeConf.properties";
                fin = new FileInputStream(currentPath);
                config.load(fin);
                String type = config.getProperty("spType", String.valueOf(0));
                spType = Integer.parseInt(type);
            }
            catch (IOException e) {
                LOGGER.error((Object)"readSpConfFile IOException.");
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("NumberFormatException:" + e.getMessage()));
            }
            catch (Exception e) {
                LOGGER.error((Object)("readSpConfFile exception." + e.getMessage()));
            }
            finally {
                try {
                    if (null != fin) {
                        fin.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"readSpConfFile close FileInputStream error.");
                }
            }
            SpTypeConfig.setReadOver(true);
        }
    }

    public static int getSpType() {
        return spType;
    }

    public static void setSpType(int spType) {
        SpTypeConfig.spType = spType;
    }

    public static boolean isReadOver() {
        return readOver;
    }

    public static void setReadOver(boolean flagReadOver) {
        readOver = flagReadOver;
    }

    static {
        readOver = false;
        config = new Properties();
    }
}

