/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import com.hs.atic.util.AnonymousContentUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.trap.NotifyTrapSender;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.EmailBean;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.nem.fault.sdk.model.NotifyPathSet;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.service.INotifySetService;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.AuthenticationFailedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MailSendService
extends MessageTaskManager
implements InitializingBean,
DisposableBean,
Runnable {
    private static final String EMAIL_CHARSET = "GB2312";
    private static final String FILE_PATH = "truststore.jre.path";
    private static final String FILE_PKEY = "truststore.jre.password";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static Thread sThread = null;
    private static boolean threadRun;
    private IMessageCenter messagecenter = null;
    private BlockingQueue<EmailBean> alertQueue = new LinkedBlockingQueue<EmailBean>();
    private NotifyTrapSender notifyTrapSender = null;
    private IRemoteNotifyServerService remoteNotifyServerService = null;
    private INotifySetService notifySetService = null;
    private ISysOptLog sysLogService = null;
    private I18nMrg i18nMgr = null;
    private final Object lock = new Object();

    public static Thread getsThread() {
        return sThread;
    }

    public static void setsThreadCp(Thread oneSThread) {
        sThread = oneSThread;
    }

    public void setsThread(Thread oneSThread) {
        MailSendService.setsThreadCp(oneSThread);
    }

    public void afterPropertiesSet() {
        this.setsThread(new Thread(this));
        sThread.setName("email send thread");
        sThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        this.setThreadRun(true);
        sThread.start();
        this.messagecenter.addSubscriberTo((MessageTaskManager)this);
    }

    public void destroy() {
        this.setThreadRun(false);
        this.setsThread(null);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(5007L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        Object obj;
        if (5007L == mu.getCmdcode() && (obj = mu.getObj()) instanceof EmailBean) {
            EmailBean emailBean = (EmailBean)obj;
            StringBuilder builder = new StringBuilder();
            builder.append("recvice email send request in system bundle:" + emailBean.getContent());
            builder.append(emailBean.getRandomId());
            LOGGER.info((Object)builder.toString());
            this.alertQueue.add(emailBean);
        }
    }

    @Override
    public void run() {
        while (threadRun) {
            this.processEmail();
        }
    }

    public void addToQueue(EmailBean emailBean) {
        if (null != emailBean) {
            this.alertQueue.add(emailBean);
        }
    }

    private void processEmail() {
        try {
            EmailBean emailBean = this.alertQueue.take();
            LOGGER.info((Object)"Sending the email......");
            this.sendEmail(emailBean);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("Thead of send email exception : " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmail(EmailBean emailBean) {
        Object object = this.lock;
        synchronized (object) {
            Thread.currentThread().setContextClassLoader(sThread.getContextClassLoader());
            String[] emailTo = emailBean.getEmailTo();
            if (emailTo == null || emailTo.length <= 0) {
                LOGGER.info((Object)"Email address is empty.");
                int[] errorCodes = new int[]{7};
                emailBean.setErrorCodes(errorCodes);
                return;
            }
            RemoteNotifyServer remoteNotifyServer = emailBean.getRemoteNotifyServer();
            if (null == remoteNotifyServer) {
                remoteNotifyServer = this.remoteNotifyServerService.getRemoteNotifyServer();
            }
            try {
                if (!emailBean.isLocalSend() && !emailBean.isNeedReturn() && this.isSendByUpper()) {
                    LOGGER.info((Object)"Sending the email by Upper.");
                    this.notifyTrapSender.notifyEmail(emailBean);
                    return;
                }
                this.sendEmail(emailBean, remoteNotifyServer);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Sending the email exception!" + e.getMessage()));
                return;
            }
        }
    }

    private boolean isSendByUpper() {
        NotifyPathSet notifyPathSet = this.notifySetService.getNotifyPathSet(1L);
        return null != notifyPathSet && notifyPathSet.getNotifyPath() == 1;
    }

    private void sendEmail(EmailBean emailBean, RemoteNotifyServer remoteNotifyServer) {
        int i;
        String[] emailTo = emailBean.getEmailTo();
        String title = emailBean.getTitle();
        String content = emailBean.getContent();
        boolean sendResult = false;
        int[] errorCodes = new int[emailTo.length];
        for (i = 0; i < errorCodes.length; ++i) {
            errorCodes[i] = -1;
        }
        emailBean.setErrorCodes(errorCodes);
        for (i = 0; i < emailTo.length; ++i) {
            String to = emailTo[i];
            SysOptLog oOptLog = new SysOptLog();
            int errorCode = this.sendEmail(remoteNotifyServer, title, content, to, emailBean.getAttachments());
            sendResult = this.processErrorCode(sendResult, oOptLog, errorCode);
            emailBean.setErrorCode(errorCode);
            errorCodes[i] = errorCode;
            emailBean.setErrorCodes(errorCodes);
            if (emailBean.getTitle().equals("test")) continue;
            this.writeOptLog(oOptLog, to, errorCode);
        }
        if (emailBean.isNeedReturn()) {
            if (sendResult) {
                emailBean.setSendResult(true);
            } else {
                emailBean.setSendResult(false);
            }
            LOGGER.info((Object)"Send email report in system.");
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(5018L);
            mu.setObj((Object)emailBean);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName("--");
            this.messagecenter.sendMessage(mu);
        }
    }

    private boolean processErrorCode(boolean sendResult, SysOptLog oOptLog, int errorCode) {
        switch (errorCode) {
            case 0: {
                sendResult = true;
                oOptLog.setResult(1);
                break;
            }
            case 1: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.fromincorrect");
                break;
            }
            case 2: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.contentincorrect");
                break;
            }
            case 3: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.toinvalid");
                break;
            }
            case 4: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.tosetfail");
                break;
            }
            case 5: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.connectfail");
                break;
            }
            case 6: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.sendtimeout");
                break;
            }
            case 7: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.validadrress");
                break;
            }
            default: {
                this.processOtherErrorCode(oOptLog, errorCode);
            }
        }
        return sendResult;
    }

    private void processOtherErrorCode(SysOptLog oOptLog, int errorCode) {
        switch (errorCode) {
            case 8: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.connectproxyfail");
                break;
            }
            case 9: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.addAttachfail");
                break;
            }
            case 10: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.emailfromnull");
                break;
            }
            case 11: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.serverisnull");
                break;
            }
            case 12: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.checkfail");
                break;
            }
            default: {
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.sendexception");
            }
        }
    }

    private void writeOptLog(SysOptLog oOptLog, String to, int errorCode) {
        String anonyMail = AnonymousContentUtil.getAnonymousMailContent((String)to);
        Date date = new Date();
        oOptLog.setDate(date);
        oOptLog.setTarget(anonyMail);
        oOptLog.setLevel(1);
        if (errorCode == 0) {
            oOptLog.setResult(1);
        } else {
            oOptLog.setResult(0);
        }
        oOptLog.setOperator("system");
        oOptLog.setModule("lego.dic.module.notify");
        oOptLog.setOperation("lego.lab.log.func.send.email");
        oOptLog.setTerminalIp("127.0.0.1");
        this.sysLogService.writeOptLog(oOptLog);
    }

    private int sendEmail(RemoteNotifyServer remoteNotifyServer, String title, String content, String to, String[] attachments) {
        int errorCode = -1;
        for (int count = 0; errorCode != 0 && count < 2; ++count) {
            try {
                errorCode = this.sendSingleEmail(remoteNotifyServer, title, content, to, attachments);
                continue;
            }
            catch (RuntimeException t) {
                errorCode = -1;
                this.writeExceptionLog(remoteNotifyServer, System.getProperties(), t);
            }
        }
        return errorCode;
    }

    private boolean isEmptyString(String str) {
        return null == str || "".equals(str);
    }

    private int sendSingleEmail(RemoteNotifyServer remoteNotifyServer, String title, String content, String to, String[] attachments) {
        int errorCode = 0;
        String emailFrom = remoteNotifyServer.getEmailFrom();
        if (this.isEmptyString(emailFrom)) {
            errorCode = 10;
            LOGGER.info((Object)"EmailFrom is no config.");
            return errorCode;
        }
        String server = remoteNotifyServer.getServer();
        if (this.isEmptyString(server)) {
            errorCode = 11;
            LOGGER.info((Object)"Email server is no config.");
            return errorCode;
        }
        MultiPartEmail email = new MultiPartEmail();
        email.setHostName(remoteNotifyServer.getServer());
        int port = 0;
        try {
            port = Integer.parseInt(remoteNotifyServer.getPort());
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage());
        }
        email.setSmtpPort(port);
        this.setEmailAuth(remoteNotifyServer, email);
        Properties props = null;
        try {
            email.setFrom(remoteNotifyServer.getEmailFrom());
        }
        catch (EmailException e) {
            errorCode = 1;
            this.writeExceptionLog(remoteNotifyServer, e);
            return errorCode;
        }
        email.setCharset(EMAIL_CHARSET);
        email.setSubject(title);
        try {
            email.setMsg(content);
        }
        catch (EmailException e) {
            errorCode = 2;
            this.writeExceptionLog(remoteNotifyServer, e);
            return errorCode;
        }
        email.setSocketConnectionTimeout(30000);
        email.setSocketTimeout(30000);
        ArrayList<InternetAddress> cList = new ArrayList<InternetAddress>();
        try {
            this.addEmail(cList, to);
        }
        catch (AddressException e1) {
            errorCode = 3;
            this.writeExceptionLog(remoteNotifyServer, e1);
            return errorCode;
        }
        try {
            email.setTo(cList);
        }
        catch (EmailException e) {
            errorCode = 4;
            this.writeExceptionLog(remoteNotifyServer, e);
            return errorCode;
        }
        try {
            this.setAttachments(attachments, email);
        }
        catch (EmailException e) {
            errorCode = 9;
            this.writeExceptionLog(remoteNotifyServer, e);
            return errorCode;
        }
        catch (UnsupportedEncodingException e) {
            errorCode = 9;
            this.writeExceptionLog(remoteNotifyServer, e);
            return errorCode;
        }
        props = System.getProperties();
        if (remoteNotifyServer.isIsProxyEnable()) {
            props.setProperty("proxySet", "true");
            props.setProperty("socksProxyHost", remoteNotifyServer.getProxyServer());
            props.setProperty("socksProxyPort", String.valueOf(remoteNotifyServer.getProxyPort()));
        } else {
            props.setProperty("proxySet", "false");
            props.setProperty("socksProxyHost", "");
            props.setProperty("socksProxyPort", "");
        }
        MailcapCommandMap mcMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mcMap.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mcMap.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mcMap.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mcMap.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mcMap.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mcMap);
        if (remoteNotifyServer.getTransMode() == 1) {
            email.setSslSmtpPort("465");
            email.setSSL(true);
            if (null != this.getSSLContext()) {
                SSLSocketFactory ssf = this.getSSLContext().getSocketFactory();
                try {
                    email.getMailSession().getProperties().put("mail.smtp.socketFactory", ssf);
                }
                catch (EmailException e) {
                    LOGGER.error((Object)("Set SSL Factory Failed!" + e.getMessage()));
                }
            }
        } else {
            email.setSSL(false);
        }
        try {
            email.send();
        }
        catch (EmailException e) {
            this.writeExceptionLog(remoteNotifyServer, props, e);
            errorCode = this.processEmailException(e);
            return errorCode;
        }
        to = AnonymousContentUtil.getAnonymousMailContent((String)to);
        props.setProperty("proxySet", "false");
        props.setProperty("socksProxyHost", "");
        props.setProperty("socksProxyPort", "");
        StringBuilder builder = new StringBuilder();
        builder.append("Sending the email to the following server success, mail server is: ");
        builder.append(remoteNotifyServer.getServer());
        builder.append(", port is:");
        builder.append(remoteNotifyServer.getPort());
        builder.append(",proxy server is:");
        builder.append(remoteNotifyServer.getProxyServer());
        builder.append(",proxy port is:");
        builder.append(remoteNotifyServer.getProxyPort());
        builder.append(",email to ");
        builder.append(to);
        LOGGER.info((Object)builder.toString());
        return errorCode;
    }

    private void setAttachments(String[] attachments, MultiPartEmail email) throws UnsupportedEncodingException, EmailException {
        if (null == attachments || attachments.length <= 0) {
            return;
        }
        for (String fileName : attachments) {
            if (null == fileName || "".equals(fileName)) continue;
            EmailAttachment attachment = new EmailAttachment();
            String name = fileName;
            int index = name.lastIndexOf("/");
            if (index >= 0) {
                name = name.substring(index + 1);
            } else {
                index = name.lastIndexOf("\\");
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
            }
            attachment.setName(MimeUtility.encodeText((String)name, (String)EMAIL_CHARSET, (String)"B"));
            attachment.setPath(fileName);
            attachment.setDisposition("attachment");
            email.attach(attachment);
        }
    }

    private int processEmailException(EmailException e) {
        int errorCode = -1;
        try {
            errorCode = e.getCause() instanceof AuthenticationFailedException ? 12 : (e.getCause().getMessage().indexOf("Read timed out") >= 0 ? 6 : (e.getCause().getMessage().indexOf("Can't connect to SOCKS proxy") >= 0 ? 8 : (e.getCause().getMessage().indexOf("Connection reset") >= 0 || e.getCause().getMessage().indexOf("Connection refused") >= 0 || e.getCause().getMessage().indexOf("Connection timed out") >= 0 || e.getCause().getMessage().indexOf("Unknown SMTP host") >= 0 || e.getCause().getMessage().indexOf("Could not connect to SMTP host") >= 0 ? 5 : (e.getCause().getMessage().indexOf("Invalid Addresses") >= 0 ? 7 : -1))));
        }
        catch (RuntimeException ex) {
            LOGGER.error((Object)("process email exception!" + e.getMessage()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("process email exception!" + e.getMessage()));
        }
        return errorCode;
    }

    private void setEmailAuth(RemoteNotifyServer remoteNotifyServer, MultiPartEmail email) {
        if (remoteNotifyServer.isIsValidateEnable()) {
            StringBuffer pvalue = DataProtectServiceConst.sdpDecryptLocalBuffer((String)remoteNotifyServer.getPassword());
            email.setAuthentication(remoteNotifyServer.getUserName(), pvalue == null ? "" : pvalue.toString());
        }
    }

    private void writeExceptionLog(RemoteNotifyServer remoteNotifyServer, Properties props, Throwable t) {
        if (null != props) {
            props.setProperty("proxySet", "false");
            props.setProperty("socksProxyHost", "");
            props.setProperty("socksProxyPort", "");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Sending the email to the following server failed, mail server is: ");
        builder.append(remoteNotifyServer.getServer());
        builder.append(", port is:");
        builder.append(remoteNotifyServer.getPort());
        builder.append(",proxy server is:");
        builder.append(remoteNotifyServer.getProxyServer());
        builder.append(",proxy port is:");
        builder.append(remoteNotifyServer.getProxyPort());
        LOGGER.error((Object)(builder.toString() + t.getMessage()));
    }

    private void writeExceptionLog(RemoteNotifyServer remoteNotifyServer, Throwable t) {
        StringBuilder builder = new StringBuilder();
        builder.append("Sending the email to the following server failed, mail server is: ");
        builder.append(remoteNotifyServer.getServer());
        builder.append(", port is:");
        builder.append(remoteNotifyServer.getPort());
        builder.append(",proxy server is:");
        builder.append(remoteNotifyServer.getProxyServer());
        builder.append(",proxy port is:");
        builder.append(remoteNotifyServer.getProxyPort());
        LOGGER.error((Object)builder.toString());
        LOGGER.error((Object)t.getMessage());
    }

    private void addEmail(List<InternetAddress> cList, String to) throws AddressException {
        InternetAddress internetAddress = new InternetAddress(to);
        cList.add(internetAddress);
    }

    public NotifyTrapSender getNotifyTrapSender() {
        return this.notifyTrapSender;
    }

    public void setNotifyTrapSender(NotifyTrapSender notifyTrapSender) {
        this.notifyTrapSender = notifyTrapSender;
    }

    public IMessageCenter getMessagecenter() {
        return this.messagecenter;
    }

    public void setMessagecenter(IMessageCenter messagecenter) {
        this.messagecenter = messagecenter;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }

    public IRemoteNotifyServerService getRemoteNotifyServerService() {
        return this.remoteNotifyServerService;
    }

    public void setRemoteNotifyServerService(IRemoteNotifyServerService remoteNotifyServerService) {
        this.remoteNotifyServerService = remoteNotifyServerService;
    }

    public static boolean isThreadRun() {
        return threadRun;
    }

    public static void setThreadRunPC(boolean onethreadRun) {
        threadRun = onethreadRun;
    }

    public void setThreadRun(boolean threadRun) {
        MailSendService.setThreadRunPC(threadRun);
    }

    /*
     * Exception decompiling
     */
    public SSLContext getSSLContext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"SysLogClient-closeStream");
            }
        }
    }

    public INotifySetService getNotifySetService() {
        return this.notifySetService;
    }

    public void setNotifySetService(INotifySetService notifySetService) {
        this.notifySetService = notifySetService;
    }

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }
}

