/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.send;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.send.SmsContentSplit;
import com.hs.lego.core.notify.trap.NotifyTrapSender;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sp.sdk.cache.SpTestCache;
import com.hs.lego.core.sp.sdk.model.SmsConfig;
import com.hs.lego.core.sp.sdk.service.IAticSmsService;
import com.hs.lego.core.sp.unicom.sdk.model.UnicomSpConfig;
import com.hs.lego.core.system.notify.sdk.model.SmsBean;
import com.hs.lego.nem.fault.sdk.model.NotifyPathSet;
import com.hs.lego.nem.fault.sdk.model.SmsServer;
import com.hs.lego.nem.fault.sdk.service.INotifySetService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SmsSendService
extends MessageTaskManager
implements InitializingBean,
DisposableBean,
Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private static Thread sThread = null;
    private static boolean threadRun;
    private IMessageCenter messagecenter = null;
    private BlockingQueue<SmsBean> alertQueue = new LinkedBlockingQueue<SmsBean>();
    private NotifyTrapSender notifyTrapSender = null;
    private INotifySetService notifySetService = null;
    private List<SmsBean> smsBeanList = new ArrayList<SmsBean>();

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(5009L);
        mrs[0].addMessageCode(5010L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        if (5009L == mu.getCmdcode()) {
            Object obj = mu.getObj();
            if (obj instanceof SmsBean) {
                SmsBean smsBean = (SmsBean)obj;
                this.alertQueue.add(smsBean);
                StringBuilder builder = new StringBuilder();
                builder.append(smsBean.getRandomId());
                LOGGER.info((Object)builder.toString());
            }
        } else if (5010L == mu.getCmdcode()) {
            try {
                Object obj = mu.getObj();
                if (obj instanceof SmsBean) {
                    SmsBean smsBean = (SmsBean)obj;
                    StringBuilder builder = new StringBuilder();
                    builder.append("recvice sms send report in fault:");
                    builder.append(smsBean.getRandomId());
                    builder.append(",result:");
                    builder.append(smsBean.isSendResult());
                    LOGGER.info((Object)builder.toString());
                    this.smsBeanList.add(smsBean);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("add smsBean exception in smsBeanList : " + e.getMessage()));
            }
        }
    }

    public void afterPropertiesSet() {
        this.setsThread(new Thread(this));
        sThread.setName("sms send thread");
        sThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        this.setThreadRun(true);
        sThread.start();
        this.messagecenter.addSubscriberTo((MessageTaskManager)this);
    }

    public void destroy() {
        this.setThreadRun(false);
        this.setsThread(null);
    }

    @Override
    public void run() {
        while (threadRun) {
            this.processSms();
        }
    }

    public void addToQueue(SmsBean smsBean) {
        if (null != smsBean) {
            this.alertQueue.add(smsBean);
        }
    }

    private void processSms() {
        SmsBean smsBean = null;
        try {
            smsBean = this.alertQueue.take();
            LOGGER.info((Object)"Sending the sms......");
            this.sendSms(smsBean);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("send sms exception!" + e.getMessage()));
        }
    }

    private boolean sendSms(SmsBean smsBean) {
        boolean addResult = false;
        try {
            if (!smsBean.isLocalSend() && !smsBean.isNeedReturn() && this.isSendByUpper()) {
                LOGGER.info((Object)("Sending the sms by Upper,sendMode:" + smsBean.getSmsMode()));
                this.notifyTrapSender.notifySms(smsBean);
                return true;
            }
            if (smsBean.getSmsMode() == 2) {
                addResult = this.sendSpSms(smsBean);
            } else if (smsBean.getSmsMode() == 1) {
                addResult = this.sendSpSms(smsBean);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"sendSms exception");
            addResult = false;
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("sendSms exception : " + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("sendSms exception : " + e.getMessage()));
        }
        if (!addResult && smsBean.isNeedReturn()) {
            smsBean.setSendResult(false);
            LOGGER.info((Object)"Send sms report in system.");
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(5010L);
            mu.setObj((Object)smsBean);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName("--");
            this.messagecenter.sendMessage(mu);
        }
        return true;
    }

    private boolean sendSpSms(SmsBean smsBean) throws IOException, InterruptedException {
        boolean addResult = false;
        IAticSmsService aticSmsService = (IAticSmsService)ServiceContext.getInstance().getService("aticSmsSgipServiceImpl", IAticSmsService.class);
        if (null == aticSmsService) {
            return false;
        }
        if (smsBean.getContent().equals("this is a test!")) {
            SpTestCache.getInstance().clearTimeOutTest();
            SpTestCache.getInstance().put(Long.valueOf(smsBean.getRandomId()), smsBean.getSmsConfig());
            aticSmsService.sendTestSms(smsBean.getPhoneTo(), smsBean.getContent(), smsBean.getRandomId());
            addResult = true;
        } else {
            List<String> contents = SmsContentSplit.getMsgListBy(smsBean.getContent());
            for (String content : contents) {
                aticSmsService.send(smsBean.getPhoneTo(), content);
            }
        }
        return addResult;
    }

    private boolean isSendByUpper() {
        if (null == this.notifySetService) {
            return false;
        }
        NotifyPathSet notifyPathSet = this.notifySetService.getNotifyPathSet(2L);
        return null != notifyPathSet && notifyPathSet.getNotifyPath() == 1;
    }

    public int testSendSms(SmsConfig smsConfig) {
        String testPhone = null;
        int smsMode = 0;
        if (smsConfig instanceof SmsServer) {
            SmsServer smsServer = (SmsServer)smsConfig;
            testPhone = smsServer.getTestModemPhone();
            if (smsServer.getSmsMode() == 1) {
                testPhone = smsServer.getTestSpPhone();
            }
            smsMode = smsServer.getSmsMode();
        } else if (smsConfig instanceof UnicomSpConfig) {
            UnicomSpConfig unicomSpConfig = (UnicomSpConfig)smsConfig;
            testPhone = unicomSpConfig.getTestPhone();
            smsMode = 1;
        }
        if (null == testPhone || "".equals(testPhone)) {
            return 23;
        }
        SmsBean smsBean = new SmsBean();
        smsBean.setPhoneTo(new String[]{testPhone});
        smsBean.setContent("this is a test!");
        if (smsMode == 2) {
            smsBean.setSmsMode(2);
        } else {
            smsBean.setSmsMode(1);
        }
        smsBean.setNeedReturn(true);
        smsBean.setSmsConfig(smsConfig);
        StringBuilder builder = new StringBuilder();
        builder.append("publish test sms:");
        builder.append(smsBean.getRandomId());
        LOGGER.info((Object)builder.toString());
        this.addToQueue(smsBean);
        for (int index = 0; index <= 60; ++index) {
            boolean runTag = false;
            int sendResult = 0;
            ArrayList<SmsBean> clearList = new ArrayList<SmsBean>();
            long currentTime = System.currentTimeMillis();
            for (SmsBean smsBeanTemp : this.smsBeanList) {
                if (smsBeanTemp.getRandomId() == smsBean.getRandomId()) {
                    sendResult = smsBeanTemp.getErrorCode();
                    runTag = true;
                    clearList.add(smsBeanTemp);
                    break;
                }
                if (smsBeanTemp.getRandomId() - currentTime <= 60000L) continue;
                clearList.add(smsBeanTemp);
            }
            this.clearSmsBeanList(clearList);
            if (runTag) {
                builder = new StringBuilder();
                builder.append("return send randonId:");
                builder.append(smsBean.getRandomId());
                builder.append(",result:");
                builder.append(sendResult);
                LOGGER.info((Object)builder.toString());
                return sendResult;
            }
            this.sleep(1);
        }
        builder = new StringBuilder();
        builder.append("wait sms report timeout,randonId:");
        builder.append(smsBean.getRandomId());
        LOGGER.info((Object)builder.toString());
        return 1000;
    }

    private void sleep(int second) {
        try {
            TimeUnit.SECONDS.sleep(second);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("sleep exception : " + e.getMessage()));
        }
    }

    private void clearSmsBeanList(List<SmsBean> clearList) {
        for (SmsBean smsBean : clearList) {
            this.smsBeanList.remove(smsBean);
        }
    }

    public IMessageCenter getMessagecenter() {
        return this.messagecenter;
    }

    public void setMessagecenter(IMessageCenter messagecenter) {
        this.messagecenter = messagecenter;
    }

    public NotifyTrapSender getNotifyTrapSender() {
        return this.notifyTrapSender;
    }

    public void setNotifyTrapSender(NotifyTrapSender notifyTrapSender) {
        this.notifyTrapSender = notifyTrapSender;
    }

    public static void setsThreadCp(Thread oneSThread) {
        sThread = oneSThread;
    }

    public void setsThread(Thread oneSThread) {
        SmsSendService.setsThreadCp(oneSThread);
    }

    public static void setThreadRunPC(boolean onethreadRun) {
        threadRun = onethreadRun;
    }

    public void setThreadRun(boolean threadRun) {
        SmsSendService.setThreadRunPC(threadRun);
    }

    public INotifySetService getNotifySetService() {
        return this.notifySetService;
    }

    public void setNotifySetService(INotifySetService notifySetService) {
        this.notifySetService = notifySetService;
    }
}

