/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.notify.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.notify.dao.IRemoteNotifyServerDAO;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.service.IEmailSendService;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;

public class RemoteNotifyServerServiceImpl
implements IRemoteNotifyServerService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SERVER);
    private IRemoteNotifyServerDAO remoteNotifyServerDAO;
    private IEmailSendService emailSendService;

    @Override
    public boolean modifyEmailServer(RemoteNotifyServer remoteNotifyServer) {
        return this.remoteNotifyServerDAO.modifyEmailServer(remoteNotifyServer);
    }

    @Override
    public RemoteNotifyServer getRemoteNotifyServer() {
        RemoteNotifyServer server = this.remoteNotifyServerDAO.getRemoteNotifyServer();
        return server;
    }

    @Override
    public int testSendEmail(RemoteNotifyServer remoteNotifyServer) {
        try {
            int[] result = this.emailSendService.sendEmail(remoteNotifyServer, "test", "this is a test!", new String[]{remoteNotifyServer.getTestEmail()});
            return result[0];
        }
        catch (Exception e) {
            LOGGER.error((Object)("test email exception." + e.getMessage()));
            return -1;
        }
    }

    public IRemoteNotifyServerDAO getRemoteNotifyServerDAO() {
        return this.remoteNotifyServerDAO;
    }

    public void setRemoteNotifyServerDAO(IRemoteNotifyServerDAO remoteNotifyServerDAO) {
        this.remoteNotifyServerDAO = remoteNotifyServerDAO;
    }

    public IEmailSendService getEmailSendService() {
        return this.emailSendService;
    }

    public void setEmailSendService(IEmailSendService emailSendService) {
        this.emailSendService = emailSendService;
    }
}

