/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.atic.notify.restful.model.RestfulConfigForm;
import com.hs.atic.notify.restful.service.RestfulService;
import com.hs.atic.sdk.res.service.ICertManagementParentService;
import com.hs.atic.util.AnonymousContentUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.notify.service.RemoteNotifyServerServiceImpl;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.sp.sdk.model.SmsConfig;
import com.hs.lego.core.sp.unicom.sdk.model.UnicomSpConfig;
import com.hs.lego.core.sp.unicom.sdk.service.IUnicomSmsService;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.service.SysOptLogImpl;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.model.SmsServer;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import com.hs.lego.nem.fault.sdk.service.ISmsServerService;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.restful.util.HttpsConnection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class NotifyServerAction
extends BaseAction {
    public static final int ERRORCODE = 570505;
    private static final long serialVersionUID = -3486866361439172707L;
    private static final int NAME_MAX_LENGTH = 64;
    private static final int NAME_MAX_LENGTH_2 = 255;
    private RemoteNotifyServer remoteNotifyServerPO = new RemoteNotifyServer();
    private SmsServer smsServerPO = new SmsServer();
    private List<LangPair> transModeList;
    private String transMode;
    private boolean unicom = false;
    private UnicomSpConfig uniPo = new UnicomSpConfig();
    private RestfulConfigForm restfulConfigForm = new RestfulConfigForm();
    private RestfulService restfulService;
    private ArrayList<LangPair> certList;
    private String result;
    private String url;

    public String getServer() {
        this.getServerInfo("INIT");
        return "success";
    }

    public String getEditServerInfo() {
        this.getServerInfo("EDIT");
        return "success";
    }

    private void getServerInfo(String operation) {
        IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)ServiceContext.getInstance().getService("remoteNotifyServerService", RemoteNotifyServerServiceImpl.class);
        this.remoteNotifyServerPO = remoteNotifyServerService.getRemoteNotifyServer();
        if (null == this.remoteNotifyServerPO.getProxyServer() || "".equals(this.remoteNotifyServerPO.getProxyServer())) {
            this.remoteNotifyServerPO.setProxyServer("");
        }
        if (null == this.remoteNotifyServerPO.getProxyPort() || "".equals(this.remoteNotifyServerPO.getProxyPort())) {
            this.remoteNotifyServerPO.setProxyPort("1080");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)operation, (CharSequence)"INIT")) {
            this.doAnonymization();
        }
        this.transModeList = new ArrayList<LangPair>();
        LangPair lp1 = new LangPair(String.valueOf(0), this.getText("lego.lab.ldap.transmode.0"));
        LangPair lp2 = new LangPair(String.valueOf(1), this.getText("lego.lab.ldap.transmode.1"));
        this.transModeList.add(lp2);
        this.transModeList.add(lp1);
        this.transMode = this.getText("lego.lab.ldap.transmode." + this.remoteNotifyServerPO.getTransMode());
        this.initSmsUnicomServerPara(operation);
    }

    private void doAnonymization() {
        String emailFrom = this.remoteNotifyServerPO.getEmailFrom();
        emailFrom = AnonymousContentUtil.getAnonymousMailContent((String)emailFrom);
        this.remoteNotifyServerPO.setEmailFrom(emailFrom);
        String testEmail = this.remoteNotifyServerPO.getTestEmail();
        testEmail = AnonymousContentUtil.getAnonymousMailContent((String)testEmail);
        this.remoteNotifyServerPO.setTestEmail(testEmail);
    }

    public void testEmailService(IRemoteNotifyServerService remoteNotifyServerService) {
        boolean eable = this.remoteNotifyServerPO.isIsValidateEnable();
        StringBuffer sb = null;
        if (null != this.remoteNotifyServerPO.getPassword() && !this.remoteNotifyServerPO.getPassword().trim().equals("")) {
            sb = new StringBuffer(this.remoteNotifyServerPO.getPassword());
        }
        if (null != sb) {
            this.remoteNotifyServerPO.setPassword(DataProtectServiceConst.sdpEncryptLocal(sb));
        }
        if (eable && null == this.remoteNotifyServerPO.getPassword()) {
            RemoteNotifyServer temp = remoteNotifyServerService.getRemoteNotifyServer();
            this.remoteNotifyServerPO.setPassword(temp.getPassword());
        }
    }

    private void initSmsUnicomServerPara(String operation) {
        IUnicomSmsService smsService = null;
        try {
            smsService = (IUnicomSmsService)ServiceContext.getInstance().getService("unicomSmsService", IUnicomSmsService.class);
        }
        catch (Exception e) {
            this.unicom = true;
            return;
        }
        if (smsService != null) {
            this.uniPo = smsService.getUnicomSpConfig();
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"INIT", (CharSequence[])new CharSequence[]{operation})) {
                String testPhone = this.uniPo.getTestPhone();
                testPhone = AnonymousContentUtil.getAnonymousContent((String)testPhone);
                this.uniPo.setTestPhone(testPhone);
            }
        }
    }

    public void setSmsUnicomServer() {
        boolean isModifySuccess = false;
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        SysOptLog oOptLog = new SysOptLog();
        String pwd = this.uniPo.getLoginPassword();
        if (!"".equals(pwd) && null != pwd && pwd.length() > 16) {
            throw new LegoCheckedException(570505L);
        }
        IUnicomSmsService smsService = (IUnicomSmsService)ServiceContext.getInstance().getService("unicomSmsService", IUnicomSmsService.class);
        if (null == this.uniPo.getLoginPassword()) {
            UnicomSpConfig oldUniPo = smsService.getUnicomSpConfig();
            this.uniPo.setLoginPassword(oldUniPo.getLoginPassword());
        }
        isModifySuccess = smsService.modifyUnicomSpConfig(this.uniPo);
        String unicomIp = this.uniPo.getUnicomIp();
        if (!isModifySuccess) {
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            oOptLog.setDate(new Date());
            oOptLog.setTarget(unicomIp);
            oOptLog.setLevel(3);
            oOptLog.setOperator(currentUser.getUserName());
            oOptLog.setModule("lego.dic.module.system");
            oOptLog.setOperation("lego.lab.com.smsserverset");
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            oOptLog.setResult(0);
            sysOpLog.writeOptLog(oOptLog);
        } else {
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            oOptLog.setDate(new Date());
            oOptLog.setTarget(unicomIp);
            oOptLog.setLevel(3);
            oOptLog.setOperator(currentUser.getUserName());
            oOptLog.setModule("lego.dic.module.system");
            oOptLog.setOperation("lego.lab.com.smsserverset");
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            oOptLog.setDetail("lego.lab.com.modifiedsuccess");
            oOptLog.setResult(1);
            sysOpLog.writeOptLog(oOptLog);
        }
    }

    public int testSendSms(UnicomSpConfig unicomConfig) {
        ISmsServerService smsServerService = (ISmsServerService)ServiceContext.getInstance().getService("smsServerService", ISmsServerService.class);
        if (null == smsServerService) {
            return -1;
        }
        return smsServerService.testSendSms((SmsConfig)unicomConfig);
    }

    public void testConSmsUnicomServer() {
        IUnicomSmsService smsService = (IUnicomSmsService)ServiceContext.getInstance().getService("unicomSmsService", IUnicomSmsService.class);
        if (null == this.uniPo.getLoginPassword()) {
            UnicomSpConfig oldUniPo = smsService.getUnicomSpConfig();
            this.uniPo.setLoginPassword(oldUniPo.getLoginPassword());
        }
        int returnFlag = this.testSendSms(this.uniPo);
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        SysOptLog oOptLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        oOptLog.setDate(new Date());
        oOptLog.setTarget(this.uniPo.getUnicomIp());
        oOptLog.setLevel(3);
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.log.func.send.testsms");
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        boolean result = this.processTestResult1(returnFlag, oOptLog);
        if (!result) {
            result = this.processTestResult2(returnFlag, oOptLog);
        }
        if (!result) {
            this.processTestResult3(returnFlag, oOptLog);
        }
        sysOpLog.writeOptLog(oOptLog);
    }

    private boolean processTestResult1(int returnFlag, SysOptLog oOptLog) {
        boolean tag = true;
        switch (returnFlag) {
            case 0: {
                this.responseResult("success");
                oOptLog.setResult(1);
                break;
            }
            case -1: {
                this.responseResult(this.getText("lego.ver.fault.unicom.senderror"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.unicom.senderror");
                break;
            }
            case 101: {
                this.responseResult(this.getText("lego.ver.fault.unicom.connectfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.unicom.connectfail");
                break;
            }
            case 102: {
                this.responseResult(this.getText("lego.ver.fault.unicom.bindspfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.unicom.bindspfail");
                break;
            }
            case 103: {
                this.responseResult(this.getText("lego.ver.fault.unicom.sendsmsfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.unicom.sendsmsfail");
                break;
            }
            case 1000: {
                this.responseResult(this.getText("lego.ver.fault.sms.sendtimeout"));
                oOptLog.setDetail("lego.ver.fault.sms.sendtimeout");
                oOptLog.setResult(0);
                break;
            }
            default: {
                tag = false;
            }
        }
        return tag;
    }

    private boolean processTestResult2(int returnFlag, SysOptLog oOptLog) {
        boolean tag = true;
        switch (returnFlag) {
            case 1: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.1"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.1");
                oOptLog.setResult(0);
                break;
            }
            case 2: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.2"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.2");
                oOptLog.setResult(0);
                break;
            }
            case 3: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.3"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.3");
                oOptLog.setResult(0);
                break;
            }
            case 4: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.4"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.4");
                oOptLog.setResult(0);
                break;
            }
            case 5: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.5"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.5");
                oOptLog.setResult(0);
                break;
            }
            case 6: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.6"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.6");
                oOptLog.setResult(0);
                break;
            }
            case 7: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.7"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.7");
                oOptLog.setResult(0);
                break;
            }
            case 8: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.8"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.8");
                oOptLog.setResult(0);
                break;
            }
            case 9: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.9"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.9");
                oOptLog.setResult(0);
                break;
            }
            case 10: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.10"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.10");
                oOptLog.setResult(0);
                break;
            }
            case 11: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.11"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.11");
                oOptLog.setResult(0);
                break;
            }
            default: {
                tag = false;
            }
        }
        return tag;
    }

    private boolean processTestResult3(int returnFlag, SysOptLog oOptLog) {
        boolean tag = true;
        switch (returnFlag) {
            case 21: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.21"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.21");
                oOptLog.setResult(0);
                break;
            }
            case 22: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.22"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.22");
                oOptLog.setResult(0);
                break;
            }
            case 23: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.23"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.23");
                oOptLog.setResult(0);
                break;
            }
            case 24: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.24"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.24");
                oOptLog.setResult(0);
                break;
            }
            case 25: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.25"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.25");
                oOptLog.setResult(0);
                break;
            }
            case 26: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.26"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.26");
                oOptLog.setResult(0);
                break;
            }
            case 27: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.27"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.27");
                oOptLog.setResult(0);
                break;
            }
            case 28: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.28"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.28");
                oOptLog.setResult(0);
                break;
            }
            case 29: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.29"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.29");
                oOptLog.setResult(0);
                break;
            }
            case 30: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.30"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.30");
                oOptLog.setResult(0);
                break;
            }
            case 31: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.31"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.31");
                oOptLog.setResult(0);
                break;
            }
            case 32: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.32"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.32");
                oOptLog.setResult(0);
                break;
            }
            case 33: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.33"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.33");
                oOptLog.setResult(0);
                break;
            }
            default: {
                this.responseResult(this.getText("lego.ver.fault.unicom.error.100"));
                oOptLog.setDetail("lego.ver.fault.unicom.error.100");
                oOptLog.setResult(0);
            }
        }
        return tag;
    }

    public void testEmailServer() {
        IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)ServiceContext.getInstance().getService("remoteNotifyServerService", RemoteNotifyServerServiceImpl.class);
        this.testEmailService(remoteNotifyServerService);
        int errorCode = remoteNotifyServerService.testSendEmail(this.remoteNotifyServerPO);
        SysOptLog oOptLog = new SysOptLog();
        Date date = new Date();
        oOptLog.setDate(date);
        oOptLog.setTarget(this.remoteNotifyServerPO.getServer());
        oOptLog.setLevel(1);
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        String usrName = currentUser.getUserName();
        oOptLog.setOperator(usrName);
        oOptLog.setModule("lego.dic.module.notify");
        oOptLog.setOperation("lego.lab.log.func.send.testemail");
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        if (errorCode == 0) {
            oOptLog.setResult(1);
        } else {
            oOptLog.setResult(0);
        }
        switch (errorCode) {
            case 0: {
                this.responseResult("success");
                oOptLog.setResult(1);
                break;
            }
            case 1: {
                this.responseResult(this.getText("lego.ver.fault.email.fromincorrect"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.fromincorrect");
                break;
            }
            case 2: {
                this.responseResult(this.getText("lego.ver.fault.email.contentincorrect"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.contentincorrect");
                break;
            }
            case 3: {
                this.responseResult(this.getText("lego.ver.fault.email.toinvalid"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.toinvalid");
                break;
            }
            case 4: {
                this.responseResult(this.getText("lego.ver.fault.email.tosetfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.tosetfail");
                break;
            }
            case 5: {
                this.responseResult(this.getText("lego.ver.fault.email.connectfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.connectfail");
                break;
            }
            case 6: {
                this.responseResult(this.getText("lego.ver.fault.email.sendtimeout"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.sendtimeout");
                break;
            }
            case 7: {
                this.responseResult(this.getText("lego.ver.fault.email.validadrress"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.validadrress");
                break;
            }
            case 8: {
                this.responseResult(this.getText("lego.ver.fault.email.connectproxyfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.connectproxyfail");
                break;
            }
            case 12: {
                this.responseResult(this.getText("lego.ver.fault.email.checkfail"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.checkfail");
                break;
            }
            default: {
                this.responseResult(this.getText("lego.ver.fault.email.sendexception"));
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.ver.fault.email.sendexception");
            }
        }
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        sysOpLog.writeOptLog(oOptLog);
    }

    public void setEmailServer() {
        try {
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
            SysOptLog oOptLog = new SysOptLog();
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            Date date = new Date();
            oOptLog.setDate(date);
            oOptLog.setResult(1);
            oOptLog.setTarget("lego.lab.com.emailserver");
            oOptLog.setLevel(3);
            oOptLog.setOperator(currentUser.getUserName());
            oOptLog.setModule("lego.dic.module.system");
            oOptLog.setOperation("lego.lab.log.func.modifyemailsrv");
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            oOptLog.setTargetLocal(Boolean.valueOf(true));
            oOptLog.setDetail("lego.dic.operationstatus.success");
            IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)ServiceContext.getInstance().getService("remoteNotifyServerService", RemoteNotifyServerServiceImpl.class);
            boolean eable = this.remoteNotifyServerPO.isIsValidateEnable();
            StringBuffer sb = null;
            if (null != this.remoteNotifyServerPO.getPassword() && !this.remoteNotifyServerPO.getPassword().trim().equals("")) {
                sb = new StringBuffer(this.remoteNotifyServerPO.getPassword());
            }
            if (null != sb) {
                this.remoteNotifyServerPO.setPassword(DataProtectServiceConst.sdpEncryptLocal(sb));
            }
            if (eable && null == this.remoteNotifyServerPO.getPassword()) {
                RemoteNotifyServer temp = remoteNotifyServerService.getRemoteNotifyServer();
                this.remoteNotifyServerPO.setPassword(temp.getPassword());
            }
            remoteNotifyServerService.modifyEmailServer(this.remoteNotifyServerPO);
            sysOpLog.writeOptLog(oOptLog);
        }
        catch (LegoCheckedException ex) {
            this.systemOpeLog("lego.lab.log.func.modifyemailsrv", "lego.dic.module.system", true, null, "lego.dic.operationstatus.failure", "lego.lab.com.emailserver", 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.systemOpeLog("lego.lab.log.func.modifyemailsrv", "lego.dic.module.system", true, null, "lego.dic.operationstatus.failure", "lego.lab.com.emailserver", 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
        catch (Exception ex) {
            this.systemOpeLog("lego.lab.log.func.modifyemailsrv", "lego.dic.module.system", true, null, "lego.dic.operationstatus.failure", "lego.lab.com.emailserver", 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void resetUnicomServer() {
        IUnicomSmsService smsService = (IUnicomSmsService)ServiceContext.getInstance().getService("unicomSmsService", IUnicomSmsService.class);
        if (null == this.uniPo.getLoginPassword()) {
            UnicomSpConfig oldUniPo = smsService.getUnicomSpConfig();
            this.uniPo.setLoginPassword(oldUniPo.getLoginPassword());
        }
        this.clearUnicomForm(this.uniPo);
        smsService.modifyUnicomSpConfig(this.uniPo);
        this.getOperateLog().normal("lego.lab.com.smsserverset", "lego.dic.module.system");
    }

    private void clearUnicomForm(UnicomSpConfig form) {
        form.setLocalIp("");
        form.setNodeId("");
        form.setUnicomIp("");
        form.setUnicomPort("");
        form.setLoginName("");
        form.setLoginPassword("");
        form.setServiceType("");
        form.setChargeNumber("");
        form.setCorpId("");
        form.setSpNumber("");
        form.setTestPhone("");
    }

    public boolean validateServerAuth() {
        String port = this.remoteNotifyServerPO.getPort();
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
            return false;
        }
        boolean eable = this.remoteNotifyServerPO.isIsValidateEnable();
        if (eable) {
            String user = this.remoteNotifyServerPO.getUserName();
            if (null == user || "".equals(user.trim()) || 64 < user.length()) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[\\w-.@]*$");
            Matcher matcher = pattern.matcher(user = Normalizer.normalize(user, Normalizer.Form.NFKC));
            if (!matcher.find()) {
                return false;
            }
            String pwd = this.remoteNotifyServerPO.getPassword();
            IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)ServiceContext.getInstance().getService("remoteNotifyServerService", RemoteNotifyServerServiceImpl.class);
            RemoteNotifyServer temp = remoteNotifyServerService.getRemoteNotifyServer();
            if (null == temp.getPassword()) {
                if (null == pwd || "".equals(pwd.trim()) || 64 < pwd.length()) {
                    return false;
                }
                pattern = Pattern.compile("^[a-zA-Z|0-9|=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+$");
                matcher = pattern.matcher(pwd = Normalizer.normalize(pwd, Normalizer.Form.NFKC));
                if (!matcher.find()) {
                    return false;
                }
            } else {
                if (null == pwd) {
                    return true;
                }
                if ("".equals(pwd.trim()) || 64 < pwd.length()) {
                    return false;
                }
                pattern = Pattern.compile("^[a-zA-Z|0-9|=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+$");
                matcher = pattern.matcher(pwd = Normalizer.normalize(pwd, Normalizer.Form.NFKC));
                if (!matcher.find()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateServerProxy() {
        if (null != this.remoteNotifyServerPO.getProxyServer() && !IPUtil.isIpv4((String)this.remoteNotifyServerPO.getProxyServer()) && !IPUtil.isIpv6((String)this.remoteNotifyServerPO.getProxyServer())) {
            return false;
        }
        boolean eable = this.remoteNotifyServerPO.isIsProxyEnable();
        if (eable) {
            String ip = this.remoteNotifyServerPO.getProxyServer();
            if (null == ip || "".equals(ip.trim()) || ip.length() > 15) {
                return false;
            }
            Pattern pattern = Pattern.compile("^(22[0-3]|2[0-1]\\d|1[0-1|3-9]\\d|12[0-6|8-9]|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[0-9]\\d|[0-9])$");
            Matcher matcher = pattern.matcher(ip = Normalizer.normalize(ip, Normalizer.Form.NFKC));
            if (!matcher.find()) {
                return false;
            }
            String port = this.remoteNotifyServerPO.getProxyPort();
            if (null == port || "".equals(port.trim())) {
                return false;
            }
            if (1 > Integer.parseInt(port) || 65535 < Integer.parseInt(port)) {
                return false;
            }
        }
        return true;
    }

    public boolean validatePassword() {
        if (null != this.restfulConfigForm) {
            String password = this.restfulConfigForm.getPassword();
            if (null == password || password.isEmpty()) {
                return true;
            }
            if (password.length() > 64) {
                return false;
            }
            if (password.contains(" ")) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[a-zA-Z|0-9|=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]*$");
            Matcher matcher = pattern.matcher(password);
            boolean isIlegal = matcher.find();
            if (!isIlegal) {
                return false;
            }
            pattern = Pattern.compile("[a-zA-Z]+");
            matcher = pattern.matcher(password);
            boolean enFlag = matcher.find();
            pattern = Pattern.compile("[0-9]+");
            matcher = pattern.matcher(password);
            boolean numFlag = matcher.find();
            pattern = Pattern.compile("[=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+");
            matcher = pattern.matcher(password);
            boolean strFlag = matcher.find();
            if (!(enFlag && numFlag && strFlag)) {
                return false;
            }
        }
        return true;
    }

    public boolean checkLocalIp() {
        if (!"".equals(this.uniPo.getLocalIp()) && null != this.uniPo.getLocalIp()) {
            return IPUtil.isIpv6((String)this.uniPo.getLocalIp()) || IPUtil.isIpv4((String)this.uniPo.getLocalIp());
        }
        return true;
    }

    public boolean checkUnicomIp() {
        if (!"".equals(this.uniPo.getUnicomIp()) && null != this.uniPo.getUnicomIp()) {
            return IPUtil.isIpv6((String)this.uniPo.getUnicomIp()) || IPUtil.isIpv4((String)this.uniPo.getUnicomIp());
        }
        return true;
    }

    public String showRestfulServer() {
        this.initCertList();
        List<RestfulConfigForm> list = this.restfulService.getRestfulConfig();
        if (list.isEmpty()) {
            this.restfulConfigForm = new RestfulConfigForm();
            return "success";
        }
        this.restfulConfigForm = list.get(0);
        int type = this.restfulConfigForm.getType();
        if (1 == type) {
            String typeString = this.getText("atic.server.restful.type.blackhole");
            this.restfulConfigForm.setTypeString(typeString);
        }
        return "success";
    }

    private void initCertList() {
        ICertManagementParentService certManagementService = (ICertManagementParentService)ServiceContext.getInstance().getService("certManagementService", ICertManagementParentService.class);
        this.certList = new ArrayList();
        this.certList.addAll(certManagementService.queryAllCertName());
    }

    public void saveRestfulConfig() {
        if (null == this.restfulConfigForm) {
            this.log.warn((Object)"restfulConfigForm is null");
            return;
        }
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        SysOptLog oOptLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        Date date = new Date();
        try {
            this.restfulService.saveRestfulConfig(this.restfulConfigForm);
            this.log.info((Object)("save restful config success. id: " + this.restfulConfigForm.getId() + ",type:" + this.restfulConfigForm.getType() + ",typeString:" + this.restfulConfigForm.getTypeString() + ",domainName:" + this.restfulConfigForm.getDomainName() + ",projectName:" + this.restfulConfigForm.getProjectName()));
            oOptLog.setDate(date);
            oOptLog.setResult(1);
            oOptLog.setTarget("atic.server.restful.type.blackhole");
            oOptLog.setLevel(3);
            oOptLog.setOperator(currentUser.getUserName());
            oOptLog.setModule("atic.server.restful");
            oOptLog.setOperation("lego.lab.com.restfulserverset");
            oOptLog.setTerminalIp(currentUser.getIpAdr());
            oOptLog.setTargetLocal(Boolean.valueOf(true));
            oOptLog.setDetail("lego.lab.com.modifiedsuccess");
            sysOpLog.writeOptLog(oOptLog);
        }
        catch (LegoCheckedException ex) {
            this.log.error((Object)"saveRestfulConfig error");
            this.systemOpeLog("lego.lab.com.restfulserverset", "atic.server.restful", true, null, null, "atic.server.restful.type.blackhole", 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.log.error((Object)"saveRestfulConfig error");
            this.systemOpeLog("lego.lab.com.restfulserverset", "atic.server.restful", true, null, null, "atic.server.restful.type.blackhole", 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"saveRestfulConfig error");
            this.systemOpeLog("lego.lab.com.restfulserverset", "atic.server.restful", true, null, null, "atic.server.restful.type.blackhole", 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void testRestfulCloudServer() {
        RestfulConfigForm temp;
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        List<RestfulConfigForm> list = this.restfulService.getRestfulConfig();
        RestfulConfigForm restfulConfigForm = temp = list.size() > 0 ? list.get(0) : null;
        if ("********".equals(this.restfulConfigForm.getPassword())) {
            if (list.size() == 0) {
                resultMap.put("resultCode", 400);
                this.responseResult(resultMap);
                return;
            }
            this.restfulConfigForm.setPassword(temp.getPassword());
        }
        String operation = "atic.server.restful.login.server";
        String detail = "atic.Certificate.Management.black.restfule.test.success";
        long resultCode = 0L;
        try {
            resultCode = this.restfulService.testRestfulCloudServer(this.restfulConfigForm);
        }
        catch (LegoCheckedException e) {
            this.log.error((Object)("testRestfulCloudServer LegoCheckedException error. " + e.getMessage()));
            operation = "atic.server.restful.login.server";
            detail = "lego.err." + e.getErrorCode();
            this.saveLog(false, operation, detail, this.restfulConfigForm.getCloudCertAlias());
            throw e;
        }
        catch (RuntimeException e) {
            this.log.error((Object)("testRestfulCloudServer RuntimeException error. " + e.getMessage()));
            detail = "atic.server.restful.login.test.error";
            this.saveLog(false, operation, detail, this.restfulConfigForm.getCloudCertAlias());
            resultMap.put("resultCode", 400);
            this.responseResult(resultMap);
            return;
        }
        if (resultCode < 200L || resultCode >= 300L) {
            this.log.error((Object)("testRestfulCloudServer test restful cloud server fail error. resultCode = " + resultCode));
            detail = "atic.server.restful.login.test.error";
            this.saveLog(false, operation, detail, this.restfulConfigForm.getCloudCertAlias());
            resultMap.put("resultCode", 400);
            this.responseResult(resultMap);
            return;
        }
        this.saveLog(true, operation, detail, this.restfulConfigForm.getCloudCertAlias());
        resultMap.put("resultCode", resultCode);
        this.responseResult(resultMap);
    }

    private void saveLog(boolean isSuccess, String operation, String detail, String cerAlias) {
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        SysOptLog oOptLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        oOptLog.setDate(new Date());
        oOptLog.setTarget(cerAlias);
        oOptLog.setModule("atic.server.restful");
        oOptLog.setOperation(operation);
        oOptLog.setDetail(detail);
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        oOptLog.setTargetLocal(Boolean.valueOf(false));
        oOptLog.setLevel(3);
        if (isSuccess) {
            oOptLog.setResult(1);
        } else {
            oOptLog.setResult(0);
        }
        sysOpLog.writeOptLog(oOptLog);
    }

    public String testRestfulBlackServer() {
        if (null == this.restfulConfigForm.getBlackCertAlias()) {
            this.result = "failedcommon";
            return "success";
        }
        String operation = "atic.server.restful.blackhole.server";
        String detail = "atic.Certificate.Management.black.restfule.test.success";
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.restfulConfigForm.getAttackUrl(), this.restfulConfigForm.getBlackCertAlias());
        }
        catch (LegoCheckedException e) {
            this.result = "certfailed";
            this.url = "attackurl";
            operation = "atic.server.restful.blackhole.server";
            detail = "atic.Certificate.Management.black.restfule.test.attackurl.failed";
            this.saveLog(false, operation, detail, this.restfulConfigForm.getBlackCertAlias());
            return "success";
        }
        try {
            HttpsConnection.getInstance().doHttpsRequest(this.restfulConfigForm.getReleaseUrl(), this.restfulConfigForm.getBlackCertAlias());
        }
        catch (LegoCheckedException e) {
            this.result = "certfailed";
            this.url = "releaseurl";
            operation = "atic.server.restful.config.attack";
            detail = "atic.Certificate.Management.black.restfule.test.releaseurl.failed";
            this.saveLog(false, operation, detail, this.restfulConfigForm.getBlackCertAlias());
            return "success";
        }
        this.saveLog(true, operation, detail, this.restfulConfigForm.getBlackCertAlias());
        this.result = "success";
        return "success";
    }

    public boolean validateNameAndPwd(RestfulConfigForm form) {
        String pwd;
        String paramUserName = form.getUserName();
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{|&]+$";
        if (null != paramUserName && !paramUserName.isEmpty()) {
            if (paramUserName.length() > 64) {
                return false;
            }
            if (!paramUserName.matches(regex)) {
                return false;
            }
        }
        return AticUtil.isNullForVpn((String)(pwd = form.getPassword())) || pwd.length() <= 64 && pwd.matches(regex);
    }

    public boolean validatePwd(String password) {
        return AticUtil.isNullForVpn((String)password) || password.length() <= 64 && AticUtil.validatePwd((String)password);
    }

    public boolean validateUnipoPwd(String password) {
        if (null != password) {
            if (password.isEmpty() || password.length() > 16) {
                return false;
            }
            if (password.contains(" ")) {
                return false;
            }
            Pattern pattern = Pattern.compile("^[a-zA-Z|0-9|=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]*$");
            Matcher matcher = pattern.matcher(password);
            boolean isIlegal = matcher.find();
            if (!isIlegal) {
                return false;
            }
            pattern = Pattern.compile("[a-zA-Z]+");
            matcher = pattern.matcher(password);
            boolean enFlag = matcher.find();
            pattern = Pattern.compile("[0-9]+");
            matcher = pattern.matcher(password);
            boolean numFlag = matcher.find();
            pattern = Pattern.compile("[=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+");
            matcher = pattern.matcher(password);
            boolean strFlag = matcher.find();
            if (!(enFlag && numFlag && strFlag)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateDomainAndProject(RestfulConfigForm form) {
        String projectName;
        String domainName = form.getDomainName();
        if (null != domainName && !domainName.isEmpty()) {
            if (domainName.length() > 255) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!domainName.matches(regex)) {
                return false;
            }
        }
        if (null != (projectName = form.getProjectName()) && !projectName.isEmpty()) {
            if (projectName.length() > 255) {
                return false;
            }
            String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
            if (!projectName.matches(regex)) {
                return false;
            }
        }
        return true;
    }

    public boolean validateUnicomPort() {
        String port = this.uniPo.getUnicomPort();
        if (null == port || "".equals(port.trim())) {
            return false;
        }
        return 1 <= Integer.parseInt(port) && 65535 >= Integer.parseInt(port);
    }

    public boolean validateBlackCertAlias(RestfulConfigForm form) {
        String blackCert = form.getBlackCertAlias();
        return AticUtil.isNull((String)blackCert) || this.validateCertName(blackCert);
    }

    public boolean validateCloudCertAlias(RestfulConfigForm form) {
        String cloudCert = form.getCloudCertAlias();
        return AticUtil.isNull((String)cloudCert) || this.validateCertName(cloudCert);
    }

    public boolean validateCertName(String certName) {
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(certName);
        if (!matcher.matches()) {
            return false;
        }
        return certName.length() > 0 && certName.length() <= 128;
    }

    public boolean validatePort() {
        try {
            int port;
            if (null != this.uniPo.getUnicomPort() && (port = Integer.parseInt(this.uniPo.getUnicomPort())) >= 1 && port <= 65535) {
                return true;
            }
            if (null != this.remoteNotifyServerPO.getPort() && (port = Integer.parseInt(this.remoteNotifyServerPO.getPort())) >= 1 && port <= 65535) {
                return true;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public RemoteNotifyServer getRemoteNotifyServerPO() {
        return this.remoteNotifyServerPO;
    }

    public void setRemoteNotifyServerPO(RemoteNotifyServer remoteNotifyServerPO) {
        this.remoteNotifyServerPO = remoteNotifyServerPO;
    }

    public List<LangPair> getTransModeList() {
        return this.transModeList;
    }

    public String getTransMode() {
        return this.transMode;
    }

    public boolean isUnicom() {
        return this.unicom;
    }

    public void setUnicom(boolean unicom) {
        this.unicom = unicom;
    }

    public UnicomSpConfig getUniPo() {
        return this.uniPo;
    }

    public void setUniPo(UnicomSpConfig uniPo) {
        this.uniPo = uniPo;
    }

    public SmsServer getSmsServerPO() {
        return this.smsServerPO;
    }

    public void setSmsServerPO(SmsServer smsServerPO) {
        this.smsServerPO = smsServerPO;
    }

    public RestfulConfigForm getRestfulConfigForm() {
        return this.restfulConfigForm;
    }

    public void setRestfulConfigForm(RestfulConfigForm restfulConfigForm) {
        this.restfulConfigForm = restfulConfigForm;
    }

    public RestfulService getRestfulService() {
        return this.restfulService;
    }

    public void setRestfulService(RestfulService restfulService) {
        this.restfulService = restfulService;
    }

    public ArrayList<LangPair> getCertList() {
        return this.certList;
    }

    public void setCertList(ArrayList<LangPair> certList) {
        this.certList = certList;
    }

    public String getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

