/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.huawei.secsyslog.ServerInfoObj;
import com.huawei.secsyslog.SyslogClientAbstrat;
import com.huawei.secsyslog.TCPSysLogClientThread;
import com.huawei.secsyslog.UDPSysLogClientThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class SysLogClient
extends Thread {
    protected static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_LOG);
    private SSLContext context = null;
    private List<String> serverList = new ArrayList<String>();
    private ConcurrentMap<String, List<byte[]>> sysLogList = new ConcurrentHashMap<String, List<byte[]>>();
    private ConcurrentMap<String, List<byte[]>> dataList = new ConcurrentHashMap<String, List<byte[]>>();
    private String keystorePath = null;
    private StringBuffer keystorePass = null;
    private String truststorePath = null;
    private StringBuffer truststorePass = null;
    private boolean flag = true;
    private Map<String, SyslogClientAbstrat> threadList = new HashMap<String, SyslogClientAbstrat>();

    public SysLogClient(String protocol, List<ServerInfoObj> serverLists, String truststorePath, String truststorePass) {
        if (null == serverLists || serverLists.isEmpty()) {
            LOGGER.error((Object)"SysLogClient-serverList is null or empty");
            return;
        }
        LOGGER.info((Object)("SysLogClient-enter SysLogClient(), protocol is " + protocol + ", serverList.size is " + this.serverList.size()));
        this.setName("SysLogClient");
        this.truststorePath = truststorePath;
        for (ServerInfoObj serverInfoObj : serverLists) {
            String ipPort = serverInfoObj.getIp() + "," + serverInfoObj.getPort();
            this.serverList.add(ipPort);
        }
        this.creatSyslogClientList(this.serverList);
    }

    /*
     * Exception decompiling
     */
    private SSLContext getSSLContext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void creatSyslogClientList(List<String> logServerList2) {
        String logProtocol = "udp";
        if (null != logServerList2 && !logServerList2.isEmpty()) {
            ISyslogSendService syslogSendService = (ISyslogSendService)ServiceContext.getInstance().getService("syslogSendService", ISyslogSendService.class);
            Map keysAndValuesMap = syslogSendService.getSyslogServerMapKeysAndValues();
            List keys = (List)keysAndValuesMap.get("keys");
            List values = (List)keysAndValuesMap.get("values");
            HashMap serverMap = new HashMap();
            if (null == keys || keys.size() == 0) {
                serverMap = null;
            } else {
                for (int i = 0; i < keys.size(); ++i) {
                    serverMap.put(keys.get(i), values.get(i));
                }
            }
            for (String serverIpPort : logServerList2) {
                String[] ipPort = serverIpPort.split(",");
                if (null != serverMap && !serverMap.isEmpty()) {
                    String string = logProtocol = 1 == ((SyslogServerEntity)serverMap.get(serverIpPort)).getTransferProtocol() ? "tcp" : "udp";
                }
                if ("tcp".equals(logProtocol)) {
                    if (null == this.getSSLContext()) {
                        LOGGER.error((Object)"SysLogClient-getSSLContext() is null, SysLogClient will exit!");
                        this.interrupt();
                        return;
                    }
                    ServerInfoObj serverInfo = new ServerInfoObj();
                    serverInfo.setIp(ipPort[0]);
                    serverInfo.setPort(Integer.parseInt(ipPort[1]));
                    SSLSocketFactory ssf = this.getSSLContext().getSocketFactory();
                    TCPSysLogClientThread syslogClientAbstrat = new TCPSysLogClientThread(ssf, serverInfo);
                    syslogClientAbstrat.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                    syslogClientAbstrat.start();
                    this.threadList.put(serverIpPort, (SyslogClientAbstrat)syslogClientAbstrat);
                    continue;
                }
                UDPSysLogClientThread syslogClientAbstrat = new UDPSysLogClientThread(ipPort[0], Integer.parseInt(ipPort[1]));
                syslogClientAbstrat.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                syslogClientAbstrat.start();
                this.threadList.put(serverIpPort, (SyslogClientAbstrat)syslogClientAbstrat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info((Object)"SysLogClient-enter run");
        try {
            while (this.flag) {
                if (!this.threadList.isEmpty() && !this.sysLogList.isEmpty()) {
                    LOGGER.info((Object)("syslogList.size() :" + this.sysLogList.size()));
                    for (Map.Entry<String, SyslogClientAbstrat> syslogClientEntry : this.threadList.entrySet()) {
                        String ipPort = syslogClientEntry.getKey();
                        this.fetchSysLogList(ipPort);
                        if (null == this.dataList.get(ipPort) || ((List)this.dataList.get(ipPort)).isEmpty()) continue;
                        syslogClientEntry.getValue().addSysLogList((List)this.dataList.get(ipPort));
                        this.dataList.remove(ipPort);
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("SysLogClient-run error!" + e.getMessage()));
                }
            }
        }
        finally {
            this.stopClient();
        }
    }

    public void stopClient() {
        this.stopAllThread();
        this.flag = false;
        if (null != this.context) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllThread() {
        if (!this.threadList.isEmpty()) {
            Map<String, SyslogClientAbstrat> map = this.threadList;
            synchronized (map) {
                for (Map.Entry<String, SyslogClientAbstrat> threadMap : this.threadList.entrySet()) {
                    threadMap.getValue().stopClient();
                }
            }
        }
    }

    public void stopThread(String keyIpPort) {
        if (null != this.threadList.get(keyIpPort)) {
            this.threadList.get(keyIpPort).stopClient();
        }
    }

    public void addSysLogList(String keyIpPort, List<byte[]> data) {
        if (!data.isEmpty()) {
            if (null == this.sysLogList.get(keyIpPort)) {
                this.sysLogList.put(keyIpPort, data);
            } else {
                ((List)this.sysLogList.get(keyIpPort)).addAll(data);
            }
        }
    }

    private void fetchSysLogList(String keyIpPort) {
        if (null != this.sysLogList.get(keyIpPort) && !((List)this.sysLogList.get(keyIpPort)).isEmpty()) {
            if (null == this.dataList.get(keyIpPort)) {
                this.dataList.put(keyIpPort, (List<byte[]>)this.sysLogList.get(keyIpPort));
            } else {
                ((List)this.dataList.get(keyIpPort)).addAll((Collection)this.sysLogList.get(keyIpPort));
            }
            this.sysLogList.remove(keyIpPort);
        }
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePass(StringBuffer keystorePass) {
        this.keystorePass = keystorePass;
    }

    private static void closeStream(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"SysLogClient-closeStream");
            }
        }
    }

    public Map<String, Object> getThreadListKeysAndValues() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<SyslogClientAbstrat> values = new ArrayList<SyslogClientAbstrat>();
        for (Map.Entry<String, SyslogClientAbstrat> serverMap : this.threadList.entrySet()) {
            keys.add(serverMap.getKey());
            values.add(serverMap.getValue());
        }
        resultMap.put("keys", keys);
        resultMap.put("values", values);
        return resultMap;
    }
}

