/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.permission.dao;

import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.SessionFactoryUtils;

public class PermissionDao
extends CommonDaoImpl {
    public List<Long> getUserOperationId(String userName) {
        String sql = "SELECT operation.opt_id FROM t_user AS user LEFT JOIN t_user_r_role AS role ON user.user_id = role.user_id LEFT JOIN t_operation_r_role AS operation ON role.role_id = operation.role_id WHERE user.user_name = ?0";
        Session session = null;
        boolean isNew = false;
        NativeQuery query = null;
        ArrayList<Long> operationIds = new ArrayList<Long>();
        try {
            session = this.getSessionFactory().getCurrentSession();
        }
        catch (HibernateException ex) {
            this.logger.info((Object)"Could not retrieve pre-bound Hibernate session");
        }
        if (session == null) {
            session = this.getSessionFactory().openSession();
            session.setFlushMode(FlushMode.MANUAL);
            isNew = true;
        }
        query = session.createSQLQuery(sql);
        query.setString(0, userName);
        query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List results = query.list();
        Object optId = null;
        for (Map result : results) {
            optId = result.get("opt_id");
            if (null == optId) continue;
            Long operationId = ((BigInteger)optId).longValue();
            operationIds.add(operationId);
        }
        if (isNew) {
            SessionFactoryUtils.closeSession((Session)session);
        }
        return operationIds;
    }
}

