/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.res.service.impl;

import com.hs.lego.core.sdk.util.EncryptData;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DhcpPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger LOGGER = Logger.getLogger(DhcpPropertyPlaceholderConfigurer.class);
    private static final String PD_PROPERTY_KEY = "jdbc.pwd";
    private static final String USRNAME_PROPERTY_KEY = "jdbc.username";
    private static final String URL_PROPERTY_KEY = "jdbc.url";
    private static final String URL_TIME_ZONE_HOLDER_KEY = "timeZone";
    private static final String DRIVERCLASS_KEY = "jdbc.driverClass";
    private static final String MAXIDLETIME_KEY = "c3p0.maxIdleTime";
    private static final String IDLECONNECTION_KEY = "c3p0.idleConnectionTestPeriod";
    private static final String AUTOTESTTABLE = "jdbc.autotesttable";
    private static final String TESTONCHECKIN = "jdbc.testoncheckin";
    private static final String URL_TIME_ZONE_UTC = "UTC";
    private static final int NUMBER_TOW = 2;

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) {
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "jdbc.properties";
        try (FileInputStream fis = new FileInputStream(currentPath);){
            Properties dbConfig = new Properties();
            dbConfig.load(fis);
            String enCode = dbConfig.getProperty(PD_PROPERTY_KEY);
            String userName = dbConfig.getProperty(USRNAME_PROPERTY_KEY);
            String jdbcUrl = dbConfig.getProperty(URL_PROPERTY_KEY);
            props.setProperty(DRIVERCLASS_KEY, dbConfig.getProperty(DRIVERCLASS_KEY));
            props.setProperty(MAXIDLETIME_KEY, dbConfig.getProperty(MAXIDLETIME_KEY));
            props.setProperty(IDLECONNECTION_KEY, dbConfig.getProperty(IDLECONNECTION_KEY));
            props.setProperty(AUTOTESTTABLE, dbConfig.getProperty(AUTOTESTTABLE));
            props.setProperty(TESTONCHECKIN, dbConfig.getProperty(TESTONCHECKIN));
            String code = EncryptData.getInstanse().decryptdata(enCode);
            if (code == null) {
                code = EncryptData.getInstanse().decryptInitdata(enCode);
            }
            if (null == code || code.trim().isEmpty()) {
                LOGGER.error((Object)"decrype h.c.p for cis dbcp occurs error, code is null.");
            } else {
                props.setProperty(PD_PROPERTY_KEY, code);
                props.setProperty(USRNAME_PROPERTY_KEY, userName);
            }
            if (null != jdbcUrl) {
                jdbcUrl = jdbcUrl.contains(URL_TIME_ZONE_HOLDER_KEY) ? jdbcUrl : jdbcUrl + "&useSSL=false&serverTimezone=${timeZone}";
                jdbcUrl = DhcpPropertyPlaceholderConfigurer.replaceWithObject(jdbcUrl, URL_TIME_ZONE_HOLDER_KEY, DhcpPropertyPlaceholderConfigurer.curTimeZone());
                props.setProperty(URL_PROPERTY_KEY, jdbcUrl);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Get shared properties IOerror." + e.getMessage()));
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Get shared properties error." + e.getMessage()));
        }
        super.processProperties(beanFactoryToProcess, props);
    }

    private static String replaceWithObject(String sourceString, String holderName, String value) {
        String targetString = sourceString;
        Matcher matcher = Pattern.compile("\\$\\{(.*?)\\}").matcher(sourceString);
        while (matcher.find()) {
            String key = matcher.group();
            String curholderName = key.substring(2, key.length() - 1).trim();
            try {
                if (!curholderName.trim().equals(holderName)) continue;
                targetString = targetString.replace(key, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("String formatter failed", e);
            }
        }
        return targetString;
    }

    private static String curTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        LOGGER.info((Object)("curTimeZone : " + timeZone.getID()));
        LOGGER.info((Object)timeZone.getDisplayName());
        try {
            return URLEncoder.encode(timeZone.getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URL_TIME_ZONE_UTC;
        }
    }
}

