/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class ClientSocketFactory
extends SslRMIClientSocketFactory {
    private static final long serialVersionUID = -2275404716409167116L;
    private int timeOutPeriod = 1000;
    private boolean rmiSsl = false;

    public ClientSocketFactory(boolean rmiSsl, int timeOut) {
        this.rmiSsl = rmiSsl;
        this.timeOutPeriod = timeOut;
    }

    public ClientSocketFactory(int timeOut) {
        this.timeOutPeriod = timeOut;
    }

    public ClientSocketFactory(boolean rmiSsl) {
        this.rmiSsl = rmiSsl;
    }

    public ClientSocketFactory() {
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = null;
        try {
            if (this.rmiSsl) {
                socket = super.createSocket(host, port);
                if (socket instanceof SSLSocket) {
                    ((SSLSocket)socket).setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"});
                    ((SSLSocket)socket).setEnabledProtocols(new String[]{"TLSv1.2"});
                }
            } else {
                socket = new Socket();
                socket.setSoTimeout(this.timeOutPeriod);
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                socket.connect(socketAddress, this.timeOutPeriod);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        return socket;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rmiSsl ? 1231 : 1237);
        result = 31 * result + this.timeOutPeriod;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClientSocketFactory)) {
            return false;
        }
        ClientSocketFactory other = (ClientSocketFactory)obj;
        if (this.rmiSsl != other.rmiSsl) {
            return false;
        }
        return this.timeOutPeriod == other.timeOutPeriod;
    }
}

