/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FileUtils {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public static byte[] copyFileDeleteSrc(String orginalFilePath) throws IOException {
        byte[] byArray;
        RandomAccessFile randomAccessFile = null;
        ByteArrayOutputStream baos = null;
        File orginalFile = null;
        try {
            orginalFile = new File(orginalFilePath);
            if (!orginalFile.isFile() || !orginalFile.exists()) {
                logger.error((Object)"FileUtils error copyFileDeleteSrc orginalFile not exists!");
                throw new IOException("FileUtils error copyFileDeleteSrc");
            }
            randomAccessFile = new RandomAccessFile(orginalFile, "rw");
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            int length = 0;
            while ((length = randomAccessFile.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] tmpFileBytes = baos.toByteArray();
            byte[] tmpFileBytesClone = new byte[tmpFileBytes.length];
            System.arraycopy(tmpFileBytes, 0, tmpFileBytesClone, 0, tmpFileBytes.length);
            baos.flush();
            byArray = tmpFileBytesClone;
        }
        catch (IOException e) {
            try {
                logger.error((Object)"FileUtils error copyFileDeleteSrc");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(randomAccessFile, baos);
                FileUtils.delSourceFile(orginalFile);
                throw throwable;
            }
        }
        FileUtils.closeStream(randomAccessFile, baos);
        FileUtils.delSourceFile(orginalFile);
        return byArray;
    }

    private static void delSourceFile(File orginalFile) {
        if (null != orginalFile && orginalFile.exists()) {
            boolean flagFolder;
            File folder;
            boolean flag = orginalFile.delete();
            if (!flag) {
                logger.error((Object)"FileUtils error copyFileDeleteSrc delete failed!");
            }
            if ((folder = orginalFile.getParentFile()) != null && folder.isDirectory() && !(flagFolder = folder.delete())) {
                logger.error((Object)"FileUtils error copyFileDeleteSrc delete folder failed!");
            }
        }
    }

    private static void closeStream(RandomAccessFile randomAccessFile, ByteArrayOutputStream baos) {
        try {
            if (null != baos) {
                baos.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"FileUtils error colse error1");
        }
        try {
            if (null != randomAccessFile) {
                randomAccessFile.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"FileUtils error colse error2");
        }
    }

    public static byte[] copyFileBytes(String orginalFilePath) throws IOException {
        byte[] byArray;
        RandomAccessFile randomAccessFile = null;
        ByteArrayOutputStream baos = null;
        File orginalFile = null;
        try {
            orginalFile = new File(orginalFilePath);
            if (!orginalFile.isFile() || !orginalFile.exists()) {
                logger.error((Object)"FileUtils error copyFileDeleteSrc orginalFile not exists!");
                throw new IOException("FileUtils error copyFileDeleteSrc");
            }
            randomAccessFile = new RandomAccessFile(orginalFile, "rw");
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[0x100000];
            int length = 0;
            while ((length = randomAccessFile.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] tmpFileBytes = baos.toByteArray();
            byte[] tmpFileBytesClone = new byte[tmpFileBytes.length];
            System.arraycopy(tmpFileBytes, 0, tmpFileBytesClone, 0, tmpFileBytes.length);
            baos.flush();
            byArray = tmpFileBytesClone;
        }
        catch (IOException e) {
            try {
                logger.error((Object)"FileUtils error copyFileDeleteSrc");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(randomAccessFile, baos);
                throw throwable;
            }
        }
        FileUtils.closeStream(randomAccessFile, baos);
        return byArray;
    }

    public static void deleteDirectory(File file, File exceptFile) throws IOException {
        if (null == file || !file.exists()) {
            return;
        }
        if (null != exceptFile && exceptFile.getCanonicalPath().equals(file.getCanonicalPath())) {
            return;
        }
        if (file.isFile()) {
            boolean isFileDel = file.delete();
            if (!isFileDel) {
                logger.error((Object)"files[i] delete failed!");
            }
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (null == files) {
                return;
            }
            for (File each : files) {
                FileUtils.deleteDirectory(each, exceptFile);
            }
        }
        FileUtils.deletEmptyFolders(file);
    }

    public static void deletEmptyFolders(File file) {
        if (null == file) {
            return;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            if (null != children && children.length == 0) {
                if (!file.delete()) {
                    logger.error((Object)"deletEmptyFolders delete folder failed!");
                }
                return;
            }
            if (null != children) {
                for (String each : children) {
                    File f = null;
                    try {
                        f = new File(file.getCanonicalPath() + File.separator + each);
                    }
                    catch (IOException e) {
                        logger.error((Object)"file.getCanonicalPath() error!");
                    }
                    FileUtils.deletEmptyFolders(f);
                }
            }
            FileUtils.delCurrentDir(file);
        }
    }

    private static void delCurrentDir(File file) {
        if (null == file || !file.exists()) {
            return;
        }
        String[] children = file.list();
        if (null == children) {
            return;
        }
        if (children.length > 0) {
            return;
        }
        if (!file.delete()) {
            logger.error((Object)"deletEmptyFolders delete current folder failed!");
        }
    }

    public static void close(InputStream input, ByteArrayOutputStream barrayOut, ByteArrayInputStream barrayInput) {
        try {
            if (null != barrayInput) {
                barrayInput.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("barrayInput close error " + e.getMessage()));
        }
        try {
            if (null != barrayOut) {
                barrayOut.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("barrayOut close error " + e.getMessage()));
        }
        try {
            if (null != input) {
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("input close error " + e.getMessage()));
        }
    }
}

