/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static boolean resize(InputStream inputStream, String fileName, String uploadDir) throws IOException {
        if (null != inputStream) {
            BufferedImage src = ImageIO.read(inputStream);
            if (null == src) {
                return false;
            }
            int oldWidth = src.getWidth();
            int oldHeight = src.getHeight();
            BufferedImage newImg = null;
            switch (src.getType()) {
                case 13: {
                    newImg = new BufferedImage(oldWidth, oldHeight, 6);
                    break;
                }
                case 5: {
                    newImg = new BufferedImage(oldWidth, oldHeight, 5);
                    break;
                }
                default: {
                    newImg = new BufferedImage(oldWidth, oldHeight, 1);
                }
            }
            Graphics2D g = newImg.createGraphics();
            g.drawImage(src, 0, 0, oldWidth, oldHeight, null);
            g.dispose();
            newImg.getGraphics().drawImage(src.getScaledInstance(oldWidth, oldHeight, 4), 0, 0, null);
            File newFile = new File(uploadDir + fileName);
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH);
            ImageIO.write((RenderedImage)newImg, suffix, newFile);
            return true;
        }
        return false;
    }
}

