/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.ui.model.DiskResouceUse;
import com.hs.atic.util.ISystemTool;
import com.hs.atic.util.LinuxSystemTool;
import com.hs.atic.util.WindowsSystemTool;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.util.List;
import java.util.Locale;

public final class SystemToolFactory {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private static final Object LOCK = new Object();
    private static ISystemTool systemTool = null;
    private static final long GB = 0x40000000L;

    private SystemToolFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISystemTool getSystemTool() {
        Object object = LOCK;
        synchronized (object) {
            if (systemTool != null) {
                return systemTool;
            }
            String o = System.getProperty("os.name");
            if (null == o) {
                return null;
            }
            String os = o.toLowerCase(Locale.US);
            if (os.contains("win")) {
                try {
                    systemTool = new WindowsSystemTool();
                }
                catch (Exception e) {
                    LOGGER.info((Object)("init resource tool failed!" + e.getMessage()));
                }
                LOGGER.info((Object)"use windows system tool");
            }
            if (os.contains("linux")) {
                systemTool = new LinuxSystemTool();
                LOGGER.info((Object)"use linux system tool");
            }
            return systemTool;
        }
    }

    public static long getMinsize() {
        long min = 0x40000000L;
        ISystemTool iSystemTool = SystemToolFactory.getSystemTool();
        if (null == iSystemTool) {
            return min;
        }
        List<DiskResouceUse> diskInfo = iSystemTool.getDisk();
        String aticInstallPath = AticInstallUtil.getInstance().getAticInstallPath();
        boolean result = false;
        if (null != diskInfo && !diskInfo.isEmpty()) {
            for (DiskResouceUse info : diskInfo) {
                String diskName = info.getDiskName();
                if (!aticInstallPath.startsWith(diskName)) continue;
                String avail = info.getAvail();
                min = (long)Double.parseDouble(avail.replace("G", "").trim()) * 0x40000000L;
                result = true;
            }
        }
        if (!result) {
            LOGGER.error((Object)"getMinsize error.");
        }
        return min;
    }
}

