/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.ui.model.DiskResouceUse;
import com.hs.atic.util.ISystemTool;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public class WindowsSystemTool
implements ISystemTool {
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long GB = 0x40000000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private static final int MAX_STRING_SIZE = 10240;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private final Object lock = new Object();
    private String cmd = "";

    public WindowsSystemTool() {
        String property = System.getProperty("user.dir");
        String currentPath = new File(property).getParentFile().getParent();
        this.cmd = currentPath + File.separator + "tools" + File.separator + "resource.exe ";
    }

    @Override
    public double getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return percent;
    }

    @Override
    public long getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / 100.0;
        return (long)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getCPUAndMenInfo(String paraParam) {
        BufferedReader errorBr;
        BufferedReader br;
        block13: {
            long l;
            block12: {
                StringBuffer sb = new StringBuffer();
                String[] para = (this.cmd + paraParam).split("\\s+");
                ProcessBuilder pb = new ProcessBuilder(para);
                pb.redirectErrorStream(true);
                Process process = null;
                try {
                    process = pb.start();
                }
                catch (IOException e1) {
                    LOGGER.error((Object)"getCPUAndMenInfo error");
                }
                if (null == process) {
                    LOGGER.error((Object)"getCPUAndMenInfo init process object occurs error, then process is null.");
                    return 1L;
                }
                br = null;
                errorBr = null;
                try {
                    InputStreamReader ir = new InputStreamReader(process.getInputStream(), "utf-8");
                    br = new BufferedReader(ir);
                    LineIterator lin = new LineIterator((Reader)br);
                    String line = null;
                    while (lin.hasNext()) {
                        line = lin.nextLine();
                        LOGGER.info((Object)(line + "getCPUAndMenInfo"));
                        sb.append(line);
                        if (null == line || line.length() <= 0) continue;
                        sb.append(System.getProperty("line.separator"));
                    }
                    InputStreamReader errorIr = new InputStreamReader(process.getErrorStream(), "utf-8");
                    errorBr = new BufferedReader(errorIr);
                    String errorStr = null;
                    LineIterator errorLin = new LineIterator((Reader)errorBr);
                    StringBuilder errorBuffer = new StringBuilder();
                    while (errorLin.hasNext()) {
                        errorStr = errorLin.nextLine();
                        errorBuffer.append(errorStr);
                        if (errorBuffer.length() <= 0) continue;
                        errorBuffer.append("\n\r");
                    }
                    if (errorBuffer.length() > 0) {
                        LOGGER.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
                    }
                    if (sb.length() < 10240) {
                        int beginindex = sb.lastIndexOf(System.getProperty("line.separator"));
                        String value = null;
                        value = -1 == beginindex ? sb.toString() : sb.substring(beginindex);
                        l = Long.parseLong(value);
                        IOUtils.closeQuietly((Reader)br);
                        break block12;
                    }
                    IOUtils.closeQuietly((Reader)br);
                    break block13;
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"parse response getCPUAndMenInfo occurs error.");
                    return 1L;
                }
            }
            IOUtils.closeQuietly((Reader)errorBr);
            return l;
        }
        IOUtils.closeQuietly((Reader)errorBr);
        return 1L;
        finally {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(errorBr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskResouceUse> getDisk() {
        Object object = this.lock;
        synchronized (object) {
            File[] roots = File.listRoots();
            ArrayList<DiskResouceUse> list = new ArrayList<DiskResouceUse>();
            if (roots == null) {
                return list;
            }
            for (File file : roots) {
                DiskResouceUse disktemp = new DiskResouceUse();
                disktemp.setDiskName(file.getPath());
                double totalSpace = file.getTotalSpace();
                double usableSpace = file.getUsableSpace();
                if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace > 0.0)) continue;
                double total = MathUtil.getDoubleValue(totalSpace / 1.073741824E9);
                disktemp.setTotal(total + " G");
                double useableGB = MathUtil.getDoubleValue(usableSpace / 1.073741824E9);
                double used = MathUtil.getDoubleValue(total - useableGB);
                disktemp.setUsed(used + " G");
                disktemp.setUnit("GB");
                disktemp.setAvail(useableGB + " G");
                double percent = MathUtil.getDoubleValue((totalSpace - usableSpace) / totalSpace) * 100.0;
                disktemp.setPercent(percent + "%");
                list.add(disktemp);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getAllInfo(String paraParam) {
        BufferedReader errorBr;
        BufferedReader br;
        block13: {
            String[] stringArray;
            block12: {
                StringBuffer sb = new StringBuffer();
                String[] para = (this.cmd + paraParam).split("\\s+");
                ProcessBuilder pb = new ProcessBuilder(para);
                pb.redirectErrorStream(true);
                Process process = null;
                try {
                    process = pb.start();
                }
                catch (IOException e1) {
                    LOGGER.error((Object)"getAllInfo error");
                }
                if (null == process) {
                    LOGGER.error((Object)"getAllInfo init process object occurs error, then process is null.");
                    return new String[0];
                }
                br = null;
                errorBr = null;
                try {
                    InputStreamReader ir = new InputStreamReader(process.getInputStream(), "utf-8");
                    br = new BufferedReader(ir);
                    LineIterator lin = new LineIterator((Reader)br);
                    String line = null;
                    while (lin.hasNext()) {
                        line = lin.nextLine();
                        LOGGER.info((Object)(line + "getAllInfo"));
                        sb.append(line);
                        if (null == line || line.length() <= 0) continue;
                        sb.append(System.getProperty("line.separator"));
                    }
                    InputStreamReader errorIr = new InputStreamReader(process.getErrorStream(), "utf-8");
                    errorBr = new BufferedReader(errorIr);
                    String errorStr = "";
                    LineIterator errorLin = new LineIterator((Reader)errorBr);
                    StringBuffer errorBuffer = new StringBuffer();
                    while (errorLin.hasNext()) {
                        errorStr = errorLin.nextLine();
                        errorBuffer.append(errorStr);
                        if (!StringUtils.isNotEmpty((CharSequence)errorStr)) continue;
                        errorBuffer.append("\n\r");
                    }
                    if (errorBuffer.length() > 0) {
                        LOGGER.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
                    }
                    if (sb.length() < 10240) {
                        int beginindex = sb.lastIndexOf(System.getProperty("line.separator"));
                        String value = null;
                        value = -1 == beginindex ? sb.toString() : sb.substring(beginindex);
                        stringArray = value.split("-");
                        IOUtils.closeQuietly((Reader)br);
                        break block12;
                    }
                    IOUtils.closeQuietly((Reader)br);
                    break block13;
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"parse response getAllInfo occurs error.");
                    return new String[0];
                }
            }
            IOUtils.closeQuietly((Reader)errorBr);
            return stringArray;
        }
        IOUtils.closeQuietly((Reader)errorBr);
        return new String[0];
        finally {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(errorBr);
        }
    }
}

