/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public static void setSecureFeatureForSaxReader(SAXReader saxReader) throws SAXException {
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXException e) {
            logger.error((Object)("Faild to config secure feature for SaxReader: " + e.getMessage()));
            throw e;
        }
    }

    public static DocumentBuilder configureSecureInfoForDocumentBuilder(DocumentBuilderFactory documentBuilderFactory) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){
                ByteArrayInputStream bytes = new ByteArrayInputStream("".getBytes("UTF-8"));

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(this.bytes);
                }
            });
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)("Faild to config secure feature for SaxReader: " + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)("Failed to disable external entities: " + e.getMessage()));
        }
        return documentBuilder;
    }
}

