/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.dao.impl;

import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class TaskDAOImpl
extends HibernateDaoSupport
implements ITaskDAO {
    @Override
    public long addTask(Task task) {
        Long id = (Long)super.getHibernateTemplate().save((Object)task);
        return id;
    }

    @Override
    public void updateTask(Task task) {
        Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
        if (null == tempTask) {
            throw new LegoCheckedException(201L);
        }
        super.getHibernateTemplate().merge((Object)task);
    }

    @Override
    public void deleteTask(Task task) {
        Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
        if (null == tempTask) {
            throw new LegoCheckedException(201L);
        }
        super.getHibernateTemplate().delete((Object)task);
    }

    @Override
    public Task readTask(long taskId) {
        Task task = null;
        task = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)Long.valueOf(taskId));
        if (null == task) {
            throw new LegoCheckedException(201L);
        }
        return task;
    }

    @Override
    public List<Task> queryTask(Map<String, Object> condition) {
        ArrayList<Object> params = new ArrayList<Object>();
        String hql = this.getHqlByCondition(condition, params);
        return super.getHibernateTemplate().find(hql, params.toArray());
    }

    @Override
    public Paging findPage(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        ArrayList<Object> params = new ArrayList<Object>();
        String hql = this.getHqlByCondition(condition, params);
        FindPageHiberCallBack callBack = new FindPageHiberCallBack(hql, firstRowIndex, totalRow, params);
        List task = (List)this.getHibernateTemplate().execute((HibernateCallback)callBack);
        Paging rePaging = new Paging();
        rePaging.setData(task);
        long iCount = 0L;
        iCount = this.getCount(hql);
        rePaging.setCount((int)iCount);
        return rePaging;
    }

    private String getHqlByCondition(Map<String, Object> condition, List<Object> params) {
        StringBuilder hql = new StringBuilder("from Task t where t.taskId > 0 ");
        if (null == condition) {
            return hql.toString();
        }
        String orderKey = "";
        String oerder = "";
        int index = 0;
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("taskName".equalsIgnoreCase(key)) {
                params.add("%" + value.toString().trim() + "%");
                hql.append(" and t.taskName like ? " + index);
            } else if ("taskType".equalsIgnoreCase(key)) {
                params.add(value);
                hql.append(" and t.taskType.taskType = ?" + index);
            } else if ("taskLevel".equalsIgnoreCase(key)) {
                params.add(value);
                hql.append(" and t.taskLevel = ?" + index);
            } else if ("taskStatus".equalsIgnoreCase(key)) {
                params.add(value);
                hql.append(" and t.taskStatus = ?" + index);
            } else if ("executeType".equalsIgnoreCase(key)) {
                params.add(value);
                hql.append(" and t.executeType = ?" + index);
            } else if ("taskCategory".equalsIgnoreCase(key)) {
                params.add(value);
                hql.append(" and t.taskCategory = ?" + index);
            }
            if (this.checkParams(value.toString().trim(), key)) {
                oerder = key;
                orderKey = "order by " + value + " ";
            }
            ++index;
        }
        hql.append(orderKey);
        hql.append(oerder);
        return hql.toString();
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return null != name && null != type && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public long getCount(String hql) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) ");
        sBufTotle.append(hql);
        return this.getTotalCount(sBufTotle.toString());
    }

    private long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    @Override
    public Boolean nameIsExist(String taskName) {
        StringBuilder hql = new StringBuilder("from Task t where t.taskName =?0");
        List taskList = super.getHibernateTemplate().find(hql.toString(), new Object[]{taskName});
        if (null != taskList && !taskList.isEmpty()) {
            return true;
        }
        return false;
    }

    private static final class FindPageHiberCallBack
    implements HibernateCallback {
        private String hql;
        private int firstRowIndex;
        private int totalRow;
        private List<Object> param;

        public FindPageHiberCallBack(String hql, int firstRowIndex, int totalRow, List<Object> params) {
            this.hql = hql;
            this.firstRowIndex = firstRowIndex;
            this.totalRow = totalRow;
            this.param = params;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            if (this.param != null) {
                for (int i = 0; i < this.param.size(); ++i) {
                    q.setParameter(i, this.param.get(i));
                }
            }
            q.setFirstResult(this.firstRowIndex);
            q.setMaxResults(this.totalRow);
            return q.list();
        }
    }
}

