/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.dao.impl;

import com.hs.lego.cbb.task.dao.ITaskResultDAO;
import com.hs.lego.cbb.task.sdk.model.TaskResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class TaskResultDAOImpl
extends HibernateDaoSupport
implements ITaskResultDAO {
    @Override
    public List<TaskResult> queryTaskResult(long taskId) {
        StringBuilder hql = new StringBuilder("from TaskResult t where t.taskId = ?0");
        return super.getHibernateTemplate().find(hql.toString(), new Object[]{taskId});
    }

    @Override
    public Paging queryTaskResult(long taskId, int firstRowIndex, int totalRow) {
        StringBuilder hql = new StringBuilder("from TaskResult t where t.taskId = ");
        hql.append(taskId).append(" order by endTime desc");
        QueryTaskResultCallBack callBack = new QueryTaskResultCallBack(hql.toString(), firstRowIndex, totalRow);
        List task = (List)this.getHibernateTemplate().execute((HibernateCallback)callBack);
        Paging rePaging = new Paging();
        rePaging.setData(task);
        long iCount = this.getCount(hql.toString());
        rePaging.setCount((int)iCount);
        return rePaging;
    }

    @Override
    public long addTaskResult(TaskResult result) {
        Long id = (Long)super.getHibernateTemplate().save((Object)result);
        return id;
    }

    @Override
    public TaskResult readTaskResult(long resultId) {
        TaskResult result = (TaskResult)super.getHibernateTemplate().get(TaskResult.class, (Serializable)Long.valueOf(resultId));
        return result;
    }

    @Override
    public void deleteTaskResult(long taskResultId) {
        TaskResult result = (TaskResult)super.getHibernateTemplate().get(TaskResult.class, (Serializable)Long.valueOf(taskResultId));
        if (null != result) {
            try {
                result.getTaskId().getResults().remove(result);
                result.setTaskId(null);
                super.getHibernateTemplate().delete((Object)result);
            }
            catch (DataAccessException e) {
                this.logger.error((Object)("delete taskResult failed!" + e.getMessage()));
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("delete taskResult failed!" + e.getMessage()));
            }
        } else {
            throw new LegoCheckedException(201L);
        }
    }

    private long getCount(String hql) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) ");
        sBufTotle.append(hql);
        return this.getTotalCount(sBufTotle.toString());
    }

    private long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    private static final class QueryTaskResultCallBack
    implements HibernateCallback {
        private String hql;
        private int firstRowIndex;
        private int totalRow;

        public QueryTaskResultCallBack(String hql, int firstRowIndex, int totalRow) {
            this.hql = hql;
            this.firstRowIndex = firstRowIndex;
            this.totalRow = totalRow;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setFirstResult(this.firstRowIndex);
            q.setMaxResults(this.totalRow);
            return q.list();
        }
    }
}

