/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.manager.service;

import com.hs.lego.cbb.task.manager.service.ISchedulerService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import org.quartz.CronExpression;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class SchedulerServiceImpl
implements ISchedulerService {
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private Scheduler scheduler;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, null, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String name, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, name, null, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, Date endTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, endTime, cronExpression, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String name, Date startTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String nameParam, Date startTime, Date endTime, String cronExpression, JobDataMap map) {
        String name = nameParam;
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            this.scheduler.addJob((JobDetail)jobDetail, true);
            CronTriggerImpl cronTrigger = new CronTriggerImpl(name, "DEFAULT", jobDetail.getName(), "DEFAULT");
            cronTrigger.setJobDataMap(map);
            cronTrigger.setCronExpression(new CronExpression(cronExpression));
            if (null != startTime) {
                cronTrigger.setStartTime(startTime);
            }
            if (null != endTime) {
                cronTrigger.setEndTime(endTime);
            }
            this.scheduler.scheduleJob((Trigger)cronTrigger);
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.rescheduleJob(triggerKey, (Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            StringBuffer buff = new StringBuffer();
            buff.append("Task scheduler error! cronExpression = ");
            buff.append(cronExpression);
            buff.append(" starttime = ");
            buff.append(startTime);
            buff.append(" endtime = ");
            buff.append(endTime);
            this.log.error((Object)(buff.toString() + ". " + e.getMessage()));
        }
        catch (ParseException e) {
            this.log.error((Object)("CronExpression parse error! " + e.getMessage()));
        }
        return name;
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, JobDataMap map) {
        return this.schedule(jobDetail, startTime, null, 0, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String name, Date startTime, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, null, 0, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, Date endTime, JobDataMap map) {
        return this.schedule(jobDetail, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String name, Date startTime, Date endTime, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, Date endTime, int repeatCount, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String name, Date startTime, Date endTime, int repeatCount, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, endTime, 0, 0L, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, Date startTime, Date endTime, int repeatCount, long repeatInterval, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, endTime, repeatCount, repeatInterval, map);
    }

    @Override
    public String schedule(JobDetailImpl jobDetail, String nameParam, Date startTime, Date endTime, int repeatCount, long repeatInterval, JobDataMap map) {
        String name = nameParam;
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            this.scheduler.addJob((JobDetail)jobDetail, true);
            SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(name, "DEFAULT", jobDetail.getName(), "DEFAULT", startTime, endTime, repeatCount, repeatInterval);
            simpleTrigger.setJobDataMap(map);
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.rescheduleJob(triggerKey, (Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler error! repeatCount = " + repeatCount + " repeatInterval = " + repeatInterval + ". " + e.getMessage()));
        }
        return name;
    }

    @Override
    public void runAtOnce(String name, JobDataMap map) {
        try {
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            JobKey jobKey = new JobKey(triggerKey.getName(), "DEFAULT");
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                return;
            }
            String newName = UUID.randomUUID().toString();
            SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(newName, "DEFAULT", jobDetail.getDescription(), "DEFAULT", new Date(), null, 0, 0L);
            this.triggerTimerTask(simpleTrigger, map, newName);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task getJobDetail at once error! " + e.getMessage()));
        }
    }

    @Override
    public void runAtOnce(String name, JobDataMap map, String taskType) {
        String newName = UUID.randomUUID().toString();
        SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(newName, "DEFAULT", taskType, "DEFAULT", new Date(), null, 0, 0L);
        this.triggerTimerTask(simpleTrigger, map, newName);
    }

    private void triggerTimerTask(SimpleTriggerImpl simpleTrigger, JobDataMap map, String newName) {
        simpleTrigger.setJobDataMap(map);
        try {
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            TriggerKey triggerKey = new TriggerKey(newName, "DEFAULT");
            this.scheduler.rescheduleJob(triggerKey, (Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler run at once error! " + e.getMessage()));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public boolean stop(String name) {
        try {
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.pauseTrigger(triggerKey);
            return this.scheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler stop error! " + e.getMessage()));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void pause(String name) {
        try {
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.pauseTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler pause error! " + e.getMessage()));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void resume(String name) {
        try {
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.resumeTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler resume error! " + e.getMessage()));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        if (null != this.scheduler) {
            try {
                this.scheduler.shutdown(false);
            }
            catch (SchedulerException e) {
                this.log.error((Object)("Task scheduler shutdown error! " + e.getMessage()));
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
        }
    }
}

