/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.dao.ITaskResultDAO;
import com.hs.lego.cbb.task.dao.ITaskTypeDAO;
import com.hs.lego.cbb.task.manager.ITaskManager;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskResult;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.cbb.task.sdk.service.TaskStatus;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LogStorageUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class TaskServiceImpl
implements ITaskService {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int OPTTYPE = 1;
    private static final int EVENTTYPE = 2;
    private static final int TWO_HUNDRED_M = 246579200;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_DUMP);
    private ITaskDAO taskDao = null;
    private ITaskTypeDAO taskTypeDao = null;
    private ITaskResultDAO taskResultDao = null;
    private ITaskManager taskManager = null;

    @Override
    public long addTask(Task task) {
        long taskId = this.taskDao.addTask(task);
        this.taskManager.start(task);
        return taskId;
    }

    @Override
    public void startTask(Task task) {
        this.taskManager.start(task);
    }

    @Override
    public void startTask(List<Task> tasks) {
        if (null != tasks) {
            for (Task task : tasks) {
                this.startTask(task);
            }
        }
    }

    @Override
    public void updateTask(Task task) {
        if (task.getTaskStatus().intValue() != TaskStatus.idle.getValue() && task.getTaskStatus().intValue() != TaskStatus.finish.getValue()) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.stop(task);
        this.taskDao.updateTask(task);
        this.taskManager.start(task);
    }

    @Override
    public void deleteTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        if (task.getTaskStatus().intValue() != TaskStatus.idle.getValue() && task.getTaskStatus().intValue() != TaskStatus.finish.getValue()) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.stop(task);
        this.taskDao.deleteTask(task);
    }

    @Override
    public BatchOperationResult deleteTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at deleteTask, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at deleteTask, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at deleteTask, errorCode " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public Task readTask(long taskId) {
        return this.taskDao.readTask(taskId);
    }

    @Override
    public List<Task> queryTasks(Map<String, Object> condition) {
        return this.taskDao.queryTask(condition);
    }

    @Override
    public Paging queryTasks(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        return this.taskDao.findPage(condition, firstRowIndex, totalRow);
    }

    @Override
    public void runTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState(task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.idle) && !status.equals((Object)TaskStatus.finish)) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.runAtOnce(task);
    }

    @Override
    public BatchOperationResult runTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.runTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at runTask, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at runTask, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at runTask, errorCode " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public void suspendTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState(task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.idle)) {
            throw new LegoCheckedException(601L);
        }
        this.taskManager.pause(task);
        task.setTaskStatus(TaskStatus.suspend.getValue());
        this.taskDao.updateTask(task);
    }

    @Override
    public BatchOperationResult suspendTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.suspendTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at suspendTask, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at suspendTask, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at suspendTask, errorCode " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public void resumeTask(long taskId) {
        Task task = this.taskDao.readTask(taskId);
        TaskStatus status = TaskStatus.getTaskState(task.getTaskStatus());
        if (!status.equals((Object)TaskStatus.suspend)) {
            throw new LegoCheckedException(602L);
        }
        this.taskManager.resume(task);
        task.setTaskStatus(TaskStatus.idle.getValue());
        this.taskDao.updateTask(task);
    }

    @Override
    public BatchOperationResult resumeTask(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.resumeTask(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at resumeTask, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at resumeTask, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at resumeTask, " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public String addTaskType(TaskType type) {
        return this.taskTypeDao.addTaskType(type);
    }

    @Override
    public List<TaskType> queryTaskTypeList(int type) {
        return this.taskTypeDao.queryTaskType(type);
    }

    @Override
    public TaskType readTaskType(String taskType) {
        return this.taskTypeDao.readTaskType(taskType);
    }

    @Override
    public List<TaskResult> queryTaskResultList(long taskId) {
        return this.taskResultDao.queryTaskResult(taskId);
    }

    @Override
    public Paging queryTaskResultList(Long taskId, int firstRowIndex, int totalRow) {
        return this.taskResultDao.queryTaskResult(taskId, firstRowIndex, totalRow);
    }

    public void deleteTaskResult(long taskResultId) {
        this.taskResultDao.deleteTaskResult(taskResultId);
    }

    @Override
    public BatchOperationResult deleteTaskResultList(List<BatchOperation> list, int taskType) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteTaskResult(batchOperation.getTargetId());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at deleteTaskResultList, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at deleteTaskResultList, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at deleteTaskResultList, " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            try {
                Task logTask = this.readTask(1L);
                Task alarmtask = this.readTask(2L);
                block7: for (BatchOperation batchOperation : list) {
                    TaskResult taskResult;
                    Iterator<TaskResult> iterator;
                    if (1 == taskType) {
                        iterator = logTask.getResults().iterator();
                        while (iterator.hasNext()) {
                            taskResult = iterator.next();
                            if (taskResult.getResultId().longValue() != batchOperation.getTargetId()) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    if (2 != taskType) continue;
                    iterator = alarmtask.getResults().iterator();
                    while (iterator.hasNext()) {
                        taskResult = iterator.next();
                        if (taskResult.getResultId().longValue() != batchOperation.getTargetId()) continue;
                        iterator.remove();
                        continue block7;
                    }
                }
                this.updateTask(logTask);
                this.updateTask(alarmtask);
            }
            catch (RuntimeException e) {
                this.log.error((Object)("updateTask file fail!" + e.getMessage()));
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public long addTaskResult(TaskResult result) {
        return this.taskResultDao.addTaskResult(result);
    }

    @Override
    public TaskResult readTaskResult(long resultId) {
        return this.taskResultDao.readTaskResult(resultId);
    }

    public void setTaskTypeDao(ITaskTypeDAO taskTypeDao) {
        this.taskTypeDao = taskTypeDao;
    }

    public void setTaskResultDao(ITaskResultDAO taskResultDao) {
        this.taskResultDao = taskResultDao;
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public Boolean nameIsExist(String taskName) {
        return this.taskDao.nameIsExist(taskName);
    }

    private void deleteFile(int taskType, String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return;
        }
        try {
            File file = this.createFile(taskType, fileName);
            if (!file.exists()) {
                this.log.error((Object)"file path is error!");
                throw new LegoCheckedException(1291L);
            }
            file.deleteOnExit();
            if (!file.delete()) {
                this.log.error((Object)"del file fail");
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)"del file fail");
        }
    }

    @Override
    public BatchOperationResult deleteFile(int taskType, List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list && !list.isEmpty()) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.deleteFile(taskType, batchOperation.getTargetName());
                }
                catch (LegoCheckedException ce) {
                    this.log.error((Object)("exception at deleteFile, errorCode " + ce.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ce.getErrorCode());
                }
                catch (LegoUncheckedException ue) {
                    this.log.error((Object)("exception at deleteFile, errorCode " + ue.getErrorCode()));
                    ++fail;
                    batchOperation.setErrorCode(ue.getErrorCode());
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("exception at deleteFile, " + e.getMessage()));
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public Boolean checkFile(int taskType, String fileName) {
        File file = this.createFile(taskType, fileName);
        if (!file.exists()) {
            this.log.error((Object)"checkFile() file path is error file name!");
            return false;
        }
        if (!AticUtil.checkFileType(file, "504B0304")) {
            this.log.error((Object)"checkFile() file path is error file type!");
            return false;
        }
        return true;
    }

    @Override
    public Boolean checkFileSize(int taskType, String fileName) {
        File file = this.createFile(taskType, fileName);
        if (file.length() > 246579200L) {
            this.log.error((Object)"checkStorgeFile() file size is hurger than 200M!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] downLoad(int taskType, String fileName) {
        byte[] content = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        String filePath = this.createFilePath(taskType, fileName);
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(FileUtils.getFile((String[])new String[]{filePath})));
            bos = new ByteArrayOutputStream(1024);
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            byte[] byArray = content = bos.toByteArray();
            this.closeStream(bis, bos);
            return byArray;
        }
        catch (IOException e) {
            this.log.error((Object)"IOException error");
        }
        finally {
            this.closeStream(bis, bos);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> downLoadLarge(int taskType, String fileName) {
        ArrayList<byte[]> contentList = new ArrayList<byte[]>();
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        File file = this.initFile(taskType, fileName);
        if (file.length() > 246579200L) {
            this.log.error((Object)"downLoadLarge() file size is hurger than 200M!");
            throw new LegoCheckedException(1297L);
        }
        try {
            int bytesRead;
            String filePath = this.createFilePath(taskType, fileName);
            bis = new BufferedInputStream(new FileInputStream(FileUtils.getFile((String[])new String[]{filePath})));
            bos = new ByteArrayOutputStream(0x100000);
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos = new ByteArrayOutputStream(0x100000);
                bos.write(buff, 0, bytesRead);
                contentList.add(bos.toByteArray());
            }
            ArrayList<byte[]> arrayList = contentList;
            this.closeStream(bis, bos);
            return arrayList;
        }
        catch (IOException e) {
            this.log.error((Object)"IOException error");
        }
        finally {
            this.closeStream(bis, bos);
        }
        return contentList;
    }

    private void closeStream(BufferedInputStream bis, ByteArrayOutputStream bos) {
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                this.log.error((Object)"IOException error");
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                this.log.error((Object)"IOException error");
            }
        }
    }

    private File initFile(int taskType, String fileName) {
        File file = this.createFile(taskType, fileName);
        if (!file.exists()) {
            this.log.error((Object)"checkFile() file path is error file name!");
            throw new LegoCheckedException(1291L);
        }
        return file;
    }

    private File createFile(int taskType, String fileName) {
        String currentPath = this.createFilePath(taskType, fileName);
        File file = new File(currentPath);
        return file;
    }

    private String createFilePath(int taskType, String fileName) {
        String currentPath = null;
        if (taskType == 1) {
            currentPath = LogStorageUtil.getDumpPathByDateType("log_bk") + File.separator;
        } else if (taskType == 2) {
            currentPath = LogStorageUtil.getDumpPathByDateType("alarm_bk") + File.separator;
        }
        return currentPath + fileName;
    }
}

