/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.com.south.sdk.ping;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.LineIterator;

public class LegoPing {
    private static final Log SLOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int MAX_STRING_SIZE = 10240;
    private String osname = System.getProperty("os.name");
    private String pingCmd = "ping -w 0 -n 1";
    private String pingPath = null;
    private String localip = this.getLocalhostIp();
    private int numTry = 3;

    public boolean ping(String host, int retries, int pingTimeout) {
        boolean result = this.execPing(host, retries, pingTimeout);
        if (!result) {
            SLOGGER.info((Object)("ping failed: " + AticUtil.getcleanedMessage(host)));
        }
        return result;
    }

    private String getLocalhostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            SLOGGER.error((Object)("get localaddess failed: " + e.getMessage()));
            return null;
        }
    }

    private String getSolarisPing(String host) {
        this.pingCmd = null == this.localip ? (null == this.pingPath ? "/usr/sbin/ping " : this.pingPath) : (null == this.pingPath ? "/usr/sbin/ping -i " + this.localip : this.pingPath + " -i" + " " + this.localip);
        return this.pingCmd + " " + host + " " + this.numTry;
    }

    private String getLinuxPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "/bin/ping -c " + retries + " -w " + this.numTry : this.pingPath + " -c " + retries + " -w" + " " + this.numTry;
        return this.pingCmd + " " + host;
    }

    private String getFreeBSDPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "/sbin/ping -c " + retries : this.pingPath + " -c " + retries;
        return this.pingCmd + " " + host;
    }

    private String getWindowsPing(String host, int retries, int pingTimeout) {
        this.pingCmd = null == this.pingPath ? "ping -n " + retries + " -w" : this.pingPath + " -n " + retries + " -w";
        return this.pingCmd + " " + pingTimeout * 1000 + " " + host;
    }

    private String getNonWinPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "ping -n " + retries : this.pingPath + " -n " + retries;
        return this.pingCmd + " " + host;
    }

    private boolean execPing(String host, int retries, int pingTimeout) {
        if (!AddressUtil.validateCmd(host)) {
            return false;
        }
        String cmd = this.pingCmd + " " + host;
        if (this.osname.startsWith("SunOS") || this.osname.startsWith("Solaris")) {
            cmd = this.getSolarisPing(host);
        } else if (this.osname.startsWith("Linux")) {
            cmd = this.getLinuxPing(host, retries);
        } else if (this.osname.startsWith("FreeBSD")) {
            cmd = this.getFreeBSDPing(host, retries);
        } else if (this.osname.toLowerCase(Locale.US).contains("windows")) {
            cmd = this.getWindowsPing(host, retries, pingTimeout);
        } else if (!this.osname.startsWith("Windows")) {
            cmd = this.getNonWinPing(host, retries);
        }
        return this.execCmd(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean execCmd(String pingCmdTemp) {
        block46: {
            InputStreamReader errorIr;
            BufferedReader errorIn;
            BufferedReader br;
            InputStreamReader ir;
            Process process;
            block44: {
                ArrayList<String> reponse;
                block42: {
                    String line;
                    String[] para = pingCmdTemp.split("\\s+");
                    ProcessBuilder pb = new ProcessBuilder(para);
                    pb.redirectErrorStream(true);
                    process = null;
                    try {
                        process = pb.start();
                    }
                    catch (IOException e1) {
                        SLOGGER.error((Object)"execCmd IOException error");
                    }
                    ir = null;
                    br = null;
                    StringBuffer errorBuffer = new StringBuffer();
                    errorIn = null;
                    errorIr = null;
                    if (null == process) {
                        SLOGGER.error((Object)"execCmd init process object occurs error, then process is null.");
                        return false;
                    }
                    reponse = new ArrayList<String>();
                    ir = new InputStreamReader(process.getInputStream(), "utf-8");
                    br = new BufferedReader(ir);
                    LineIterator lin = new LineIterator((Reader)br);
                    while (lin.hasNext() && (line = lin.nextLine()).length() <= 10240 && reponse.size() <= 10240) {
                        if ("".equals(line)) continue;
                        reponse.add(line);
                    }
                    errorIr = new InputStreamReader(process.getErrorStream(), "utf-8");
                    errorIn = new BufferedReader(errorIr);
                    String errorStr = "";
                    while ((errorStr = errorIn.readLine()) != null) {
                        if (errorStr.length() <= 0) continue;
                        errorBuffer.append(errorStr);
                        errorBuffer.append("\n\r");
                    }
                    if (errorBuffer.length() > 0) {
                        SLOGGER.error((Object)("errorBuffer content is:" + errorBuffer.toString()));
                    }
                    if (!this.osname.toLowerCase(Locale.US).contains("windows")) break block42;
                    boolean bl = this.parseWindowsResult(reponse);
                    this.closestream(ir, br, errorIr, errorIn);
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                    }
                    catch (Exception e) {
                        try {
                            process.getErrorStream().close();
                            process.getInputStream().close();
                            process.getOutputStream().close();
                        }
                        catch (IOException e1) {
                            SLOGGER.error((Object)("close io occurs error!" + e1.getMessage()));
                        }
                        catch (Exception ee) {
                            SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                        }
                    }
                    return bl;
                }
                if (!this.osname.startsWith("Linux") && !this.osname.startsWith("FreeBSD")) break block44;
                boolean bl = this.parseLinuxResult(reponse);
                this.closestream(ir, br, errorIr, errorIn);
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                }
                catch (Exception e) {
                    try {
                        process.getErrorStream().close();
                        process.getInputStream().close();
                        process.getOutputStream().close();
                    }
                    catch (IOException e1) {
                        SLOGGER.error((Object)("close io occurs error!" + e1.getMessage()));
                    }
                    catch (Exception ee) {
                        SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                    }
                }
                return bl;
            }
            SLOGGER.error((Object)("none support os: " + this.osname));
            this.closestream(ir, br, errorIr, errorIn);
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
            }
            catch (Exception e) {
                try {
                    process.getErrorStream().close();
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    break block46;
                }
                catch (IOException e1) {
                    SLOGGER.error((Object)("close io occurs error!" + e1.getMessage()));
                    break block46;
                }
                catch (Exception ee) {
                    SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                }
            }
            break block46;
            catch (IOException ex) {
                try {
                    SLOGGER.error((Object)"parse response execCmd occurs error.");
                    this.closestream(ir, br, errorIr, errorIn);
                }
                catch (Throwable throwable) {
                    this.closestream(ir, br, errorIr, errorIn);
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                    }
                    catch (Exception e) {
                        try {
                            process.getErrorStream().close();
                            process.getInputStream().close();
                            process.getOutputStream().close();
                        }
                        catch (IOException e1) {
                            SLOGGER.error((Object)("close io occurs error!" + e1.getMessage()));
                        }
                        catch (Exception ee) {
                            SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                        }
                    }
                    throw throwable;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                }
                catch (Exception e) {
                    try {
                        process.getErrorStream().close();
                        process.getInputStream().close();
                        process.getOutputStream().close();
                    }
                    catch (IOException e1) {
                        SLOGGER.error((Object)("close io occurs error!" + e1.getMessage()));
                    }
                    catch (Exception ee) {
                        SLOGGER.error((Object)("close io occurs error!" + e.getMessage()));
                    }
                }
            }
        }
        return false;
    }

    private void closestream(InputStreamReader ir, BufferedReader input, InputStreamReader errorIr, BufferedReader errorInput) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                SLOGGER.error((Object)"close io occurs error");
            }
        }
        if (null != ir) {
            try {
                ir.close();
            }
            catch (IOException e) {
                SLOGGER.error((Object)"close io occurs error");
            }
        }
        if (null != errorIr) {
            try {
                errorIr.close();
            }
            catch (IOException e) {
                SLOGGER.error((Object)"close io occurs error");
            }
        }
        if (null != errorInput) {
            try {
                errorInput.close();
            }
            catch (IOException e) {
                SLOGGER.error((Object)"close io occurs error");
            }
        }
    }

    private boolean parseWindowsResult(List<String> result) {
        for (String line : result) {
            if (line.indexOf("s TTL=") == -1) continue;
            return true;
        }
        return false;
    }

    private boolean parseLinuxResult(List<String> result) {
        for (String line : result) {
            if (line.indexOf("64 bytes from") == -1) continue;
            return true;
        }
        return false;
    }

    public String getPingPath() {
        return this.pingPath;
    }

    public void setPingPath(String pingPath) {
        this.pingPath = pingPath;
    }
}

