/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.base.service.IMoGenerator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AddressUtil;
import com.hs.lego.core.sdk.util.UUIDGenerator;
import java.util.List;

public class LegoMoGenerator
implements IMoGenerator {
    private ICommonDao commDao;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }

    @Override
    public ManagedObject generateMO() {
        TopoObject reValue = null;
        try {
            String hql = "from ManagedObject mo where mo.name ='Management System'";
            List result = this.commDao.findByHql(hql);
            if (result == null || result.isEmpty()) {
                TopoObject mo = new TopoObject();
                mo.setUuid(UUIDGenerator.getInstance().getOneUUID());
                mo.setName("Management System");
                mo.setDescription("Management System");
                mo.setMainType("lego.dic.legosystem.maintype");
                mo.setSubType("lego.dic.legosystem.subtype");
                String ipAddress = AddressUtil.getRealLocalServerIp();
                mo.setIpAddress(ipAddress);
                mo.setIsGroup(false);
                mo.setManaged(true);
                this.commDao.save((Object)mo);
                reValue = mo;
                this.log.info((Object)"+++++++++++++++Management System Managed Object has been generated!!");
            } else {
                TopoObject topoObject = (TopoObject)result.get(0);
                String ip = AddressUtil.getRealLocalServerIp();
                this.log.info((Object)("system ip:" + ip));
                if (!ip.equals(topoObject.getIpAddress())) {
                    topoObject.setIpAddress(ip);
                    reValue = topoObject;
                    this.commDao.saveOrUpdate((Object)reValue);
                }
                reValue = topoObject;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return reValue;
    }
}

