/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.model.Status;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;

public class StartupChecker
implements ServletContextListener {
    private static final String START_FLAG_FILE = "startStatus.falg";
    private static final String START_STATUS = "start.status";
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    private void setStartStatus() {
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "Tomcat6" + File.separator + "bin" + File.separator + START_FLAG_FILE;
        this.setStartStatus(currentPath, Status.STATUS_STARTED.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartStatus(String path, String status) {
        this.log.info((Object)("setStartStatus status is " + AticUtil.getcleanedMessage(status)));
        Properties pro = new Properties();
        FileOutputStream fileOutput = null;
        File flagFile = null;
        try {
            flagFile = FileUtils.getFile((String[])new String[]{path});
            if (flagFile.exists()) {
                this.log.info((Object)("flag file is exist!" + flagFile.getName()));
                return;
            }
            Boolean result = flagFile.createNewFile();
            this.log.info((Object)("flag file: " + flagFile.getName() + " doesn't exist."));
            this.log.info((Object)("create result:" + result));
            if (result.booleanValue()) {
                flagFile.setWritable(true);
                fileOutput = new FileOutputStream(FileUtils.getFile((String[])new String[]{path}));
                pro.setProperty(START_STATUS, status);
                pro.store(fileOutput, "change status");
            }
        }
        catch (IOException e) {
            this.log.error((Object)"setStartStatus error");
        }
        finally {
            if (null != fileOutput) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"setStartStatus error");
                }
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.log.info((Object)"############ write startupchecker ");
        this.setStartStatus();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

