/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.util;

import com.hs.lego.core.base.util.LegoDBProperties;

public class ConverterUtil {
    private static ConverterUtil instance = new ConverterUtil();

    public String convertString(String sourceStr, boolean isWild) {
        String dbType = LegoDBProperties.getDBType();
        if (sourceStr == null) {
            return "%%";
        }
        StringBuilder buffer = new StringBuilder();
        if (isWild) {
            buffer.append('%');
        }
        for (int i = 0; i < sourceStr.length(); ++i) {
            char c = sourceStr.charAt(i);
            if ("sqlserver".equalsIgnoreCase(dbType)) {
                if (this.checkChar(c, '%', '_', '[')) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(']');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (this.checkChar(c, '%', '_', '\\')) {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        if (isWild) {
            buffer.append('%');
        }
        return buffer.toString();
    }

    private boolean checkChar(char ch, char cha, char chb, char chc) {
        return ch == cha || ch == chb || ch == chc;
    }

    public static ConverterUtil getInstance() {
        return instance;
    }
}

