/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 3;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int NUM_2 = 2;
    private static final String TAB = " ";
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(FileUtils.getFile((String[])new String[]{this.getWriteFileName()}));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found exception");
            return;
        }
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
        cellTitle.setCellType(CellType.STRING);
        cellTitle.setCellValue(TAB + this.getTitle());
        HSSFRow rowColUsr = sheet.createRow(1);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(TAB + this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(2);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(TAB + this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 3;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(TAB + lstStr.get(cellNumOfRow));
                    continue;
                }
                cell.setCellValue("");
            }
            ++rowNumOfSheet;
        }
    }

    @Override
    public void closeFile() throws IOException {
        if (null != this.getWriteFileOut()) {
            this.workbook.write((OutputStream)this.getWriteFileOut());
            this.getWriteFileOut().flush();
            this.getWriteFileOut().close();
        }
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailPath) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(FileUtils.getFile((String[])new String[]{this.getWriteFileName()}));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found exception");
            return;
        }
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
        cellTitle.setCellType(CellType.STRING);
        cellTitle.setCellValue(TAB + this.getTitle());
        HSSFRow rowColUsr = sheet.createRow(1);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(TAB + this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(2);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(TAB + this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        String hyperLinkContent = null;
        int rowNumOfSheet = 3;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(TAB + lstStr.get(cellNumOfRow));
                } else {
                    cell.setCellValue("");
                }
                String logId = lstStr.get(lstStr.size() - 1);
                if (logId == null || cellNumOfRow != lstStr.size() - 1) continue;
                HSSFCellStyle linkStyle = this.workbook.createCellStyle();
                HSSFFont font = this.workbook.createFont();
                font.setFontName("Arial");
                font.setUnderline((byte)1);
                font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
                linkStyle.setFont(font);
                String strVal = "";
                if (null != lstStr.get(cellNumOfRow)) {
                    strVal = lstStr.get(cellNumOfRow);
                }
                cell.setCellStyle(linkStyle);
                hyperLinkContent = "HYPERLINK(\"" + detailPath + logId + ".txt\",\"" + strVal + "\")";
                if (this.checkCellFormula(logId)) {
                    cell.setCellFormula(hyperLinkContent);
                    continue;
                }
                cell.setCellValue(strVal);
            }
            ++rowNumOfSheet;
        }
    }

    private boolean checkCellFormula(String logId) {
        return logId.matches("^\\d+$");
    }
}

