/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class FileUtil {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName + "." + this.strExtend);
    }

    public static void createDirectory(String path) {
        File file = new File(path);
        if (!(file.exists() || file.isDirectory() || file.mkdir())) {
            LOG.info((Object)"file.mkdir( ) failed!");
        }
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDetailFile(String fileName, byte[] logDetail) {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(FileUtils.getFile((String[])new String[]{fileName})));
            dos.write(logDetail);
            ((DataOutputStream)dos).flush();
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"IOException error");
            }
        }
    }

    public abstract void writeFile(List<List<String>> var1);

    public abstract void writeFile(List<List<String>> var1, String var2);

    public abstract void closeFile() throws IOException;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }
}

