/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BaseCommonUtil {
    public static final int MAX_LENGTH = 63;
    public static final int MIX_LENGTH = 2;
    private static final String REGEX = "^([a-z0-9][-a-z0-9]{0,62})?(\\.[a-z0-9][-a-z0-9]{0,62})*\\.[a-z][-a-z]{0,62}$";
    private static final String REG = "^([0-9][-0-9]{0,62})?(\\.[0-9][-0-9]{0,62})+$";

    private BaseCommonUtil() {
    }

    public static boolean isDomain(String domain) {
        if (BaseCommonUtil.isNullOrEmpty(domain) || domain.length() < 2 || domain.length() > 63) {
            return false;
        }
        domain = domain.toLowerCase(Locale.ENGLISH);
        Matcher m = Pattern.compile(REG).matcher(domain);
        if (m.matches()) {
            return false;
        }
        if (domain.indexOf("-.") > -1 || domain.endsWith("-")) {
            return false;
        }
        Matcher ma = Pattern.compile(REGEX).matcher(domain);
        return ma.matches();
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || str.trim().isEmpty();
    }
}

