/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public final class LogStorageUtil {
    public static final int MAXNUM = 5000;
    public static final int SLEEPTIME = 100;
    public static final int FIVE_MILLION = 5000000;
    public static final String DIVERT_LOG_TYPE = "divert_log_bk";
    public static final String LOG_BK = "log_bk";
    public static final String ALARM_BK = "alarm_bk";
    public static final int LOG_BK_TYPE_ID = 1;
    public static final int ALARM_BK_TYPE_ID = 2;
    public static final String DUMP_BASE_PATH = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "LegoRuntime";
    private static final int MIN_USE_MEMORY = 50;
    private static final int NUM_1024 = 1024;
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    private LogStorageUtil() {
    }

    public static boolean hasEnoughMemory() {
        long usableMemory = LogStorageUtil.getUsableMemory();
        if (usableMemory > 50L) {
            log.info((Object)("alarm transferAlarm has EnoughMemory,usableMemory:" + usableMemory + " M."));
            return true;
        }
        log.error((Object)("alarm transferAlarm has no EnoughMemory,usableMemory:" + usableMemory + " M."));
        return false;
    }

    private static long getUsableMemory() {
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long usable = max - total + free;
        return usable / 0x100000L;
    }

    public static void createDirectory(String filePath) {
        File path = new File(filePath);
        try {
            boolean result;
            if (!path.isDirectory() && !(result = path.mkdirs())) {
                log.error((Object)"createDirectory error ");
            }
        }
        catch (SecurityException se) {
            log.error((Object)("createDirectory SecurityException :" + se.getMessage()));
        }
    }

    public static String getDumpPathByDateType(String sysOptType) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("taskType", sysOptType);
        ITaskService taskService = (ITaskService)ServiceContext.getInstance().getService("taskService", ITaskService.class);
        List<Task> taskList = taskService.queryTasks(condition);
        if (null == taskList || taskList.isEmpty()) {
            return "";
        }
        Task task = taskList.get(0);
        return task.getParameter().getParameter5();
    }
}

