/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util.tree;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import com.hs.lego.nem.topo.sdk.model.ITreeElements;
import com.hs.lego.nem.topo.sdk.model.TopoView;
import com.hs.lego.nem.topo.sdk.model.UIElement;
import com.hs.lego.nem.topo.sdk.model.UIStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import twaver.Dummy;
import twaver.Element;
import twaver.ElementBox;
import twaver.Follower;
import twaver.Grid;
import twaver.Group;
import twaver.IData;
import twaver.IElement;
import twaver.Link;
import twaver.Node;
import twaver.SerializationSettings;
import twaver.SubNetwork;
import twaver.XMLSerializer;

public class DataExchange {
    private static final String REG_CLIENT_UIID = "UIId";
    private static final String REG_CLIENT_MOID = "id";
    private static final String REG_CLIENT_VISIBLE = "visible";
    private static final String LINK_DIRECTION_SPLIT = "->";
    private static final String NODE_ID_BEGIN = ".";
    private static final String REG_CLIENT_SUBTYPE = "subType";
    private static final String REG_GLOBAL_IMG_KEY = "imgKey";
    private static final String REG_CLIENT_DIS_GROUP = "disgroup";
    private static final String REG_CLIENT_LOGIC_GROUP = "logicgroup";
    private static final String REG_CLIENT_DIS_CTROL = "disctrl";
    private static final String ALARM_STATE = "node.alarm";
    private static final String NODE_STATE = "node.state";
    private static final int TOPO_TYPE_NODE = 0;
    private static final int TOPO_TYPE_NETWORK = 1;
    private static final int TOPO_TYPE_LINK = 2;
    private static final int TOPO_TYPE_GROUP = 3;
    private static final int TOPO_TYPE_FELLOW = 4;
    private static final int TOPO_TYPE_DUMMY = 5;
    private static final int TOPO_TYPE_GRID = 6;
    private Map<String, String> clientProps = new HashMap<String, String>();
    private transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public DataExchange() {
        SerializationSettings.registerGlobalClient(REG_CLIENT_VISIBLE, "string");
        SerializationSettings.registerGlobalStyle(REG_GLOBAL_IMG_KEY, "string");
        SerializationSettings.registerGlobalStyle(ALARM_STATE, "string");
        SerializationSettings.registerGlobalStyle(NODE_STATE, "string");
        this.registerInnerProps();
    }

    private void registerInnerProps() {
        this.registerClientStyleBase(REG_CLIENT_SUBTYPE, "string");
        this.registerClientStyleBase(REG_CLIENT_MOID, "string");
        this.registerClientStyleBase(REG_CLIENT_UIID, "string");
        this.registerClientStyleBase(REG_CLIENT_LOGIC_GROUP, "string");
        this.registerClientStyleBase(REG_CLIENT_DIS_GROUP, "string");
        this.registerClientStyleBase(REG_CLIENT_DIS_CTROL, "string");
    }

    public void registerClientStyle(String clientProp, String type) {
        this.registerClientStyleBase(clientProp, type);
    }

    private void registerClientStyleBase(String clientProp, String type) {
        if (!this.clientProps.containsKey(clientProp)) {
            this.clientProps.put(clientProp, type);
        }
        SerializationSettings.registerGlobalClient(clientProp, type);
    }

    public void registerGlobalProperty(String property, String type) {
        SerializationSettings.registerGlobalProperty(property, type);
    }

    public String getStringByModel(RootDataElement model) {
        return this.getTwaverDatasByTopview(model);
    }

    public long getModelByString(RootDataElement model, String twaverSource) {
        return this.getTopoviewByTwaverData(model, twaverSource);
    }

    public String getTwaverDatasByTopview(TopoView view) {
        ElementBox box = this.getElementBoxByTopView(view);
        XMLSerializer serializer = new XMLSerializer(box);
        return serializer.serialize();
    }

    public long getTopoviewByTwaverData(TopoView curView, String twaverSource) {
        ElementBox box = new ElementBox();
        XMLSerializer serializer = new XMLSerializer(box);
        serializer.deserializeXML(twaverSource);
        return this.reloadElementBox2TopoView(curView, box);
    }

    private Dummy toTwaverDummy(UIElement ele) {
        Dummy dummy = new Dummy();
        this.packageTwaverEleBase(dummy, ele);
        return dummy;
    }

    private void addLegoDummy(Dummy dumy, UIElement ele, ITreeElements curView) {
        ele.setEleType(5L);
        if (ele.getId() == null) {
            curView.addUnStoredUIElement(NODE_ID_BEGIN + dumy.getID().toString(), ele);
        } else {
            curView.removeChildEleUI(ele);
            curView.addChildEle(ele);
        }
    }

    private void packageTwaverEleBase(IElement tEle, UIElement ele) {
        Set<String> styles = ele.getStyleSet().keySet();
        for (String styleName : styles) {
            UIStyle style = ele.getStyleSet().get(styleName);
            if (style == null) continue;
            if (this.isClientProp(styleName)) {
                tEle.setClient(styleName, style.getStyleValue());
                continue;
            }
            tEle.setStyle(style.getStyleName(), style.getStyleValue());
        }
        tEle.setName(ele.getDisName());
        if (tEle.getToolTip() != null) {
            tEle.setToolTip(tEle.getToolTip());
        } else {
            tEle.setToolTip(ele.getDisName());
        }
        tEle.setClient(REG_CLIENT_MOID, ele.getEntityId());
        tEle.setClient(REG_CLIENT_UIID, ele.getId().toString());
        tEle.setClient(REG_CLIENT_SUBTYPE, ele.getEleSubType());
    }

    private Link toTwaverLink(UIElement ele, Map<String, Node> nodesMap) {
        this.log.info((Object)("nodesMap: " + nodesMap));
        Link link = new Link();
        this.packageTwaverEleBase(link, ele);
        return link;
    }

    protected boolean isClientProp(String propName) {
        return this.clientProps.containsKey(propName);
    }

    protected Node toTwaverNode(UIElement ele) {
        Node node = new Node();
        this.toTwaverNodeBase(ele, node);
        return node;
    }

    protected SubNetwork toTwaverSubNetwork(UIElement ele) {
        SubNetwork subNetwork = new SubNetwork();
        this.toTwaverNodeBase(ele, subNetwork);
        return subNetwork;
    }

    protected Follower toTwaverFellow(UIElement ele) {
        Follower fellow = new Follower();
        this.toTwaverNodeBase(ele, fellow);
        return fellow;
    }

    protected Group toTwaverGroup(UIElement ele) {
        Group group = new Group();
        this.toTwaverNodeBase(ele, group);
        return group;
    }

    protected Grid toTwaverGrid(UIElement ele) {
        Grid grid = new Grid();
        this.toTwaverNodeBase(ele, grid);
        return grid;
    }

    protected Node toTwaverNodeBase(UIElement ele, Node node) {
        Map<String, UIStyle> styles = ele.getStyleSet();
        for (UIStyle style : styles.values()) {
            String[] values;
            if (this.isClientProp(style.getStyleName())) {
                node.setClient(style.getStyleName(), style.getStyleValue());
                continue;
            }
            node.setStyle(style.getStyleName(), style.getStyleValue());
            if (style.getStyleName().equalsIgnoreCase("position")) {
                values = style.getStyleValue().split(",");
                node.setLocation(Double.parseDouble(values[0]), Double.parseDouble(values[1]));
            }
            if (style.getStyleName().equalsIgnoreCase("icon")) {
                node.setIcon(style.getStyleValue());
            }
            if (!style.getStyleName().equalsIgnoreCase("size")) continue;
            values = style.getStyleValue().split(",");
            node.setHeight(Double.parseDouble(values[0]));
            node.setWidth(Double.parseDouble(values[1]));
        }
        node.setClient(REG_CLIENT_MOID, ele.getEntityId());
        node.setClient(REG_CLIENT_UIID, ele.getId().toString());
        node.setClient(REG_CLIENT_SUBTYPE, ele.getEleSubType());
        node.setName(ele.getDisName());
        if (ele.getAliasName() != null) {
            node.setToolTip(ele.getAliasName());
        } else {
            node.setToolTip(ele.getDisName());
        }
        return node;
    }

    protected ElementBox getElementBoxByTopView(TopoView view) {
        ElementBox box = new ElementBox();
        Map<String, UIStyle> viewStyles = view.getStyleSet();
        Set<Map.Entry<String, UIStyle>> set = viewStyles.entrySet();
        for (Map.Entry<String, UIStyle> temp : set) {
            String styleName = temp.getKey();
            UIStyle style = temp.getValue();
            box.setStyle(styleName, style.getStyleValue());
        }
        box.setName(view.getDisName());
        HashMap<String, Node> nodesMap = new HashMap<String, Node>();
        HashMap<String, Link> linkMap = new HashMap<String, Link>();
        this.processTwaverElementBase(view, null, box, nodesMap, linkMap);
        this.updataLinkRelations(linkMap, nodesMap);
        return box;
    }

    protected void updataLinkRelations(Map<String, Link> links, Map<String, Node> nodesMap) {
        Set<Map.Entry<String, Link>> set = links.entrySet();
        boolean formNodeIndex = true;
        int toNodeIndex = 2;
        for (Map.Entry<String, Link> temp : set) {
            String key = temp.getKey();
            Link link = temp.getValue();
            String[] ids = key.split(LINK_DIRECTION_SPLIT);
            link.setFromNode(nodesMap.get(ids[1]));
            link.setToNode(nodesMap.get(ids[2]));
        }
    }

    protected void processTwaverElementBase(ITreeElements parentEle, IElement tParentEle, ElementBox box, Map<String, Node> nodesMap, Map<String, Link> linkMap) {
        for (UIElement child : parentEle.getChildEleUI()) {
            Element tEleCur = null;
            Long eleType = child.getEleType();
            if (eleType.equals(0L)) {
                Node node = this.toTwaverNode(child);
                nodesMap.put(child.getEntityId(), node);
                tEleCur = node;
            }
            if (eleType.equals(1L)) {
                SubNetwork subNetwork = this.toTwaverSubNetwork(child);
                nodesMap.put(child.getEntityId(), subNetwork);
                tEleCur = subNetwork;
            }
            if (eleType.equals(3L)) {
                Group group = this.toTwaverGroup(child);
                nodesMap.put(child.getEntityId(), group);
                tEleCur = group;
            }
            if (eleType.equals(4L)) {
                Follower follower = this.toTwaverFellow(child);
                nodesMap.put(child.getEntityId(), follower);
                tEleCur = follower;
            }
            if (eleType.equals(5L)) {
                Dummy dummy = this.toTwaverDummy(child);
                tEleCur = dummy;
            }
            if (eleType.equals(6L)) {
                Grid grid = this.toTwaverGrid(child);
                nodesMap.put(child.getEntityId(), grid);
                tEleCur = grid;
            }
            if (tEleCur != null) {
                tEleCur.setClient(REG_CLIENT_VISIBLE, String.valueOf(child.isAuthVisible()));
            }
            if (tParentEle != null) {
                tParentEle.addChild(tEleCur);
            }
            if (tEleCur == null) continue;
            this.processTwaverElementBase(child, tEleCur, box, nodesMap, linkMap);
            box.add(tEleCur);
        }
        for (UIElement child : parentEle.getChildEleUI()) {
            Long eleType = child.getEleType();
            String appInfo = child.getAppendixInfo();
            if (!eleType.equals(2L) || appInfo == null) continue;
            Link link = this.toTwaverLink(child, nodesMap);
            appInfo = child.getId().toString().concat(LINK_DIRECTION_SPLIT).concat(appInfo);
            linkMap.put(appInfo, link);
            box.add(link);
            if (tParentEle == null) continue;
            tParentEle.addChild(link);
        }
    }

    protected long reloadElementBox2TopoView(TopoView curView, ElementBox box) {
        this.toLegoView(curView, box);
        List<?> datas = box.getDatas();
        if (!datas.isEmpty()) {
            for (Element tEle : datas) {
                if (tEle.getParent() != null) continue;
                this.reloadElementBox2TopoObjectBase(curView, tEle, box);
            }
        }
        return 0L;
    }

    protected void removeUnExistElements(ITreeElements parentEle) {
        HashSet<UIElement> unExistElements = new HashSet<UIElement>();
        Set<UIElement> childs = parentEle.getChildEleUI();
        for (UIElement child : childs) {
            if (child.isExistInLayout()) continue;
            unExistElements.add(child);
        }
        for (UIElement delChild : unExistElements) {
            parentEle.removeChildEleUI(delChild);
        }
        childs = parentEle.getChildEleUI();
        for (UIElement child : childs) {
            this.removeUnExistElements(child);
        }
    }

    protected void reloadElementBox2TopoObjectBase(ITreeElements parentEle, Element tEle, ElementBox box) {
        UIElement element = this.packUIElementByTwaverElement(tEle);
        if (tEle instanceof Dummy) {
            this.addLegoDummy((Dummy)tEle, element, parentEle);
        } else if (tEle instanceof SubNetwork) {
            this.addLegoSubNetwork((SubNetwork)tEle, element, parentEle);
        } else if (tEle instanceof Group) {
            this.addLegoGroup((Group)tEle, element, parentEle);
        } else if (tEle instanceof Grid) {
            this.addLegoGrid((Grid)tEle, element, parentEle);
        } else if (tEle instanceof Follower) {
            this.addLegoFellow((Follower)tEle, element, parentEle);
        } else if (tEle instanceof Node) {
            this.addLegoNode((Node)tEle, element, parentEle);
        } else if (tEle instanceof Link) {
            this.addLegoLink((Link)tEle, element, parentEle);
        }
        int childCount = tEle.getChildrenCount();
        for (int index = 0; index < childCount; ++index) {
            IData data = tEle.getChildAt(index);
            Element curEle = (Element)box.getElementByID(data.getID());
            this.reloadElementBox2TopoObjectBase(element, curEle, box);
        }
    }

    private UIElement packUIElementByTwaverElement(Element tEle) {
        Set<Map.Entry<String, Object>> tempSet;
        String id;
        UIElement ele = new UIElement();
        Object obj = tEle.getClient(REG_CLIENT_UIID);
        if (obj != null) {
            id = (String)obj;
            ele.setId(Long.parseLong(id));
        }
        if ((obj = tEle.getClient(REG_CLIENT_MOID)) != null) {
            id = (String)obj;
            ele.setEntityId(id);
        }
        if ((obj = tEle.getClient(REG_CLIENT_SUBTYPE)) != null) {
            String subType = (String)obj;
            ele.setEleSubType(subType);
        }
        ele.setDisName(tEle.getName());
        ele.addStyle(new UIStyle("icon", tEle.getIcon()));
        ele.addStyle(new UIStyle("toolTip", tEle.getToolTip()));
        Set<String> clientStyles = this.clientProps.keySet();
        for (String prop : clientStyles) {
            Object style = tEle.getClient(prop);
            if (style == null) continue;
            ele.addStyle(new UIStyle(prop, style.toString()));
        }
        Map<String, Object> styles = tEle.getStyleProperties();
        if (styles != null && (tempSet = styles.entrySet()) != null) {
            for (Map.Entry<String, Object> temp : tempSet) {
                ele.addStyle(new UIStyle(temp.getKey(), temp.getValue().toString()));
            }
        }
        ele.setIsExistInLayout(true);
        return ele;
    }

    private void addLegoNode(Node node, UIElement ele, ITreeElements curView) {
        ele.setEleType(0L);
        this.addLegoNodeBase(node, ele, curView);
    }

    private void addLegoFellow(Follower fellow, UIElement ele, ITreeElements curView) {
        ele.setEleType(4L);
        this.addLegoNodeBase(fellow, ele, curView);
    }

    private void addLegoGrid(Grid grid, UIElement ele, ITreeElements curView) {
        ele.setEleType(6L);
        this.addLegoNodeBase(grid, ele, curView);
    }

    private void addLegoGroup(Group group, UIElement ele, ITreeElements curView) {
        ele.setEleType(3L);
        this.addLegoNodeBase(group, ele, curView);
    }

    private void addLegoNodeBase(Node node, UIElement ele, ITreeElements curView) {
        ele.addStyle(new UIStyle("image", node.getImage()));
        String pos = node.getLocation().getX() + "," + node.getLocation().getY();
        ele.addStyle(new UIStyle("position", pos));
        String size = node.getHeight() + "," + node.getWidth();
        ele.addStyle(new UIStyle("size", size));
        if (ele.getId() == null) {
            curView.addUnStoredUIElement(NODE_ID_BEGIN + node.getID().toString(), ele);
        } else {
            curView.removeChildEleUI(ele);
            curView.addChildEle(ele);
        }
    }

    private void addLegoSubNetwork(Node node, UIElement ele, ITreeElements curView) {
        ele.setEleType(1L);
        this.addLegoNodeBase(node, ele, curView);
    }

    private void addLegoLink(Link link, UIElement ele, ITreeElements curView) {
        boolean updateLink = true;
        ele.setEleType(2L);
        Node fnode = link.getFromNode();
        Node tnode = link.getToNode();
        if (fnode != null && tnode != null) {
            String fValue;
            Object tObj;
            Object fObj = link.getFromNode().getClient(REG_CLIENT_MOID);
            if (this.isObjNotNull(fObj, tObj = link.getToNode().getClient(REG_CLIENT_MOID))) {
                ele.setAppendixInfo(fObj.toString() + LINK_DIRECTION_SPLIT + tObj.toString());
                updateLink = false;
            }
            if (this.isObjOneNull(fObj, tObj)) {
                fValue = NODE_ID_BEGIN + link.getFromNode().getID().toString();
                ele.setAppendixInfo(fValue + LINK_DIRECTION_SPLIT + tObj.toString());
            }
            if (this.isObjOneNull(tObj, fObj)) {
                String tValue = NODE_ID_BEGIN + link.getToNode().getID().toString();
                ele.setAppendixInfo(fObj.toString() + LINK_DIRECTION_SPLIT + tValue);
            }
            if (this.isObjNull(fObj, tObj)) {
                fValue = NODE_ID_BEGIN + link.getFromNode().getID().toString();
                String tValue = NODE_ID_BEGIN + link.getToNode().getID().toString();
                ele.setAppendixInfo(fValue + LINK_DIRECTION_SPLIT + tValue);
            }
        }
        if (ele.getId() == null) {
            curView.addUnStoredUIElement(NODE_ID_BEGIN + link.getID().toString(), ele);
        } else if (updateLink) {
            curView.removeChildEleUI(ele);
            curView.addUnStoredUIElement(NODE_ID_BEGIN + link.getID().toString(), ele);
        } else {
            curView.removeChildEleUI(ele);
            curView.addChildEle(ele);
        }
    }

    private boolean isObjNull(Object fObj, Object tObj) {
        return fObj == null && tObj == null;
    }

    private boolean isObjNotNull(Object fObj, Object tObj) {
        return fObj != null && tObj != null;
    }

    private boolean isObjOneNull(Object obja, Object objb) {
        return obja == null && objb != null;
    }

    private void toLegoView(TopoView curView, ElementBox box) {
        Map<String, Object> map = box.getStyleProperties();
        if (map != null && !map.isEmpty()) {
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> temp : set) {
                String key = temp.getKey();
                String value = (String)temp.getValue();
                curView.addStyle(new UIStyle(key, value));
            }
        }
    }
}

