/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.syslog.service;

import com.hs.lego.core.system.syslog.sdk.model.OptLogMo;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TranslateObject {
    private static final String SPLIT = "\n";
    private static final int TARGET_LOCAL_TRUE = 1;
    private static final int TARGET_LOCAL_FALSE = 0;
    private static final int DETAILS_SUBSTRING_INDEX_BEGINNING = 0;
    private static final int DETAILS_SUBSTRING_INDEX_END = 255;
    private static Map<String, String> conversionCharMap = null;
    private static Map<String, String> conversionCodeMap = null;

    private TranslateObject() {
    }

    public static OptLogMo translateSysOptLogBo(SysOptLog oSysLog) {
        OptLogMo tmpOptLogMo = new OptLogMo();
        if (null != oSysLog.getDetail()) {
            int detailLength = oSysLog.getDetail().length();
            String detailSubString = 255 < detailLength ? oSysLog.getDetail().substring(0, 255) : oSysLog.getDetail();
            tmpOptLogMo.setOpDetail(detailSubString);
        }
        tmpOptLogMo.setOpIpAddress(oSysLog.getTerminalIp());
        tmpOptLogMo.setOpName(oSysLog.getOperation());
        tmpOptLogMo.setOpResult(oSysLog.getResult());
        if (null == oSysLog.getDate()) {
            tmpOptLogMo.setOpTime(System.currentTimeMillis());
        } else {
            tmpOptLogMo.setOpTime(oSysLog.getDate().getTime());
        }
        tmpOptLogMo.setOptModuleName(oSysLog.getModule());
        tmpOptLogMo.setOpUser(oSysLog.getOperator());
        tmpOptLogMo.setRiskLevel(oSysLog.getLevel());
        if (oSysLog.getTargetLocal().booleanValue()) {
            tmpOptLogMo.setTargetLocal(1);
        } else {
            tmpOptLogMo.setTargetLocal(0);
        }
        if (oSysLog.getTarget() == null || oSysLog.getTarget().equals("")) {
            tmpOptLogMo.setOpTarget(oSysLog.getModule());
            tmpOptLogMo.setTargetLocal(1);
        } else {
            tmpOptLogMo.setOpTarget(oSysLog.getTarget());
        }
        String[] param = oSysLog.getDetailPara();
        StringBuffer buffer = new StringBuffer("");
        if (null != param && param.length > 0) {
            int paraLenth = param.length;
            for (int i = 0; i < paraLenth; ++i) {
                buffer.append(param[i]);
                if (i == paraLenth - 1) continue;
                buffer.append(SPLIT);
            }
        }
        tmpOptLogMo.setOpDetailPama(buffer.toString());
        StringBuffer targetBuffer = TranslateObject.getargetParam(oSysLog);
        tmpOptLogMo.setOpTargetPama(targetBuffer.toString());
        tmpOptLogMo.setHasDetail(oSysLog.getHasDetail());
        return tmpOptLogMo;
    }

    private static StringBuffer getargetParam(SysOptLog oSysLog) {
        String[] targetParam = oSysLog.getTargetPara();
        StringBuffer targetBuffer = new StringBuffer("");
        if (null != targetParam && targetParam.length > 0) {
            int paraLenth = targetParam.length;
            for (int i = 0; i < paraLenth; ++i) {
                targetBuffer.append(targetParam[i]);
                if (i == paraLenth - 1) continue;
                targetBuffer.append(SPLIT);
            }
        }
        return targetBuffer;
    }

    public static SysOptLog translateSysOptLogMo(OptLogMo oSysLogMo) {
        SysOptLog sysOptlog = new SysOptLog();
        sysOptlog.setId(oSysLogMo.getId());
        sysOptlog.setDetail(oSysLogMo.getOpDetail());
        sysOptlog.setTerminalIp(oSysLogMo.getOpIpAddress());
        sysOptlog.setOperation(oSysLogMo.getOpName());
        sysOptlog.setTarget(TranslateObject.reductionStr(oSysLogMo.getOpTarget()));
        sysOptlog.setResult(oSysLogMo.getOpResult());
        sysOptlog.setDate(new Date(oSysLogMo.getOpTime()));
        sysOptlog.setModule(oSysLogMo.getOptModuleName());
        sysOptlog.setOperator(oSysLogMo.getOpUser());
        sysOptlog.setLevel(oSysLogMo.getRiskLevel());
        String param = TranslateObject.reductionStr(oSysLogMo.getOpDetailPama());
        String[] detailParam = null;
        if (!param.equals("")) {
            detailParam = param.split(SPLIT);
        }
        sysOptlog.setDetailPara(detailParam);
        if (oSysLogMo.getTargetLocal() > 0) {
            sysOptlog.setTargetLocal(Boolean.TRUE);
        } else {
            sysOptlog.setTargetLocal(Boolean.FALSE);
        }
        String targetParam = TranslateObject.reductionStr(oSysLogMo.getOpTargetPama());
        String[] targetParams = null;
        if (!targetParam.equals("")) {
            targetParams = targetParam.split(SPLIT);
        }
        sysOptlog.setTargetPara(targetParams);
        sysOptlog.setHasDetail(oSysLogMo.getHasDetail());
        return sysOptlog;
    }

    public static String reductionStr(String str) {
        if (null == str) {
            return "";
        }
        if (!str.contains("&")) {
            return str;
        }
        Set<Map.Entry<String, String>> set = conversionCharMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!str.contains(entry.getKey())) continue;
            str = str.replace(entry.getKey(), entry.getValue());
        }
        return str;
    }

    public static List<SysOptLog> translateLstSysOptLogMo(List<OptLogMo> oSysLogMo) {
        ArrayList<SysOptLog> lstSysOptLog = new ArrayList<SysOptLog>();
        for (OptLogMo oOptLogMo : oSysLogMo) {
            lstSysOptLog.add(TranslateObject.translateSysOptLogMo(oOptLogMo));
        }
        return lstSysOptLog;
    }

    public static String longToStringData(long lMilliSecond) {
        Date dt = new Date(lMilliSecond);
        SimpleDateFormat dfToString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = dfToString.format(dt);
        return sDate;
    }

    public static Long stringToMilliSecondData(String sTime) throws ParseException {
        SimpleDateFormat dfToString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dt = dfToString.parse(sTime);
        return dt.getTime();
    }

    public static String getDoFieldNameByBoFieldName(String boFieldName) {
        if (boFieldName.equals("operation")) {
            return "opName";
        }
        if (boFieldName.equals("level")) {
            return "riskLevel";
        }
        if (boFieldName.equals("operator")) {
            return "opUser";
        }
        if (boFieldName.equals("date")) {
            return "opTime";
        }
        if (boFieldName.equals("module")) {
            return "optModuleName";
        }
        if (boFieldName.equals("terminalIp")) {
            return "opIpAddress";
        }
        if (boFieldName.equals("target")) {
            return "opTarget";
        }
        if (boFieldName.equals("result")) {
            return "opResult";
        }
        if (boFieldName.equals("detail")) {
            return "opDetail";
        }
        return "id";
    }

    public static String handlingSpecialCharacters(String str) {
        if (str.contains("&")) {
            str = str.replace("&", "&amp;");
        }
        Set<Map.Entry<String, String>> set = conversionCodeMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!str.contains(entry.getKey())) continue;
            str = str.replace(entry.getKey(), entry.getValue());
        }
        return str;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&lt;", "\uff1c");
        map.put("&gt;", "\uff1e");
        map.put("&amp;", "\uff06");
        map.put("&quot;", "\uff02");
        map.put("&#61;", "\uff1d");
        map.put("&#45;", "\uff0d");
        map.put("&#43;", "\uff0b");
        map.put("&#64;", "\uff20");
        map.put("&#47;", "\uff0f");
        map.put("&#39;", "\uff07");
        conversionCharMap = Collections.unmodifiableMap(map);
        HashMap<String, String> conversionMap = new HashMap<String, String>();
        conversionMap.put("<", "&lt;");
        conversionMap.put(">", "&gt;");
        conversionMap.put("\"", "&quot;");
        conversionMap.put("=", "&#61;");
        conversionMap.put("-", "&#45;");
        conversionMap.put("+", "&#43;");
        conversionMap.put("@", "&#64;");
        conversionMap.put("/", "&#47;");
        conversionMap.put("'", "&#39;");
        conversionCodeMap = Collections.unmodifiableMap(conversionMap);
    }
}

